/***************************************************************************
 *                                                                         *
 *   SYNINITA.CPP                                                          *
 *                                                                         *
 *   Copyright (c) 1998       Galacticomm, Inc.    All Rights Reserved.    *
 *                                                                         *
 *   Active HTML File Library Initial Synthesis                            *
 *   Implementation                                                        *
 *                                                                         *
 *                                                - Phil Henning 10/16/98  *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "galacth.h"
#include "dnf.h"
#include "dnfmgr.h"
#include "ahutil.h"
#include "syninita.h"
#include "galfilah.h"


#define FILREV "$Revision: 5 $"

dnfStep dnfFrameSteps[]={
     dnfStep(DNFMAPEND)
};
dnfMap filFrameMap(PPFIX "/indexf.htm","Frames Response",dnfFrameSteps);

dnfStep dnfNoFrameSteps[]={
     dnfStep(DNFMAPEND)
};
dnfMap filNoFrameMap(PPFIX "/indexn.htm","NoFrames Response",dnfNoFrameSteps);

//
//  Default URL Synthesis Member Functions
//

ACTHCODE
synInitial::proceedRequest()            // setup request context
{
     ACTHCODE rc=synBaseAuth::proceedRequest();
     bool bFrameMod=false;

     if (rc != ACTHMORE) {
          return(rc);
     }
     bool bIsAuth=(m_usr != NULL);
     m_inframes=theFilAgent->LoadFramePref(bIsAuth ? m_usr->userid() : NULL);
     if (ses->param("useframes")) {
          INT sz=ses->paramRoom("useframes")+1;
          CHAR* buf=new CHAR[sz];
          ses->param("useframes",buf,sz);

          if (sameas(buf,"1")) {
               m_inframes=true;
          }
          else if (sameas(buf,"0")) {
               m_inframes=false;
          }
          else if (sameas(buf,"~")) {
               m_inframes=(!m_inframes);
          }
          else if (sameas(buf,"1 set")) {
               m_inframes=true;
               bFrameMod=bIsAuth;
          }
          else if (sameas(buf,"0 set")) {
               m_inframes=false;
               bFrameMod=bIsAuth;
          }
          else if (sameas(buf,"~ set")) {
               m_inframes=(!m_inframes);
               bFrameMod=bIsAuth;
          }
          delete [] buf;
     }
     m_SynState=SYNSTATE_SYNTH;
     if (bFrameMod) {
          theFilAgent->SaveFramePref(m_usr->userid(),m_inframes);
     }
     return(rc);
}

ACTHCODE
synInitial::proceedSynth()              // proceed with synthesis
{
     m_SynState=SYNSTATE_RESPONSE;
     return(ACTHMORE);
}

ACTHCODE
synInitial::proceedDerivedResponse()    // proceed with response
{
     ACTHCODE rc=ACTHMORE;

     if (m_dnf == NULL) {
          const CHAR* pCookieVal=(m_inframes ? "1" : "0");
          string strRedirloc=m_inframes ? theFilAgent->m_strRedirFrame
                                        : theFilAgent->m_strRedirNoFrame;
          dnfMap* pMap=(m_inframes ? &filFrameMap : &filNoFrameMap);
          CHAR ch=m_inframes ? 'F' : 'N';

          if (m_onsuccessFile != NULL) {
               strRedirloc=m_onsuccessFile;
          }
          else if (strRedirloc.length() == 0
           || ses->urlargc() != m_lvlcnt) {
               CHAR* fnbuf;
               if (ses->urlargc() > m_lvlcnt) {
                    const CHAR* fnptr=ses->urlargv(m_lvlcnt);
                    fnbuf=new CHAR[strlen(fnptr)+1];
                    strcpy(fnbuf,fnptr);
               }
               else {
                    fnbuf=new CHAR[sizeof("INDEX*.HTM")+1];
                    strcpy(fnbuf,"INDEX*.HTM");
               }
               strRedirloc=fnbuf;
               delete [] fnbuf;
          }
          if (isProtocol(strRedirloc.c_str()) || strRedirloc[0] == '/') {
               ses->setStatus("302 Redirect");
               ostrstream ost;
               if (strRedirloc[0] == '/') {
                    ost << "http://" << ses->host() << strRedirloc.c_str() << ends;
               }
               else {
                    ost << strRedirloc.c_str() << ends;
               }
               ses->headerField("Location",ost.str());
               ses->contypeMIME("text/html");
               bout << "Request redirected to: <A HREF=\"" << ost.str();
               bout << "\">" << ost.str() << "</A>" << crlf;
               ost.rdbuf()->freeze(0);
               rc=ACTHDONE;
          }
          else {
               CHAR* fnbuf=new CHAR[strRedirloc.length()+1];
               strcpy(fnbuf,strRedirloc.c_str());
               strrpl(fnbuf,'*',ch);
               string strfname=PPFIX "/";
               strfname+=fnbuf;
               m_dnf=dnfCreateHandler(&bout,pMap,strfname.c_str());
               delete [] fnbuf;
          }
          setCookie(FRAMECOOKIE,pCookieVal,NULL,NULL,NULL,false,ses);
     }
     else if (m_dnf->process() == DNFEND) {
          rc=ACTHDONE;
     }
     return(rc);
}

INT
synInitial::translateError()            // translate err to mcv file op
{
     m_errtext=spr("%d",m_err);
     return(ERROOPS);
}
