/***************************************************************************
 *                                                                         *
 *   SYNGFIL.CPP                                                           *
 *                                                                         *
 *   Copyright (c) 1998       Galacticomm, Inc.    All Rights Reserved.    *
 *                                                                         *
 *   Active HTML File Library Generic File Synthesis                       *
 *   Implementation                                                        *
 *                                                                         *
 *                                                - Phil Henning 11/19/98  *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "galacth.h"
#include "dnf.h"
#include "dnfmgr.h"
#include "ahutil.h"
#include "filtvb.h"
#include "filagent.h"
#include "syngfil.h"
#include "galfilah.h"

#define FILREV "$Revision: 3 $"

static
dnfStep dnfSuccessSteps[]={
     dnfStep(DNFMAPEND)
};
static
dnfMap filSuccessMap(PPFIX "/file/index.htm","Success Response",dnfSuccessSteps);


ACTHCODE
synGenericFile::proceedRequest()            // setup request context
{
     ACTHCODE rc=synBaseAuth::proceedRequest();
     m_SynState=SYNSTATE_SYNTH;
     return(rc);
}

ACTHCODE
synGenericFile::proceedSynth()              // proceed with synthesis
{
     m_SynState=SYNSTATE_RESPONSE;
     return(ACTHMORE);
}

ACTHCODE
synGenericFile::proceedDerivedResponse()    // proceed with response
{
     ACTHCODE rc=ACTHMORE;

     if (m_dnf == NULL) {
          m_dnf=dnfCreateHandlerURL(ses,&filSuccessMap,PPFIX);
          if (m_dnf != NULL) {
               CHAR fileExtension[GCMAXEXT+1];
               const CHAR* fileName=m_dnf->getMap().getFile();
               fileparts(GCPART_EXTN,fileName,fileExtension,GCMAXEXT+1);
               ses->contypeFext(fileExtension);
          }
     }
     else if (m_dnf->process() == DNFEND) {
          rc=ACTHDONE;
     }
     return(rc);
}

INT
synGenericFile::translateError()            // translate err to mcv file op
{
     m_errtext=spr("%d",m_err);
     return(ERROOPS);
}


