/***************************************************************************
 *                                                                         *
 *   SYNFUP.H                                                              *
 *                                                                         *
 *   Copyright (c) 1998       Galacticomm, Inc.    All Rights Reserved.    *
 *                                                                         *
 *   Active HTML File Upload Synthesis                                     *
 *   Declaration                                                           *
 *                                                                         *
 *                                                - Phil Henning 12/09/98  *
 *                                                                         *
 ***************************************************************************/

#ifndef __SYNFUP_H
#define __SYNFUP_H

#include "synfilah.h"
#include "filtdef.h"

#define WCHKSIZ     2048

class synFileUp : public synBaseAuth {     // /upload URL
public:
     synFileUp(
     acthSession* _ses,
     bool anonok,
     INT lvlcnt=0);

     ~synFileUp();
public:
     VOID abort();                      // synthesis abort

protected:
     ACTHCODE
     proceedRequest();                  // setup request context

     ACTHCODE
     proceedSynth();                    // proceed with synthesis

     ACTHCODE
     proceedDerivedResponse();          // proceed with response

     bool
     fileExists(                        // does file exist?
     const CHAR* fname);                // filename

     bool
     fileExistsGlobal(                  // does file exist in any lib?
     const CHAR* fname);                // filename

     string                             // the filename
     getFileName();                     // get filename from parameter

     bool                               // stream was opened ok
     getFileStream();                   // get file stream

     bool                               // are we done?
     writeFileStream();                 // write file stream to disk

     VOID
     preventTimeout();                  // prevent browser timeout

     bool
     FileSizeOk();                      // is file size ok?

     VOID
     formatDesc(                        // format incoming file desc
     CHAR *desc,                        //   raw description text
     INT descBufSize);                  //   max desc buffer size

     VOID
     addKeys(                           // add to keyword database
     const CHAR *libname,               //   library for file
     const CHAR *filename,              //   file name
     const CHAR *desc);                 //   file description

     const CHAR *                       //   approval date string or NOTAPPED
     approval(                          // get approval date for new upload
     fllib *libptr);                    //   libary info

     VOID
     delfile();                         // delete file from lib

     VOID
     delkwds();                         // delete keywords

     bool
     ok2overwrite();                    // can this file be overwritten?

     bool
     canUserOverwrite();                // can current user overwrite?

     INT
     translateError();                  // translate err to mcv file op

private:
     struct flfile  m_File;             // file structure
     struct fllib*  m_pLib;             // ptr to lib
     string         m_strLib;           // name of lib
     string         m_strDesc;          // file description
     string         m_strRealFileName;  // actual file name
     string         m_strFileName;      // temp file name
     string         m_strHeldName;      // held file name
     errorcodes     m_holderr;          // hold errorcode
     bool           m_bHold;            // do we have to/are we holding this file
     bool           m_bRespToHold;      // is this a response to a hold
     bool           m_bOverWrite;       // overwrite the file if exists?
     string         m_strRealFilePathName; // real file and path name
     string         m_strFilePathName;  // temp file and path name
     ofstream*      m_ofstr;            // output stream for file
     istream*       m_ulistr;           // input stream for file reading
     CHAR           m_writeBuf[WCHKSIZ]; // write buffer for file streaming
     struct ffblk   m_fb;               // file block struct
     bool           m_uploading;        // are we currently uploading?
     bool           m_moving;           // are we currently moving the file?
     bool           m_bCanceled;        // was the upload canceled?
     string         m_strOrigFileName;  // original file name
};

const CHAR *                       //   return pointer to "good" file name
cvtfname(                          // convert file name to DOS convention
const CHAR *badfname);

bool
isValidFileName(                   /* is this a valid DOS file name?       */
const CHAR *fileName);             /*   file name to check                 */

bool
isValidFileNameChar(               /* is this a valid DOS file name char?  */
CHAR c);                           /*   character to test                  */

#endif // __SYNFUP_H

