/***************************************************************************
 *                                                                         *
 *   SYNFPREF.H                                                            *
 *                                                                         *
 *   Copyright (c) 1998       Galacticomm, Inc.    All Rights Reserved.    *
 *                                                                         *
 *   Active HTML File Libraries Synthesis                                  *
 *   Declaration                                                           *
 *                                                                         *
 *                                                - Phil Henning 12/15/98  *
 *                                                                         *
 ***************************************************************************/

#ifndef __SYNFPREF_H
#define __SYNFPREF_H

#include "synfilah.h"
#include "filtdef.h"

class synSetPrefs : public synBaseAuth {     // /prefs URL
public:
     synSetPrefs(
     acthSession* _ses,
     bool anonok,
     INT lvlcnt=0);

     ~synSetPrefs();

protected:
     ACTHCODE
     proceedRequest();                       // setup request context

     ACTHCODE
     proceedSynth();                         // proceed with synthesis

     ACTHCODE
     proceedDerivedResponse();               // proceed with response

     INT
     translateError();                       // translate err to mcv file op

private:
     VOID
     checkOverride(                          // check override parameter
     const CHAR* stg);                       // contents of parameter

private:
     bool           m_bOWuseframes;          // override - use frames param
     bool           m_bUseFrames;            // use frames?
     string         m_strDefaultLib;         // default lib
     LISTORDER      m_LibOrder;              // lib list order
     LISTORDER      m_FileOrder;             // file browse order
     SEARCHTYPE     m_SearchType;            // browse type
     bool           m_bUseFramesSet;         // set the use frames param?
     bool           m_bLibSet;               // set the default lib?
     bool           m_bLibOrderSet;          // set lib list order?
     bool           m_bFileOrderSet;         // set file browse order?
     bool           m_bSearchTypeSet;        // set browse type?
};

#endif // __SYNFPREF_H

