/***************************************************************************
 *                                                                         *
 *   SYNFPREF.CPP                                                          *
 *                                                                         *
 *   Copyright (c) 1998       Galacticomm, Inc.    All Rights Reserved.    *
 *                                                                         *
 *   Active HTML File Libraries Preferences                                *
 *   Implementation                                                        *
 *                                                                         *
 *                                                - Phil Henning 12/15/98  *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "galacth.h"
#include "dnf.h"
#include "dnfmgr.h"
#include "ahutil.h"
#include "filtvb.h"
#include "synfpref.h"
#include "filagent.h"
#include "galfilah.h"

#define FILREV "$Revision: 4 $"

#define OVERRIDEDELIM ","

static
dnfStep dnfSuccessSteps[]={
     dnfStep(DNFMAPEND)
};
static
dnfMap filSuccessMap(PPFIX "/prefs/index.htm","Success Response",dnfSuccessSteps);

static
dnfStep dnfErrorSteps[]={
     dnfStep(DNFMAPEND)
};
static
dnfMap filErrorMap(PPFIX "/prefs/error.htm","Error Response",dnfErrorSteps);

//
//  Set Preferences Synthesis Member Functions
//


synSetPrefs::synSetPrefs(
acthSession* _ses,
bool anonok,
INT lvlcnt)   : synBaseAuth(_ses,anonok,theFilAgent->m_hfilkey,lvlcnt)
               , m_bOWuseframes(false)
               , m_bUseFrames(false)
               , m_LibOrder(ORDER_ASCEND)
               , m_FileOrder(ORDER_ASCEND)
               , m_SearchType(STYPE_NAME)
               , m_bUseFramesSet(false)
               , m_bLibSet(false)
               , m_bLibOrderSet(false)
               , m_bFileOrderSet(false)
               , m_bSearchTypeSet(false)
               , m_strDefaultLib("")
{
}

synSetPrefs::~synSetPrefs()
{
}


ACTHCODE
synSetPrefs::proceedRequest()           // setup request context
{
     ACTHCODE rc=synBaseAuth::proceedRequest();

     if (rc != ACTHMORE) {
          return(rc);
     }
     if (ses->param("override")) {
          INT sz=ses->paramRoom("override");
          CHAR* val=new CHAR[sz+1];
          ses->param("override",val,sz);
          checkOverride(val);
          delete [] val;
     }
     if (m_bOWuseframes) {
          m_bUseFrames=ses->param("useframes");
          m_bUseFramesSet=true;
     }
     else if (ses->param("useframes")) {
          INT sz=ses->paramRoom("useframes");
          CHAR* val=new CHAR[sz+1];
          ses->param("useframes",val,sz);
          if (sameas(val,"0")) {
               m_bUseFrames=false;
          }
          else if (sameas(val,"1")) {
               m_bUseFrames=true;
          }
          else {
               m_err=ERR_INVALIDPARAM;
               m_errtext="useframes";
          }
          m_bUseFramesSet=true;
          delete [] val;
     }
     if (m_err == ERR_NOERROR && ses->param("lib")) {
          INT sz=ses->paramRoom("lib");
          CHAR* val=new CHAR[sz+1];
          ses->param("lib",val,sz);
          struct fllib* pLib=libfind(val);
          if (pLib == NULL || !ahHasLibKey(m_usr,pLib,pLib->keyreq)) {
               m_err=ERR_INVALIDLIB;
               m_errtext=val;
          }
          else {
               m_strDefaultLib=val;
          }
          m_bLibSet=true;
          delete [] val;
     }
     if (m_err == ERR_NOERROR && ses->param("liborder")) {
          INT sz=ses->paramRoom("liborder");
          CHAR* val=new CHAR[sz+1];
          ses->param("liborder",val,sz);
          if (sameas(val,"ascending")) {
               m_LibOrder=ORDER_ASCEND;
          }
          else if (sameas(val,"descending")) {
               m_LibOrder=ORDER_DESC;
          }
          else {
               m_err=ERR_INVALIDPARAM;
               m_errtext="liborder";
          }
          m_bLibOrderSet=true;
          delete [] val;
     }
     if (m_err == ERR_NOERROR && ses->param("fileorder")) {
          INT sz=ses->paramRoom("fileorder");
          CHAR* val=new CHAR[sz+1];
          ses->param("fileorder",val,sz);
          if (sameas(val,"ascending")) {
               m_FileOrder=ORDER_ASCEND;
          }
          else if (sameas(val,"descending")) {
               m_FileOrder=ORDER_DESC;
          }
          else {
               m_err=ERR_INVALIDPARAM;
               m_errtext="fileorder";
          }
          m_bFileOrderSet=true;
          delete [] val;
     }
     if (m_err == ERR_NOERROR && ses->param("search")) {
          INT sz=ses->paramRoom("search");
          CHAR* val=new CHAR[sz+1];
          ses->param("search",val,sz);
          if (sameas(val,"name")) {
               m_SearchType=STYPE_NAME;
          }
          else if (sameas(val,"date")) {
               m_SearchType=STYPE_DATE;
          }
          else if (sameas(val,"popularity")) {
               m_SearchType=STYPE_POPULARITY;
          }
          else {
               m_err=ERR_INVALIDPARAM;
               m_errtext="search";
          }
          m_bSearchTypeSet=true;
          delete [] val;
     }
     m_SynState=SYNSTATE_SYNTH;
     return(rc);
}

ACTHCODE
synSetPrefs::proceedSynth()             // proceed with synthesis
{
     if (m_bSearchTypeSet) {
          theFilAgent->SaveSearchType(m_usr->userid(),m_SearchType);
     }
     if (m_bFileOrderSet) {
          theFilAgent->SaveFileOrder(m_usr->userid(),m_FileOrder);
     }
     if (m_bLibOrderSet) {
          theFilAgent->SaveLibOrder(m_usr->userid(),m_LibOrder);
     }
     if (m_bLibSet) {
          struct fllib* pLib=libfind(m_strDefaultLib.c_str());
          if (pLib != NULL) {
               // base class will save this for us.
               m_curfllib=*pLib;
          }
     }
     if (m_bUseFramesSet) {
          theFilAgent->SaveFramePref(m_usr->userid(),m_bUseFrames);
     }
     m_SynState=SYNSTATE_RESPONSE;
     return(ACTHMORE);
}


ACTHCODE
synSetPrefs::proceedDerivedResponse()   // proceed with response
{
     ACTHCODE rc=ACTHMORE;

     if (m_err != ERR_NOERROR) {
          if (m_dnf == NULL) {
               rc=errorResponse(filErrorMap,PPFIX "/prefs/");
          }
          else if (m_dnf->process() == DNFEND) {
               rc=ACTHDONE;
          }
          return(rc);
     }
     if (m_dnf == NULL) {
          return(successResponse(filSuccessMap,PPFIX "/prefs/"));
     }
     else if (m_dnf->process() == DNFEND) {
               rc=ACTHDONE;
     }
     return(rc);
}

VOID
synSetPrefs::checkOverride(             // check override paramter
const CHAR* stg)                        // contents of parameter
{
     INT cnt=itemcntd(stg,OVERRIDEDELIM);
     for (int i=0; i < cnt; i++) {
          if (sameas(itemidxd(stg,i,OVERRIDEDELIM),"useframes")) {
               m_bOWuseframes=true;
          }
     }
}

INT
synSetPrefs::translateError()           // translate err to mcv file op
{
     switch (m_err) {
     case ERR_INVALIDLIB:
          return(ERRVC03);
     case ERR_INVALIDPARAM:
          return(ERRPR02);
     default:
          ASSERT(FALSE);
     }
     m_errtext=spr("%d",m_err);
     return(ERROOPS);
}

