/***************************************************************************
 *                                                                         *
 *   SYNFILAH.H                                                            *
 *                                                                         *
 *   Copyright (c) 1998       Galacticomm, Inc.    All Rights Reserved.    *
 *                                                                         *
 *   Active HTML File Library Base Synthesis                               *
 *   Declaration                                                           *
 *                                                                         *
 *                                                - Phil Henning 10/16/98  *
 *                                                                         *
 ***************************************************************************/

#ifndef __SYNFILAH_H
#define __SYNFILAH_H

#include "cyctimer.h"
#include "filtdef.h"
#include "galacth.h"
#include "filagent.h"
#include "dnf.h"

class synBase : public acthSynthesis {
public:
     synBase(acthSession* _ses);

     virtual
     ~synBase();

     ACTHCODE
     proceed();                         // acthSynthesis proceed implementation

protected:
     virtual
     ACTHCODE
     proceedRequest()=0;                // setup request context

     virtual
     ACTHCODE
     proceedSynth()=0;                  // synthesise the response

     virtual
     ACTHCODE
     proceedResponse()=0;               // output the response

     bool
     startProc();                       // cycle timer ok to start

     bool
     contProc(                          // cycle timer ok to continue
     ACTHCODE rc);                      //  return code so far


     enum synstate {SYNSTATE_REQUEST,SYNSTATE_SYNTH,SYNSTATE_RESPONSE};

     enum synstate m_SynState;          // request state
     cycleTimer m_timer;                // cycle timer object
};

class synBaseAuth : public synBase {
public:
     synBaseAuth(
     acthSession* _ses,
     bool anonok,
     CHAR const * reqkey,
     INT lvlcnt=0);

     virtual
     ~synBaseAuth();

protected:
     virtual
     ACTHCODE
     proceedRequest();                  // setup request context

     virtual
     ACTHCODE
     proceedSynth()=0;                  // synthesise the response

     virtual
     ACTHCODE
     proceedDerivedResponse()=0;        // output response

     virtual
     INT
     translateError()=0;                // translate error to msg file text

     ACTHCODE                           //   continue synthesis?
     errorResponse(                     // an error was encountered
     dnfMap& map,                       //   map to use for error response
     CHAR const * path);                //   path to the template directory

     ACTHCODE                           //   continue synthesis?
     successResponse(                   // process onsuccess parameter
     dnfMap& map,                       //   map to use for error response
     CHAR const * path);                //   path to the template directory

     VOID
     LoadUserRecord();                  // load user record

     VOID
     SaveUserRecord();                  // save user record

     VOID
     setErrorVars();                    // set error text variables


     bool m_anonok;                     // anon access is ok
     INT  m_lvlcnt;                     // how deep is this url (/forums/view/)
     acthUserID* m_usr;                 // the current user
     struct usracc m_usaptr;            // user account structure
     bool m_succRedir;                  // redirect on success?
     bool m_errRedir;                   // redirect on error?
     CHAR* m_onsuccessFile;             // path to redirect onsuccess to
     string m_onerrorFile;              // path to redirect onerror to
     bool m_inframes;                   // is this request inframes?
     CHAR const * m_reqKey;             // key required to access URL
     errorcodes m_err;                  // error status
     string m_errtext;                  // extra info on the error
     enum synsubstate {
        SYNSUB_BUILDMAP,                // building map
        SYNSUB_LISTCONTEXT,             // building list context
        SYNSUB_FINISHUPLOAD,            // upload finish-up
        SYNSUB_FINALFINISHUPLOAD,       // final finishing up of upload
        SYNSUB_MOVEFILE,                // moving file
        SYNSUB_UPDONE,                  // upload is completely done
        SYNSUB_DELKWDS,                 // deleting keywords
        SYNSUB_WRITEFSTREAM};           // writing file stream
     enum synsubstate m_SynSubState;    // substate of request synthesis
     dnfHandler* m_dnf;                 // dnf Handler
     struct fllib m_curfllib;           // current lib struct
     struct fluser m_fluser;            // current user struct
     bool m_fluloaded;                  // did we load a user struct
     FILAHPREF  m_pref;                 // preferences for user
     bool m_prefloaded;                 // did we load preferences yet
     string m_strTemplate;              // template used for request
     CHAR* m_errParam;                  // contents of onerror parameter

private:
     virtual
     ACTHCODE
     proceedResponse();                 // output the response

     VOID
     initTemplates();                   // init onerror/onsuccess templates

     bool                               //   should we redirect?
     getOnParam(                        // get onsuccess/onerror parameter
     CHAR const * paramName,            //   name of param we're getting
     CHAR const * dftFileName,          //   default file name to use
     CHAR** pStorePtr);                 //   buffer to store param value

     VOID
     setusaptr();                       // set the current user acc pointer

     VOID
     setPreferenceVariables();          // set preference vars


private:
    synBaseAuth(acthSession* _ses);     // default activeh constructer-not impl
};

#endif // __SYNFILAH_H
