/***************************************************************************
 *                                                                         *
 *   SYNFDWN.H                                                             *
 *                                                                         *
 *   Copyright (c) 1998       Galacticomm, Inc.    All Rights Reserved.    *
 *                                                                         *
 *   Active HTML File Download Synthesis                                   *
 *   Declaration                                                           *
 *                                                                         *
 *                                                - Phil Henning 11/12/98  *
 *                                                                         *
 ***************************************************************************/

#ifndef __SYNFDWN_H
#define __SYNFDWN_H

#include "synfilah.h"
#include "filtdef.h"
#include "readinfo.h"

typedef enum {RESPSTATE_NORMAL,RESPSTATE_FILSENDING} DLRESPSTATE;

class synFileDwn : public synBaseAuth {     // /download URL
public:
     synFileDwn(
     acthSession* _ses,
     bool anonok,
     INT lvlcnt=0);

     ~synFileDwn();
public:
     VOID abort();                      // synthesis abort


protected:
     ACTHCODE
     proceedRequest();                  // setup request context

     ACTHCODE
     proceedSynth();                    // proceed with synthesis

     ACTHCODE
     proceedDerivedResponse();          // proceed with response

     INT
     translateError();                  // translate err to mcv file op

private:
     bool
     isFile();                          // is requested file actually a file?

     bool
     canAfford();                       // can user afford to download?

     VOID
     setContentLengthAndType();         // set content length and mime type

     VOID
     finDownload(                       // finish up download
     bool bCompleted);                  // did we complete the download?

     VOID
     setStatus();                       // set http status after error

private:
     readingInfo*   m_rinfo;            // ptr reading info struct
     union combo    m_key;              // btrieve key
     struct flfile  m_flfile;           // file struct
     struct fllib   m_Lib;              // file library struct
     string         m_strFile;          // file name
     string         m_strLib;           // lib name
     string         m_strPathToFile;    // path to the fil
     DLRESPSTATE    m_ResponseState;    // at what point of the response are we
     LONG           m_price;            // cost to download file
     LONG           m_filsize;          // length, in bytes of file
     CHAR           m_ulby[UIDSIZ];     // downloaded file was uploaded by
};


#endif __SYNFDWN_H

