/***************************************************************************
 *                                                                         *
 *   SYNDLIB.CPP                                                           *
 *                                                                         *
 *   Copyright (c) 1998       Galacticomm, Inc.    All Rights Reserved.    *
 *                                                                         *
 *   Active HTML File Library Detail Synthesis                             *
 *   Implementation                                                        *
 *                                                                         *
 *                                                - Phil Henning 11/17/98  *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "galacth.h"
#include "dnf.h"
#include "dnfmgr.h"
#include "ahutil.h"
#include "filtvb.h"
#include "syndlib.h"
#include "filagent.h"
#include "galfilah.h"

#define FILREV "$Revision: 5 $"

static
dnfStep dnfSuccessSteps[]={
     dnfStep(DNFMAPEND)
};
static
dnfMap filSuccessMap(PPFIX "/view/lib/index.htm","Success Response",dnfSuccessSteps);

static
dnfStep dnfErrorSteps[]={
     dnfStep(DNFMAPEND)
};
static
dnfMap filErrorMap(PPFIX "/view/lib/error.htm","Error Response",dnfErrorSteps);

//
//  List Libs Synthesis Member Functions
//


synLibDetail::synLibDetail(
acthSession* _ses,
bool anonok,
INT lvlcnt)   : synBaseAuth(_ses,anonok,theFilAgent->m_hfilkey,lvlcnt)
{
     memset(&m_fllib,0,sizeof(struct fllib));
}

synLibDetail::~synLibDetail()
{
}


ACTHCODE
synLibDetail::proceedRequest()          // setup request context
{
     ACTHCODE rc=synBaseAuth::proceedRequest();

     if (rc != ACTHMORE) {
          return(rc);
     }
     if (ses->param("lib")) {
          INT sz=ses->paramRoom("lib");
          CHAR* val=new CHAR[sz+1];
          ses->param("lib",val,sz);
          struct fllib* libptr=libfind(val);
          if (libptr == NULL) {
               m_err=ERR_INVALIDLIB;
               m_errtext=val;
               m_SynState=SYNSTATE_RESPONSE;
               return(ACTHMORE);
          }
          else if (m_usr == NULL && strlen(libptr->keyreq) > 0) {
               return(ACTHNOANON);
          }
          else if (!ahHasLibKey(m_usr,libptr,libptr->keyreq)) {
               return(ACTHFORBID);
          }
          delete [] val;
          m_fllib=*libptr;
     }
     else {
          m_err=ERR_PARAMMISSING;
          m_errtext="lib";
     }
     m_SynState=SYNSTATE_SYNTH;
     return(rc);
}

ACTHCODE
synLibDetail::proceedSynth()            // proceed with synthesis
{
     m_SynState=SYNSTATE_RESPONSE;
     return(ACTHMORE);
}

ACTHCODE
synLibDetail::proceedDerivedResponse()  // proceed with response
{
     ACTHCODE rc=ACTHMORE;

     if (m_err != ERR_NOERROR) {
          if (m_dnf == NULL) {
               rc=errorResponse(filErrorMap,PPFIX "/view/lib/");
          }
          else if (m_dnf->process() == DNFEND) {
               rc=ACTHDONE;
          }
          return(rc);
     }
     if (m_dnf == NULL) {
          m_dnf=dnfCreateHandlerURL(ses,&filSuccessMap,PPFIX);
     }
     else {
          if (*(m_fllib.libname) != '\0') {
               ::setLibVars(&m_fllib,m_usr);
          }
          if (m_dnf->process() == DNFEND) {
               rc=ACTHDONE;
          }
     }
     return(rc);
}

INT
synLibDetail::translateError()          // translate err to mcv file op
{
     switch (m_err) {
     case ERR_INVALIDLIB:
          return(ERRVL03);
     case ERR_PARAMMISSING:
          return(ERRVL01);
     default:
          ASSERTM(FALSE,"Error in synLibDetail::translateError()");
     }
     m_errtext=spr("%d",m_err);
     return(ERROOPS);
}

