/***************************************************************************
 *                                                                         *
 *   SYNDFIL.H                                                             *
 *                                                                         *
 *   Copyright (c) 1998       Galacticomm, Inc.    All Rights Reserved.    *
 *                                                                         *
 *   Active HTML File Library File Detail Synthesis                        *
 *   Declaration                                                           *
 *                                                                         *
 *                                                - Phil Henning 11/17/98  *
 *                                                                         *
 ***************************************************************************/

#ifndef __SYNDFIL_H
#define __SYNDFIL_H

#include "synfilah.h"
#include "filtdef.h"

class synFileDetail : public synBaseAuth {     // /view/file URL
public:
     synFileDetail(
     acthSession* _ses,
     bool anonok,
     INT lvlcnt=0);

     ~synFileDetail();

protected:
     ACTHCODE
     proceedRequest();                  // setup request context

     ACTHCODE
     proceedSynth();                    // proceed with synthesis

     ACTHCODE
     proceedDerivedResponse();          // proceed with response

     INT
     translateError();                  // translate err to mcv file op

private:
     bool
     CheckFileExists(                   // check if file exists
     const CHAR* filname,               // filename
     bool isOSOnly);                    // is file in os only lib?

private:
     struct fllib m_fllib;              // file library struct
     struct flfile m_flfile;            // file struct
     struct ffblk m_fb;                 // dos file block
     union combo m_key;                 // btrieve key
     string m_strDesc;                  // one line description of file
     string m_strDetail;                // detail on file
     string m_strDetailLine;            // detail on file with <br>'s
     string m_strDetailRaw;             // raw detail on file
     string m_strDetailJS;              // detail on file, js encoded
     WIN32_FIND_DATA m_findData;        // find data structure
     HANDLE         m_fh;               // handle to find data info
};

#endif // __SYNDFIL_H

