/***************************************************************************
 *                                                                         *
 *   SYNDARC.H                                                             *
 *                                                                         *
 *   Copyright (c) 1998       Galacticomm, Inc.    All Rights Reserved.    *
 *                                                                         *
 *   Active HTML File Library Archive Detail Synthesis                     *
 *   Declaration                                                           *
 *                                                                         *
 *                                                - Phil Henning 11/19/98  *
 *                                                                         *
 ***************************************************************************/

#ifndef __SYNDARC_H
#define __SYNDARC_H

#include "synfilah.h"
#include "filtdef.h"

class synArchiveDetail : public synBaseAuth {     // /view/contents URL
public:
     synArchiveDetail(
     acthSession* _ses,
     bool anonok,
     INT lvlcnt=2);

     ~synArchiveDetail();

public:
     VOID
     abort();                           // synthesis abort

protected:
     ACTHCODE
     proceedRequest();                  // proceed with request

     ACTHCODE
     proceedSynth();                    // proceed with synthesis

     ACTHCODE
     proceedDerivedResponse();          // proceed with response

     INT
     translateError();                  // translate err to mcv file op

private:
     bool
     CheckFileExists(                   // check if file exists
     const CHAR* filname,               // filename
     bool isOSOnly);                    // is file in os only lib?

     VOID
     decodeFileData();                  // decode file data from vewctn()

private:
     struct fllib m_fllib;              // file library structure
     struct flfile m_flfile;            // file library file
     struct ffblk m_fb;                 // file pointer
     union combo m_key;                 // key structure for database
     string m_fileData;                 // file data storage
     bool m_bDecoded;                   // did we already decode this item?
     CHAR* m_dbuf;                      // ptr to buffer to do decoding
     CHAR* m_decodedPtrs[8];            // ptrs to decoded data
     size_t m_dbufsiz;                  // size of current alloced buffer
     INT m_curCount;                    // number of files in arcgive
     bool m_allDone;                    // no more files in archive
};

#endif // __SYNDARC_H

