/***************************************************************************
 *                                                                         *
 *   READINFO.H                                                            *
 *                                                                         *
 *   Copyright (c) 1998       Galacticomm, Inc.    All Rights Reserved.    *
 *                                                                         *
 *   Active HTML File Library Read Locking                                 *
 *   Declarations                                                          *
 *                                                                         *
 *                                                - Phil Henning 11/13/98  *
 *                                                                         *
 ***************************************************************************/

#ifndef __READINFO_H
#define __READINFO_H
#include <map>
using namespace std;

class readingInfo {                // info on each read-reserved file
public:
     readingInfo(                  // constructed to read-reserve a file
     const CHAR *_libname,         // Library the file is in
     const CHAR *_filname);        // the file name of the file

     ~readingInfo();               // destructor un-read-reserves a file

     CHAR m_libname[FLNAMESZ];     // Library the file is in
     CHAR m_filname[FLFILENM];     // the file name of the file
     int m_unum;                   // associated usrnum (!)

private:
     list<readingInfo *>::iterator rit;
                                   // entry in readingList
};

extern list<readingInfo *> readingList;   // read reservations list

#endif // __READINFO_H
