/***************************************************************************
 *                                                                         *
 *   READINFO.CPP                                                          *
 *                                                                         *
 *   Copyright (c) 1998       Galacticomm, Inc.    All Rights Reserved.    *
 *                                                                         *
 *   Active HTML File Library Read Locking                                 *
 *   Implementation                                                        *
 *                                                                         *
 *                                                - Phil Henning 11/13/98  *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "galfilh.h"
#include <list>
#include <stdcomp.h>
#include "readinfo.h"
using namespace std;
#pragma warn -par                  // supresses warning from memory.h line 208

list<readingInfo *> readingList;   // read reservations list

readingInfo::readingInfo(          // read-reservations info constructor
const CHAR *_libname,              // Library the file is in
const CHAR *_filname)              // the file name of the file
{
     stlcpy(m_libname,_libname,FLNAMESZ);
     stlcpy(m_filname,_filname,FLFILENM);
     m_unum=usrnum;                // Warning, reservation/channel dependency
     readingList.push_back(this);
     rit=readingList.end();
     rit--;
}

readingInfo::~readingInfo()        // read-reservations info destructor
{
     readingList.erase(rit);
}

