/***************************************************************************
 *                                                                         *
 *   MAPSTORE.H                                                            *
 *                                                                         *
 *   Copyright (c) 1998       Galacticomm, Inc.    All Rights Reserved.    *
 *                                                                         *
 *   Wrapper template class for storing classes that were not designed     *
 *   for use with STL (like string from cstring.h) as key values in maps.  *
 *                                                                         *
 *                                                - Phil Henning 11/08/98  *
 *                                                                         *
 ***************************************************************************/

#ifndef __MAPSTORE_H
#define __MAPSTORE_H

template<class T>
class mapStore {
public:
     mapStore();                        // default constructor
     mapStore(                          // copy constructor
     const mapStore& rhs)
     {
          m_data=rhs.m_data;
     }

     mapStore(                          // string constructor
     const T& str)
     {
          m_data=str;
     }

     inline
     void operator=(                    // assignment operator
     const mapStore& rhs)
     {
          // m_data != rhs.m_data gives a compiler error in
          // \bc5\include\utility.h  when used with a string
          // from cstring.h
          if (!(m_data == rhs.m_data)) {
               m_data=rhs.m_data;
          }
     }

     inline
     bool operator> (
     const mapStore& rhs) const         // greater-than operator
     {
          return(m_data > rhs.m_data);
     }

     inline
     bool operator< (                   // less-than operator
     const mapStore& rhs) const
     {
          return(m_data < rhs.m_data);
     }

     inline
     bool operator== (                  // equal-to operator
     const mapStore& rhs) const
     {
          return(m_data == rhs.m_data);
     }

     inline
     bool operator>= (                  // greater-equal-to operator
     const mapStore& rhs) const
     {
          return(m_data >= rhs.m_data);
     }

     inline
     bool operator<= (                  // less-equal-to operator
     const mapStore& rhs) const
     {
          return(m_data <= rhs.m_data);
     }

private:
     T m_data;                          // data to store
};

#endif // __MAPSTORE_H
