/***************************************************************************
 *                                                                         *
 *   LIBQUEUE.H                                                            *
 *                                                                         *
 *   Copyright (c) 1998-1999  Galacticomm, Inc.    All Rights Reserved.    *
 *                                                                         *
 *   Active HTML File Library Joined Library Queue                         *
 *   Declaration                                                           *
 *                                                                         *
 *                                                - Phil Henning 01/05/99  *
 *                                                                         *
 ***************************************************************************/

#ifndef __LIBQUEUE_H
#define __LIBQUEUE_H

#include "galacth.h"

class filLibMap {
public:
     filLibMap();
     ~filLibMap();

     VOID
     Init(                              // initialize the lib map
     const struct fllib* pLib,          // ptr to lib or NULL for all libs
     acthUserID* usr);                  // acthuser doing request

     VOID
     addChildLibs(                      // add child libs
     const struct fllib* pLib);         // for this library

     bool
     checkLib(                          // check if user has access
     const struct fllib* pLib);         // lib to check

     bool
     checkParents(                      // check parent libs
     const struct fllib* pLib);         // of this lib

     VOID
     addLibToMap(                       // add lib to map
     const struct fllib* pLib);         // lib to add

     const CHAR*
     getFirstJoinedLibName();           // get name of first lib

     const CHAR*
     getLastJoinedLibName();            // get name of last lib

     const CHAR*
     getCurrentJoinedLibName();         // get name of current lib

     bool                               // was there another lib?
     getNextJoinedLib(                  // go to next lib after libCurrent
     INT direction,                     // direction to seek
     CHAR* libCurrent);                 // ptr to receive name of next lib

     const CHAR*                        // name of lib
     Find(                              // find a lib
     INT direction,                     // direction to seek
     const CHAR* libname);              // partial lib name

     VOID
     seekBegin();                       // go to first lib

     VOID
     seekEnd();                         // go to last lib

     INT
     GetNumberLibs();                   // get number of libs in map

     filLibMap
     operator++ ();                     // next lib

     filLibMap
     operator++ (int);                  // next lib

     filLibMap
     operator-- ();                     // previous lib

     filLibMap
     operator-- (int);                  // previous lib

public:
     LIBMAP m_map;                      // map of libs

private:
     LIBMAP::iterator m_iter;           // iterator to current position
     acthUserID* m_usr;                 // user doing request
};

#endif // __LIBQUEUE_H
