/***************************************************************************
 *                                                                         *
 *   KWDSRCH.H                                                             *
 *                                                                         *
 *   Copyright (c) 1998 Galacticomm, Inc.         All Rights Reserved.     *
 *                                                                         *
 *   Active HTML File Library keyword search engine declarations.          *
 *                                                                         *
 *                                           - J. Alvrus    12/02/1998     *
 *                                                                         *
 ***************************************************************************/

#if !defined(__KWDSRCH_H)
#define __KWDSRCH_H

#include "gcomm.h"
#include "majorbbs.h"
#include "galfilh.h"
// NOTE: the desired string implementation must be #included before this file.

typedef enum {                     // status code enumerations
     FLKWS_OK,                     //   operation succeeded
     FLKWS_NONE,                   //   (internal use only)
     FLKWS_LENGTH,                 //   keyword string too long
     FLKWS_SYNTAX,                 //   incorrect Boolean syntax
     FLKWS_PARENS,                 //   unmatched parentheses
     FLKWS_NOWORD,                 //   keyword doesn't exist (see GetMisc)
     FLKWS_BADSTART,               //   invalid start parameter
     FLKWS_FILE,                   //   Find() found a file
     FLKWS_DONE                    //   no more files
} flkwStatus;                      // status code enumeration type

class flKeywordSearch {
public:
     flKeywordSearch();
     ~flKeywordSearch();

     flkwStatus                    //   returns status code
     Init(                         // initialize this search
     CHAR const * lib,             //   library name or NULL/"" for all
     CHAR const * start,           //   value of start parameter or NULL/""
     CHAR const * kwds,            //   keyword string supplied by user
     filLibMap* libmap);           //   map of joined libs

     flkwStatus                    //   returns status code
     Find(                         // find next file in search
     INT direction,                //   direction to search
     struct flfile * buf);         //   buffer to receive file info

     string                        //   returns state string or "" if invalid
     GetState();                   // extract state string (for start param)
     // should only be called immediately after Find() returns FLKWS_FILE.

     string
     GetMisc()                     // get extended return information
     {
          return(m_Misc);
     }

private:                           // private member functions

     flkwStatus                    //   returns status code
     FindKeyword(                  // find next file in keyword search
     INT direction,                //   direction to search
     struct flfile * buf);         //   buffer to receive file info

     flkwStatus                    //   returns status code
     FindBrute(                    // find next file in brute force search
     INT direction,                //   direction to search
     struct flfile * buf);         //   buffer to receive file info

     bool                          //   returns true if keywords match
     CheckKeywords(                // check all keywords
     struct flfile const * pFileInfo, //   file info
     INT iStart);                  //   starting at which keyword

     bool                          //   returns result of evaluation
     CheckOneKeyword(              // find out if a keyword matches a file
     CHAR const * Target);         //   keyword to check
                                   // (assumes sorted keyword list in dargv)

     bool                          //   returns result of evaluation
     EvaluateBoolean(              // evaluate a Boolean expression string
     CHAR const * BoolStr);        //   Boolean expression string

     flkwStatus                    //   returns status code
     ParseKeywords(                // parse user-supplied keyword string
     CHAR const * kwds);           //   keyword string supplied by user

     flkwStatus                    //   returns status code
     ValidateSyntax(               // check the syntax of a Boolean primitive
     CHAR const * s);              //   primitive string to validate

     bool                          //   returns true if replaced a token
     ReplaceTokenFirst(            // replace first of one token with another
     CHAR * buf,                   //   buffer containing string to modify
     size_t bufSiz,                //   size of buffer
     CHAR const * tokOld,          //   old token to be replaced
     CHAR const * tokNew);         //   new token to replace with

     bool                          //   returns false if out of buffer room
     ReplaceTokenAll(              // replace all of one token with another
     CHAR * buf,                   //   buffer containing string to modify
     size_t bufSiz,                //   size of buffer
     CHAR const * tokOld,          //   old token to be replaced
     CHAR const * tokNew);         //   new token to replace with

     CHAR *                        //   returns a pointer to the token or NULL
     FindToken(                    // find a token
     CHAR * buf,                   //   buffer containing string to search
     CHAR const * token);          //   token to search for

     bool                          //   returns true if replaced a token
     ReplaceStringFirst(           // replace first of one string with another
     CHAR * buf,                   //   buffer containing string to modify
     size_t bufSiz,                //   size of buffer
     CHAR const * strOld,          //   old string to be replaced
     CHAR const * strNew);         //   new string to replace with

     CHAR *                        //   returns a pointer to substring or NULL
     FindString(                   // find a string within another
     CHAR * str,                   //   string to search
     CHAR const * sub);            //   substring to search for

     bool
     isTokenSep(                   // is this a token separator character?
     CHAR c);                      //   character to test

     bool                          //   returns true if any removed
     RemoveCharAll(                // remove all occurances of a character
     CHAR * buf,                   //   buffer containing string to modify
     CHAR c);                      //   character to delete

     CHAR *                        //   returns matching parenthesis
     FindMatch(                    // find matching close parenthesis
     CHAR * buf);                  //   buffer to search

     bool                          //   returns false if too big
     ExtractPart(                  // extract a part of a delimited string
     CHAR const ** ppSrc,          //   ptr to ptr to start of part to extract
     CHAR * buf,                   //   buffer to receive part
     size_t bufSiz);               //   size of buffer

     bool                          //   returns false if no more records
     ReadKeywordRec(               // read a record from the keyword database
     struct key2 * key,            //   keyword info (updated)
     INT direction);               //   read direction flags

     bool                          //   returns false if no more records
     ReadFileRec(                  // read a record from the file database
     struct flfile * buf,          //   buffer to receive file info
     struct key1 const * key,      //   library/file key
     INT direction);               //   read direction flags

     bool                          //   returns false if no more records
     QueryRec(                     // perform directional query on a database
     VOID const * pKey,            //   key value
     INT nKey,                     //   key number
     INT direction);               //   read direction flags

private:                           // private data members
     string m_Misc;                //   additional return info string
     CHAR * m_WordArr[FLKEYLST/2]; //   array of pointers to keywords
     INT m_nWords;                 //   number of keywords
     flkwStatus m_LastRet;         //   last value returned by public function
     bool m_isBrute;               //   brute force search (vs. fast)
     bool m_First;                 //   is this the first Find() call?
     CHAR m_Primitive[FLKEYLST];   //   keyword primitive "?&(?|?)"
     CHAR m_WordList[FLKEYLST];    //   list of keywords "\0\0"-terminated
     CHAR m_LibPrimary[FLNAMESZ];  //   primary library to search ("" == all)
     CHAR m_LibCurrent[FLNAMESZ];  //   current library being searched
     CHAR m_File[FLFILENM];        //   current file found
     CHAR m_Keyword[FLKEYSIZ];     //   current keyword found
     filLibMap* m_libList;         //   queue of libs to search on
};

#endif // !defined(__KWDSRCH_H)
