/***************************************************************************
 *                                                                         *
 *   FILTVB.H                                                              *
 *                                                                         *
 *   Copyright (c) 1998       Galacticomm, Inc.    All Rights Reserved.    *
 *                                                                         *
 *   Active HTML File Library Text Variables                               *
 *   Declarations                                                          *
 *                                                                         *
 *                                                - Phil Henning 10/16/98  *
 *                                                                         *
 ***************************************************************************/

#ifndef __FILTVB_H
#define __FILTVB_H

#include "enctvb.h"
#include "filtdef.h"

extern basicTvb tvbLibAccessOverwrite;  // FL_LIB_ACC_OVERWRITE tvar
extern htmlEncodedTvb tvbFileName;      // FL_FILE_NAME tvar
extern urlEncodedTvb tvbFileNameUrl;    // FL_FILE_NAME_U tvar

extern htmlEncodedTvb tvbFileHeldName;  // FL_UPLOAD_HELD_NAME tvar
extern urlEncodedTvb tvbFileHeldNameUrl; // FL_UPLOAD_HELD_NAME_U tvar

extern basicTvb tvbFileDetailRaw;       // FL_FILE_DETAIL_RAW tvar
extern basicTvb tvbFileDetailJS;        // FL_FILE_DETAIL_JS tvar

extern CHAR* g_pszNoList[];              // strings to use for no list files
extern CHAR* g_pszNoListLib[];           // strings to use for no list libs

VOID
initMcvText();                     // initalize strings for text variables

VOID
finishMcvText();                   // cleanup the text variable text strings

VOID
initTvars();                       // initalize text variables

VOID
finishTvars();                     // cleanup text variables

VOID
clearVars();                       // clear text variables

VOID
clearGlobalVars();                 // clear global variables

VOID
clearSearchVars();                 // clear search variables

VOID
clearFileVars();                   // clear file variables

VOID
clearArcVars();                    // clear archive variables

VOID
clearLibVars();                    // clear lib variables

VOID
clearCurLibVars();                 // clear current lib variables

VOID
clearListVars();                   // clear list variables

VOID
setNoList(                         // set FL_NOLIST tvbs
bool bIsList,                      // was there a list?
CHAR** opts);                      // options to use

VOID
setAdminLinks(                     // set administrator links
bool isAdmin);                     // is user administrator?

VOID
setTarget(                         // set target variables
bool inFrames);                    // using frames?

VOID
setLibVars(                        // set lib text variables
const struct fllib* flib,          // ptr to lib
acthUserID* uid);                  // User doing request

VOID
setFileVars(                       // set file variables
const struct flfile* ffile,        // ptr to file info
acthUserID* usr);                  // User-ID making request

VOID
setOSFileVars(                     // set os-lib file text vars
const struct ffblk* ffil,          // ptr to file
const struct fllib* flib,          // ptr to lib
acthUserID* usr);                  // User-ID doing request

VOID
setListContextVars(
INT iCount,                        // value to set FL_LIST_COUNT
LISTORDER loOrder,                 // value to set FL_LIST_ORDER
const CHAR* strLowItem,            // value to set FL_LIST_ITEM_LOW
const CHAR* strHighItem,           // value to set FL_LIST_ITEM_HIGH
bool bIsMoreLow,                   // value to set FL_LIST_MORE_LOW
bool bIsMoreHigh,                  // value to set FL_LIST_MORE_HIGH
bool bProducedResults,             // is there stuff in the list?
LISTTYPE iListType);               // type of list


VOID
setListLibContextVars(             // set lib list context variables
LIBACCESS laAccess,                // level of access to list (d, u, or a)
LIBTYPE ltType,                    // lib type (os, normal, or all
const char* parent);               // parent lib

VOID
setErrorVars(                      // set error variables
INT err,                           // error to set
const CHAR* errstg);               // error string to set

bool
isArchive(                         // is specified file an archive
const CHAR* fname);                // file name to check

VOID
setArchiveFileDetailVars(          // set archive file item detail vars
CHAR** ppInfo);                    // info on file in archive

VOID
buildDetailLine(                   // build detail with <br>'s
const CHAR* desc,                  // original description
string* dstr,                      // ptr to string to receive one line desc
string* str);                      // ptr to string to receive file detail w/ <br>'s

VOID
buildDetailRaw(                    // build raw detail
const CHAR* desc,                  // original description
string* str);                      // ptr to string to receive raw detail

VOID
buildDetail(                       // build detail
const CHAR* desc,                  // original description
string* str);                      // ptr to string to hold detail

INT
buildParagraphs(                   // build paragraphs in descriptions
CHAR** line,                       // array of ptrs to lines
string* para);                     // string to hold the built paragraph

VOID
buildLines(                        // build detail lines
CHAR* descbuf,                     // original description
CHAR** line);                      // array of ptrs to set to beginnings of lines

VOID
setFileDetailVars(                 // set file detail vars
const string& strDesc,             // one line description
const string& strDetail,           // detail
const string& strDetailLine,       // detail, with <br>'s
const string& strDetailRaw,        // detail, raw
const string& strDetailJS);        // detail, js

VOID
buildAllDetail(                    // build detail variables
CHAR* desc,                        // description
string* strDesc,                   // ptr to string to hold description
string* strDetail,                 // ptr to string to hold detail
string* strDetailLine,             // ptr to string to hold detail with <br>'s
string* strDetailRaw,              // ptr to string to hold raw detail
string* strDetailJS);              // ptr to string to hold js detail

VOID
setSearchVars(                     // set search vars
SEARCHTYPE stype,                  // search type
const string& wc,                  // wildcard string
const string& kw);                 // keyword string

VOID
setCurLibVars(                     // set current lib text vars
const struct fllib* flib,          // ptr to lib
acthUserID* uid);                  // User-ID doing request

VOID
setPrefVars(                       // set preference variables
LISTORDER libOrder,                // prefered lib list order
LISTORDER browseOrder,             // prefered file browse order
SEARCHTYPE browseType);            // prefered browse type

VOID
setTemplateMask(                   // set template mask variable
const string& templ,               // the template name used
const dnfHandler* dnf);            // ptr to dnf for this request

bool
validateLib(                       // make sure lib exists and user has access
const struct fllib* pLib,          // ptr to lib
acthUserID*  usr);                 // User-ID requesting access.

string
jsEncode(                          // encode for javascript
const CHAR* str);                  // raw formatted description

#endif // __FILTVB_H
