/***************************************************************************
 *                                                                         *
 *   FILTVB.CPP                                                            *
 *                                                                         *
 *   Copyright (c) 1998       Galacticomm, Inc.    All Rights Reserved.    *
 *                                                                         *
 *   Active HTML File Library Text Variables                               *
 *   Implementation                                                        *
 *                                                                         *
 *                                                - Phil Henning 10/16/98  *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include <strstrea.h>
#include <list>
#include "galacth.h"
#include "dnf.h"
#include "filtvb.h"
#include "galfilh.h"
#include "filtdef.h"
#include "galfilah.h"
#include "synfdwn.h"
#include "ahutil.h"

#define FILREV "$Revision: 15 $"

extern HMCVFILE filahmb;

#define FMT_SC           6         // short uppercase
#define FMT_L            1         // long lowercase
#define FMT_LP           2         // long lowercase w periods
#define FMT_S            3         // short lowercase
#define FMT_LC           4         // uppercase long
#define FMT_LPC          5         // uppercase long w/ periods

#define FILNOLIST        9         // number of FL_LIST_NONE_x text variables
#define FILPARENT        10        // number of FL_LIB_PARENT_x text variables
#define NOADMINLINKS     9         // number of FL_ADMIN_LINK_x text variables
#define NOTARGETS        9         // number of FL_TARGET_x text variables

#define DOFWEEK(X)  (dayFromDate(ddyear(X),ddmon(X),ddday(X)))

enum tvbtype {TVB_BASIC,TVB_HTML,TVB_ENC,TVB_LINKED};

CHAR shortDays[7][6]={"Sun","Mon","Tue","Wed","Thu","Fri","Sat"};

CHAR* g_pszNoList[FILNOLIST];      // strings for FL_LIST_NONE_x text variables - file
CHAR* g_pszNoListLib[FILNOLIST];   // strings for FL_LIST_NONE_x text variables - libs
CHAR* g_pszAdminLinks[NOADMINLINKS]; // strings for FL_ADMIN_LINK_x text variables
CHAR* g_pszNoAdminLinks[NOADMINLINKS]; // strings for FL_ADMIN_LINK_x text variables
CHAR* g_pszTargets[NOTARGETS];     // strings for FL_TARGET_x text variables

CHAR* g_pszNodesc=NULL;            // no description text
CHAR* g_pszFlagon=NULL;            // flag on text
CHAR* g_pszFlagoff=NULL;           // flag off text
CHAR* g_pszParsep=NULL;            // paragraph seperator characters
CHAR* g_pszParacc=NULL;            // paragraph continuation characters

CHAR* g_pszSTypeName=NULL;         // Name search display text
CHAR* g_pszSTypeDate=NULL;         // Date search display text
CHAR* g_pszSTypePop=NULL;          // Popularity search display text
CHAR* g_pszSTypeKeywords=NULL;     // Keyword search display text

CHAR* g_pszAppdsp=NULL;            // approved file text
CHAR* g_pszUnapdsp=NULL;           // unapproved file text

INT g_iWraplen;                    // description max line size
bool g_bJoin1st;                   // join first descrption line to rest of desc.

template <class T>
VOID
formatCommas(                      // format number with commas
basicTvb* tvb,                     // pointer to tvb to put result
T num)                             // number to format
{
     CHAR buf[sizeof("-2,000,000,000")];
     ostrstream ost;
     ost << num << ends;
     stlcpy(buf,ost.str(),sizeof("-2,000,000,000"));
     *tvb=commas(buf);
     ost.rdbuf()->freeze(0);
}

template <class T>
string stringFormat(T val)         // format any value to a string
{
     string str;
     ostrstream ost;
     ost << val << ends;
     str=ost.str();
     ost.rdbuf()->freeze(0);
     return(str);
}

static VOID
setTvbArray(                       // set tvbs to set or cleared state
basicTvb** tvbPtr,                 //   pointer to tvbs
CHAR** repStrings,                 //   strings to set with
INT numElems,                      //   number of tvbs/strings
bool bClear);                      //   clear them?

static VOID
registerRange(                     // register a range of Tvbs
basicTvb ** tvbPtr,                //   pointer to tvbs
enum tvbtype ttype,                //   tvb type to create
CHAR const * pszBody,              //   body to set equal to
INT num,                           //   set from 0-num
INT startnum,                      //   start numbering at this value
CHAR const * anchor);              //   anchor to use for linking

const CHAR*                        // returned String
formatMeridiem(                    // format meridiem as desired
unsigned time,                     // time to work with
SHORT type);                       // type of formatting

basicTvb tvbLibAccessAdmin("FL_LIB_ACC_ADMIN");
basicTvb tvbLibAccessAutoApprove("FL_LIB_ACC_AUTOAPP");
basicTvb tvbLibAccessDownload("FL_LIB_ACC_DOWNLOAD");
basicTvb tvbLibAccessOverwrite("FL_LIB_ACC_OVERWRITE");
basicTvb tvbLibAccessUpload("FL_LIB_ACC_UPLOAD");
basicTvb tvbLibAccessView("FL_LIB_ACC_VIEW");
htmlEncodedTvb tvbLibAdminUser("FL_LIB_ADMIN");
urlEncodedTvb  tvbLibAdminUserUrl("FL_LIB_ADMIN_U");

htmlEncodedTvb tvbLibAuditDownload("FL_LIB_AUD_DOWNLOAD");
basicTvb tvbLibAuditDownloadChk("FL_LIB_AUD_DOWNLOAD_CHK");
basicTvb tvbLibAuditDownloadNum("FL_LIB_AUD_DOWNLOAD_NUM");

htmlEncodedTvb tvbLibAuditUpload("FL_LIB_AUD_UPLOAD");
basicTvb tvbLibAuditUploadChk("FL_LIB_AUD_UPLOAD_CHK");
basicTvb tvbLibAuditUploadNum("FL_LIB_AUD_UPLOAD_NUM");

htmlEncodedTvb tvbLibOnCD("FL_LIB_CD");
basicTvb tvbLibOnCDChk("FL_LIB_CD_CHK");
basicTvb tvbLibOnCDNum("FL_LIB_CD_NUM");

basicTvb tvbLibDownloadFileCharge("FL_LIB_CHG_DOWNLOAD_FILE");
basicTvb tvbLibDownloadFileKbyte("FL_LIB_CHG_DOWNLOAD_KB");
basicTvb tvbLibClusterSize("FL_LIB_CLUSTER");

basicTvb tvbLibCreateDateD("FL_LIB_CREATE_DATE_D");
basicTvb tvbLibCreateDateD0("FL_LIB_CREATE_DATE_D0");
basicTvb tvbLibCreateDateEurL("FL_LIB_CREATE_DATE_EUR_L");
basicTvb tvbLibCreateDateEurS("FL_LIB_CREATE_DATE_EUR_S");
basicTvb tvbLibCreateDateML("FL_LIB_CREATE_DATE_M_L");
basicTvb tvbLibCreateDateMN("FL_LIB_CREATE_DATE_M_N");
basicTvb tvbLibCreateDateMN0("FL_LIB_CREATE_DATE_M_N0");
basicTvb tvbLibCreateDateMS("FL_LIB_CREATE_DATE_M_S");
basicTvb tvbLibCreateDateUsaL("FL_LIB_CREATE_DATE_USA_L");
basicTvb tvbLibCreateDateUsaS("FL_LIB_CREATE_DATE_USA_S");
basicTvb tvbLibCreateDateWL("FL_LIB_CREATE_DATE_W_L");
basicTvb tvbLibCreateDateWS("FL_LIB_CREATE_DATE_W_S");
basicTvb tvbLibCreateDateYL("FL_LIB_CREATE_DATE_Y_L");
basicTvb tvbLibCreateDateYS("FL_LIB_CREATE_DATE_Y_S");
basicTvb tvbLibCreateTime12L("FL_LIB_CREATE_TIME_12_L");
basicTvb tvbLibCreateTime12S("FL_LIB_CREATE_TIME_12_S");
basicTvb tvbLibCreateTime24L("FL_LIB_CREATE_TIME_24_L");
basicTvb tvbLibCreateTime24S("FL_LIB_CREATE_TIME_24_S");
basicTvb tvbLibCreateTimeAL("FL_LIB_CREATE_TIME_A_L");
basicTvb tvbLibCreateTimeALC("FL_LIB_CREATE_TIME_A_LC");
basicTvb tvbLibCreateTimeALP("FL_LIB_CREATE_TIME_A_LP");
basicTvb tvbLibCreateTimeALPC("FL_LIB_CREATE_TIME_A_LPC");
basicTvb tvbLibCreateTimeAS("FL_LIB_CREATE_TIME_A_S");
basicTvb tvbLibCreateTimeASC("FL_LIB_CREATE_TIME_A_SC");
basicTvb tvbLibCreateTimeH12("FL_LIB_CREATE_TIME_H_12");
basicTvb tvbLibCreateTimeH120("FL_LIB_CREATE_TIME_H_120");
basicTvb tvbLibCreateTimeH24("FL_LIB_CREATE_TIME_H_24");
basicTvb tvbLibCreateTimeH240("FL_LIB_CREATE_TIME_H_240");
basicTvb tvbLibCreateTimeM("FL_LIB_CREATE_TIME_M");
basicTvb tvbLibCreateTimeM0("FL_LIB_CREATE_TIME_M0");
basicTvb tvbLibCreateTimeS("FL_LIB_CREATE_TIME_S");
basicTvb tvbLibCreateTimeS0("FL_LIB_CREATE_TIME_S0");

htmlEncodedTvb tvbLibDescription("FL_LIB_DESC");
htmlEncodedTvb tvbLibDetail("FL_LIB_DETAIL");
basicTvb tvbLibDetailLine("FL_LIB_DETAIL_LINE");
basicTvb tvbLibDetailRaw("FL_LIB_DETAIL_RAW");
basicTvb tvbLibDetailJS("FL_LIB_DETAIL_JS");
basicTvb tvbLibHidden("FL_LIB_HIDDEN");
basicTvb tvbLibHiddenChk("FL_LIB_HIDDEN_CHK");
basicTvb tvbLibHiddenNum("FL_LIB_HIDDEN_NUM");

htmlEncodedTvb tvbLibKeyAdmin("FL_LIB_KEY_ADMIN");
htmlEncodedTvb tvbLibKeyAutoApprove("FL_LIB_KEY_AUTOAPP");
htmlEncodedTvb tvbLibKeyDownload("FL_LIB_KEY_DOWNLOAD");
htmlEncodedTvb tvbLibKeyOverwrite("FL_LIB_KEY_OVERWRITE");
htmlEncodedTvb tvbLibKeyUpload("FL_LIB_KEY_UPLOAD");
htmlEncodedTvb tvbLibKeyView("FL_LIB_KEY_VIEW");
basicTvb tvbLibMaxBytes("FL_LIB_MAX_BYTES");
htmlEncodedTvb tvbLibMaxBytesAbbr("FL_LIB_MAX_BYTES_ABBR");
basicTvb tvbLibMaxBytesC("FL_LIB_MAX_BYTES_C");
basicTvb tvbLibMaxFileBytes("FL_LIB_MAX_FILE_BYTES");
htmlEncodedTvb tvbLibMaxFileBytesAbbr("FL_LIB_MAX_FILE_BYTES_ABBR");
basicTvb tvbLibMaxFileBytesC("FL_LIB_MAX_FILE_BYTES_C");
basicTvb tvbLibMaxFiles("FL_LIB_MAX_FILES");
basicTvb tvbLibMaxFilesC("FL_LIB_MAX_FILES_C");
htmlEncodedTvb tvbLibName("FL_LIB_NAME");
urlEncodedTvb tvbLibNameUrl("FL_LIB_NAME_U");
htmlEncodedTvb tvbLibNoChargeDownload("FL_LIB_NOCHG_DOWNLOAD");
basicTvb tvbLibNoChargeDownloadChk("FL_LIB_NOCHG_DOWNLOAD_CHK");
basicTvb tvbLibNoChargeDownloadNum("FL_LIB_NOCHG_DOWNLOAD_NUM");
htmlEncodedTvb tvbLibNoChargeUpload("FL_LIB_NOCHG_UPLOAD");
basicTvb tvbLibNoChargeUploadChk("FL_LIB_NOCHG_UPLOAD_CHK");
basicTvb tvbLibNoChargeUploadNum("FL_LIB_NOCHG_UPLOAD_NUM");
basicTvb tvbLibNumFiles("FL_LIB_NUM_FILES");
basicTvb tvbLibNumFilesC("FL_LIB_NUM_FILES_C");
basicTvb tvbLibNumFilesJoined("FL_LIB_NUM_FILES_JOINED");
basicTvb tvbLibNumFilesJoinedC("FL_LIB_NUM_FILES_JOINED_C");
basicTvb tvbLibNumJoined("FL_LIB_NUM_JOINED");
basicTvb tvbLibNumUnapproved("FL_LIB_NUM_UNAPP");
basicTvb tvbLibNumUnapprovedC("FL_LIB_NUM_UNAPP_C");
htmlEncodedTvb tvbLibOSOnly("FL_LIB_OSONLY");
basicTvb tvbLibOSOnlyChk("FL_LIB_OSONLY_CHK");
basicTvb tvbLibOSOnlyNum("FL_LIB_OSONLY_NUM");

basicTvb** tvbLibParent=NULL; // FL_LIB_PARENT_n (0-9)

basicTvb tvbLibParentCount("FL_LIB_PARENT_COUNT");
basicTvb tvbLibParentList("FL_LIB_PARENT_LIST");

htmlEncodedTvb tvbLibPath("FL_LIB_PATH");
htmlEncodedTvb tvbLibReadOnly("FL_LIB_READONLY");
htmlEncodedTvb tvbLibReadOnlyChk("FL_LIB_READONLY_CHK");
htmlEncodedTvb tvbLibReadOnlyNum("FL_LIB_READONLY_NUM");

basicTvb tvbLibRoyalty("FL_LIB_ROYALTY");
basicTvb tvbLibTotalBytes("FL_LIB_TOT_BYTES");
htmlEncodedTvb tvbLibTotalBytesAbbr("FL_LIB_TOT_BYTES_ABBR");
basicTvb tvbLibTotalBytesC("FL_LIB_TOT_BYTES_C");

basicTvb tvbLibUploadsDay("FL_LIB_UPLOADS_DAY");
basicTvb tvbLibUploadsDayC("FL_LIB_UPLOADS_DAY_C");

basicTvb tvbLibUploadsWeek("FL_LIB_UPLOADS_WEEK");
basicTvb tvbLibUploadsWeekC("FL_LIB_UPLOADS_WEEK_C");

// current library vars

basicTvb tvbCurLibAccessAdmin("FL_CURLIB_ACC_ADMIN");
basicTvb tvbCurLibAccessAutoApprove("FL_CURLIB_ACC_AUTOAPP");
basicTvb tvbCurLibAccessDownload("FL_CURLIB_ACC_DOWNLOAD");
basicTvb tvbCurLibAccessOverwrite("FL_CURLIB_ACC_OVERWRITE");
basicTvb tvbCurLibAccessUpload("FL_CURLIB_ACC_UPLOAD");
basicTvb tvbCurLibAccessView("FL_CURLIB_ACC_VIEW");
htmlEncodedTvb tvbCurLibAdminUser("FL_CURLIB_ADMIN");
urlEncodedTvb  tvbCurLibAdminUserUrl("FL_CURLIB_ADMIN_U");

htmlEncodedTvb tvbCurLibAuditDownload("FL_CURLIB_AUD_DOWNLOAD");
basicTvb tvbCurLibAuditDownloadChk("FL_CURLIB_AUD_DOWNLOAD_CHK");
basicTvb tvbCurLibAuditDownloadNum("FL_CURLIB_AUD_DOWNLOAD_NUM");

htmlEncodedTvb tvbCurLibAuditUpload("FL_CURLIB_AUD_UPLOAD");
basicTvb tvbCurLibAuditUploadChk("FL_CURLIB_AUD_UPLOAD_CHK");
basicTvb tvbCurLibAuditUploadNum("FL_CURLIB_AUD_UPLOAD_NUM");

htmlEncodedTvb tvbCurLibOnCD("FL_CURLIB_CD");
basicTvb tvbCurLibOnCDChk("FL_CURLIB_CD_CHK");
basicTvb tvbCurLibOnCDNum("FL_CURLIB_CD_NUM");

basicTvb tvbCurLibDownloadFileCharge("FL_CURLIB_CHG_DOWNLOAD_FILE");
basicTvb tvbCurLibDownloadFileKbyte("FL_CURLIB_CHG_DOWNLOAD_KB");
basicTvb tvbCurLibClusterSize("FL_CURLIB_CLUSTER");

basicTvb tvbCurLibCreateDateD("FL_CURLIB_CREATE_DATE_D");
basicTvb tvbCurLibCreateDateD0("FL_CURLIB_CREATE_DATE_D0");
basicTvb tvbCurLibCreateDateEurL("FL_CURLIB_CREATE_DATE_EUR_L");
basicTvb tvbCurLibCreateDateEurS("FL_CURLIB_CREATE_DATE_EUR_S");
basicTvb tvbCurLibCreateDateML("FL_CURLIB_CREATE_DATE_M_L");
basicTvb tvbCurLibCreateDateMN("FL_CURLIB_CREATE_DATE_M_N");
basicTvb tvbCurLibCreateDateMN0("FL_CURLIB_CREATE_DATE_M_N0");
basicTvb tvbCurLibCreateDateMS("FL_CURLIB_CREATE_DATE_M_S");
basicTvb tvbCurLibCreateDateUsaL("FL_CURLIB_CREATE_DATE_USA_L");
basicTvb tvbCurLibCreateDateUsaS("FL_CURLIB_CREATE_DATE_USA_S");
basicTvb tvbCurLibCreateDateWL("FL_CURLIB_CREATE_DATE_W_L");
basicTvb tvbCurLibCreateDateWS("FL_CURLIB_CREATE_DATE_W_S");
basicTvb tvbCurLibCreateDateYL("FL_CURLIB_CREATE_DATE_Y_L");
basicTvb tvbCurLibCreateDateYS("FL_CURLIB_CREATE_DATE_Y_S");
basicTvb tvbCurLibCreateTime12L("FL_CURLIB_CREATE_TIME_12_L");
basicTvb tvbCurLibCreateTime12S("FL_CURLIB_CREATE_TIME_12_S");
basicTvb tvbCurLibCreateTime24L("FL_CURLIB_CREATE_TIME_24_L");
basicTvb tvbCurLibCreateTime24S("FL_CURLIB_CREATE_TIME_24_S");
basicTvb tvbCurLibCreateTimeAL("FL_CURLIB_CREATE_TIME_A_L");
basicTvb tvbCurLibCreateTimeALC("FL_CURLIB_CREATE_TIME_A_LC");
basicTvb tvbCurLibCreateTimeALP("FL_CURLIB_CREATE_TIME_A_LP");
basicTvb tvbCurLibCreateTimeALPC("FL_CURLIB_CREATE_TIME_A_LPC");
basicTvb tvbCurLibCreateTimeAS("FL_CURLIB_CREATE_TIME_A_S");
basicTvb tvbCurLibCreateTimeASC("FL_CURLIB_CREATE_TIME_A_SC");
basicTvb tvbCurLibCreateTimeH12("FL_CURLIB_CREATE_TIME_H_12");
basicTvb tvbCurLibCreateTimeH120("FL_CURLIB_CREATE_TIME_H_120");
basicTvb tvbCurLibCreateTimeH24("FL_CURLIB_CREATE_TIME_H_24");
basicTvb tvbCurLibCreateTimeH240("FL_CURLIB_CREATE_TIME_H_240");
basicTvb tvbCurLibCreateTimeM("FL_CURLIB_CREATE_TIME_H_M");
basicTvb tvbCurLibCreateTimeM0("FL_CURLIB_CREATE_TIME_H_M0");
basicTvb tvbCurLibCreateTimeS("FL_CURLIB_CREATE_TIME_H_S");
basicTvb tvbCurLibCreateTimeS0("FL_CURLIB_CREATE_TIME_H_S0");

htmlEncodedTvb tvbCurLibDescription("FL_CURLIB_DESC");
htmlEncodedTvb tvbCurLibDetail("FL_CURLIB_DETAIL");
htmlEncodedTvb tvbCurLibDetailLine("FL_CURLIB_DETAIL_LINE");
basicTvb tvbCurLibDetailRaw("FL_CURLIB_DETAIL_RAW");
basicTvb tvbCurLibDetailJS("FL_CURLIB_DETAIL_JS");
basicTvb tvbCurLibHidden("FL_CURLIB_HIDDEN");
basicTvb tvbCurLibHiddenChk("FL_CURLIB_HIDDEN_CHK");
basicTvb tvbCurLibHiddenNum("FL_CURLIB_HIDDEN_NUM");

htmlEncodedTvb tvbCurLibKeyAdmin("FL_CURLIB_KEY_ADMIN");
htmlEncodedTvb tvbCurLibKeyAutoApprove("FL_CURLIB_KEY_AUTOAPP");
htmlEncodedTvb tvbCurLibKeyDownload("FL_CURLIB_KEY_DOWNLOAD");
htmlEncodedTvb tvbCurLibKeyOverwrite("FL_CURLIB_KEY_OVERWRITE");
htmlEncodedTvb tvbCurLibKeyUpload("FL_CURLIB_KEY_UPLOAD");
htmlEncodedTvb tvbCurLibKeyView("FL_CURLIB_KEY_VIEW");
basicTvb tvbCurLibMaxBytes("FL_CURLIB_MAX_BYTES");
htmlEncodedTvb tvbCurLibMaxBytesAbbr("FL_CURLIB_MAX_BYTES_ABBR");
basicTvb tvbCurLibMaxBytesC("FL_CURLIB_MAX_BYTES_C");
basicTvb tvbCurLibMaxFileBytes("FL_CURLIB_MAX_FILE_BYTES");
htmlEncodedTvb tvbCurLibMaxFileBytesAbbr("FL_CURLIB_MAX_FILE_BYTES_ABBR");
basicTvb tvbCurLibMaxFileBytesC("FL_CURLIB_MAX_FILE_BYTES_C");
basicTvb tvbCurLibMaxFiles("FL_CURLIB_MAX_FILES");
basicTvb tvbCurLibMaxFilesC("FL_CURLIB_MAX_FILES_C");
htmlEncodedTvb tvbCurLibName("FL_CURLIB_NAME");
urlEncodedTvb tvbCurLibNameUrl("FL_CURLIB_NAME_U");
htmlEncodedTvb tvbCurLibNoChargeDownload("FL_CURLIB_NOCHG_DOWNLOAD");
basicTvb tvbCurLibNoChargeDownloadChk("FL_CURLIB_NOCHG_DOWNLOAD_CHK");
basicTvb tvbCurLibNoChargeDownloadNum("FL_CURLIB_NOCHG_DOWNLOAD_NUM");
htmlEncodedTvb tvbCurLibNoChargeUpload("FL_CURLIB_NOCHG_UPLOAD");
basicTvb tvbCurLibNoChargeUploadChk("FL_CURLIB_NOCHG_UPLOAD_CHK");
basicTvb tvbCurLibNoChargeUploadNum("FL_CURLIB_NOCHG_UPLOAD_NUM");
basicTvb tvbCurLibNumFiles("FL_CURLIB_NUM_FILES");
basicTvb tvbCurLibNumFilesC("FL_CURLIB_NUM_FILES_C");
basicTvb tvbCurLibNumFilesJoined("FL_CURLIB_NUM_FILES_JOINED");
basicTvb tvbCurLibNumFilesJoinedC("FL_CURLIB_NUM_FILES_JOINED_C");
basicTvb tvbCurLibNumJoined("FL_CURLIB_NUM_JOINED");
basicTvb tvbCurLibNumUnapproved("FL_CURLIB_NUM_UNAPP");
basicTvb tvbCurLibNumUnapprovedC("FL_CURLIB_NUM_UNAPP_C");
htmlEncodedTvb tvbCurLibOSOnly("FL_CURLIB_OSONLY");
basicTvb tvbCurLibOSOnlyChk("FL_CURLIB_OSONLY_CHK");
basicTvb tvbCurLibOSOnlyNum("FL_CURLIB_OSONLY_NUM");

basicTvb** tvbCurLibParent=NULL; // FL_CURLIB_PARENT_n (0-9)

basicTvb tvbCurLibParentCount("FL_CURLIB_PARENT_COUNT");
basicTvb tvbCurLibParentList("FL_CURLIB_PARENT_LIST");

htmlEncodedTvb tvbCurLibPath("FL_CURLIB_PATH");
htmlEncodedTvb tvbCurLibReadOnly("FL_CURLIB_READONLY");
htmlEncodedTvb tvbCurLibReadOnlyChk("FL_CURLIB_READONLY_CHK");
htmlEncodedTvb tvbCurLibReadOnlyNum("FL_CURLIB_READONLY_NUM");

basicTvb tvbCurLibRoyalty("FL_CURLIB_ROYALTY");
basicTvb tvbCurLibTotalBytes("FL_CURLIB_TOT_BYTES");
htmlEncodedTvb tvbCurLibTotalBytesAbbr("FL_CURLIB_TOT_BYTES_ABBR");
basicTvb tvbCurLibTotalBytesC("FL_CURLIB_TOT_BYTES_C");

basicTvb tvbCurLibUploadsDay("FL_CURLIB_UPLOADS_DAY");
basicTvb tvbCurLibUploadsDayC("FL_CURLIB_UPLOADS_DAY_C");

basicTvb tvbCurLibUploadsWeek("FL_CURLIB_UPLOADS_WEEK");
basicTvb tvbCurLibUploadsWeekC("FL_CURLIB_UPLOADS_WEEK_C");

// file vars

basicTvb tvbFileAddDateD("FL_FILE_ADD_DATE_D");
basicTvb tvbFileAddDateD0("FL_FILE_ADD_DATE_D0");
basicTvb tvbFileAddDateEurL("FL_FILE_ADD_DATE_EUR_L");
basicTvb tvbFileAddDateEurS("FL_FILE_ADD_DATE_EUR_S");
basicTvb tvbFileAddDateML("FL_FILE_ADD_DATE_M_L");
basicTvb tvbFileAddDateMN("FL_FILE_ADD_DATE_M_N");
basicTvb tvbFileAddDateMN0("FL_FILE_ADD_DATE_M_N0");
basicTvb tvbFileAddDateMS("FL_FILE_ADD_DATE_M_S");
basicTvb tvbFileAddDateUsaL("FL_FILE_ADD_DATE_USA_L");
basicTvb tvbFileAddDateUsaS("FL_FILE_ADD_DATE_USA_S");
basicTvb tvbFileAddDateWL("FL_FILE_ADD_DATE_W_L");
basicTvb tvbFileAddDateWS("FL_FILE_ADD_DATE_W_S");
basicTvb tvbFileAddDateYL("FL_FILE_ADD_DATE_Y_L");
basicTvb tvbFileAddDateYS("FL_FILE_ADD_DATE_Y_S");
basicTvb tvbFileAddTime12L("FL_FILE_ADD_TIME_12_L");
basicTvb tvbFileAddTime12S("FL_FILE_ADD_TIME_12_S");
basicTvb tvbFileAddTime24L("FL_FILE_ADD_TIME_24_L");
basicTvb tvbFileAddTime24S("FL_FILE_ADD_TIME_24_S");
basicTvb tvbFileAddTimeAL("FL_FILE_ADD_TIME_A_L");
basicTvb tvbFileAddTimeALC("FL_FILE_ADD_TIME_A_LC");
basicTvb tvbFileAddTimeALP("FL_FILE_ADD_TIME_A_LP");
basicTvb tvbFileAddTimeALPC("FL_FILE_ADD_TIME_A_LPC");
basicTvb tvbFileAddTimeAS("FL_FILE_ADD_TIME_A_S");
basicTvb tvbFileAddTimeASC("FL_FILE_ADD_TIME_A_SC");
basicTvb tvbFileAddTimeH12("FL_FILE_ADD_TIME_H_12");
basicTvb tvbFileAddTimeH120("FL_FILE_ADD_TIME_H_120");
basicTvb tvbFileAddTimeH24("FL_FILE_ADD_TIME_H_24");
basicTvb tvbFileAddTimeH240("FL_FILE_ADD_TIME_H_240");
basicTvb tvbFileAddTimeM("FL_FILE_ADD_TIME_M");
basicTvb tvbFileAddTimeM0("FL_FILE_ADD_TIME_M0");
basicTvb tvbFileAddTimeS("FL_FILE_ADD_TIME_S");
basicTvb tvbFileAddTimeS0("FL_FILE_ADD_TIME_S0");

basicTvb tvbFileStampDateD("FL_FILE_STAMP_DATE_D");
basicTvb tvbFileStampDateD0("FL_FILE_STAMP_DATE_D0");
basicTvb tvbFileStampDateEurL("FL_FILE_STAMP_DATE_EUR_L");
basicTvb tvbFileStampDateEurS("FL_FILE_STAMP_DATE_EUR_S");
basicTvb tvbFileStampDateML("FL_FILE_STAMP_DATE_M_L");
basicTvb tvbFileStampDateMN("FL_FILE_STAMP_DATE_M_N");
basicTvb tvbFileStampDateMN0("FL_FILE_STAMP_DATE_M_N0");
basicTvb tvbFileStampDateMS("FL_FILE_STAMP_DATE_M_S");
basicTvb tvbFileStampDateUsaL("FL_FILE_STAMP_DATE_USA_L");
basicTvb tvbFileStampDateUsaS("FL_FILE_STAMP_DATE_USA_S");
basicTvb tvbFileStampDateWL("FL_FILE_STAMP_DATE_W_L");
basicTvb tvbFileStampDateWS("FL_FILE_STAMP_DATE_W_S");
basicTvb tvbFileStampDateYL("FL_FILE_STAMP_DATE_Y_L");
basicTvb tvbFileStampDateYS("FL_FILE_STAMP_DATE_Y_S");
basicTvb tvbFileStampTime12L("FL_FILE_STAMP_TIME_12_L");
basicTvb tvbFileStampTime12S("FL_FILE_STAMP_TIME_12_S");
basicTvb tvbFileStampTime24L("FL_FILE_STAMP_TIME_24_L");
basicTvb tvbFileStampTime24S("FL_FILE_STAMP_TIME_24_S");
basicTvb tvbFileStampTimeAL("FL_FILE_STAMP_TIME_A_L");
basicTvb tvbFileStampTimeALC("FL_FILE_STAMP_TIME_A_LC");
basicTvb tvbFileStampTimeALP("FL_FILE_STAMP_TIME_A_LP");
basicTvb tvbFileStampTimeALPC("FL_FILE_STAMP_TIME_A_LPC");
basicTvb tvbFileStampTimeAS("FL_FILE_STAMP_TIME_A_S");
basicTvb tvbFileStampTimeASC("FL_FILE_STAMP_TIME_A_SC");
basicTvb tvbFileStampTimeH12("FL_FILE_STAMP_TIME_H_12");
basicTvb tvbFileStampTimeH120("FL_FILE_STAMP_TIME_H_120");
basicTvb tvbFileStampTimeH24("FL_FILE_STAMP_TIME_H_24");
basicTvb tvbFileStampTimeH240("FL_FILE_STAMP_TIME_H_240");
basicTvb tvbFileStampTimeM("FL_FILE_STAMP_TIME_M");
basicTvb tvbFileStampTimeM0("FL_FILE_STAMP_TIME_M0");
basicTvb tvbFileStampTimeS("FL_FILE_STAMP_TIME_S");
basicTvb tvbFileStampTimeS0("FL_FILE_STAMP_TIME_S0");

htmlEncodedTvb tvbFileApproved("FL_FILE_APPROVED");
basicTvb tvbFileApprovedChk("FL_FILE_APPROVED_CHK");
basicTvb tvbFileApprovedNum("FL_FILE_APPROVED_NUM");

basicTvb tvbFileArchive("FL_FILE_ARCHIVE");
htmlEncodedTvb tvbFileDescription("FL_FILE_DESC");
basicTvb tvbFileDescriptionRaw("FL_FILE_DESC_RAW");
basicTvb tvbFileDetail("FL_FILE_DETAIL");
basicTvb tvbFileDetailLine("FL_FILE_DETAIL_LINE");
basicTvb tvbFileDetailRaw("FL_FILE_DETAIL_RAW");
basicTvb tvbFileDetailJS("FL_FILE_DETAIL_JS");

basicTvb tvbFileDownloads("FL_FILE_DOWNLOADS");
htmlEncodedTvb tvbFileDownloadsC("FL_FILE_DOWNLOADS_C");

htmlEncodedTvb tvbFileLib("FL_FILE_LIB");
urlEncodedTvb tvbFileLibUrl("FL_FILE_LIB_U");

htmlEncodedTvb tvbFileName("FL_FILE_NAME");
urlEncodedTvb tvbFileNameUrl("FL_FILE_NAME_U");

basicTvb tvbFileSize("FL_FILE_SIZE");
htmlEncodedTvb tvbFileSizeAbbr("FL_FILE_SIZE_ABBR");
basicTvb tvbFileSizeC("FL_FILE_SIZE_C");

basicTvb tvbFileUnapproved("FL_FILE_UNAPPROVED");
htmlEncodedTvb tvbFileUploadedBy("FL_FILE_UPLOADED_BY");
urlEncodedTvb tvbFileUploadedByUrl("FL_FILE_UPLOADED_BY_U");
basicTvb tvbFileDownloadCharge("FL_FILE_DOWNLOAD_CHG");

htmlEncodedTvb tvbFileHeldName("FL_UPLOAD_HELD_NAME");
urlEncodedTvb tvbFileHeldNameUrl("FL_UPLOAD_HELD_NAME_U");

basicTvb tvbListCount("FL_LIST_COUNT");
basicTvb tvbListOrder("FL_LIST_ORDER");
urlEncodedTvb tvbListItemLow("FL_LIST_ITEM_LOW");
urlEncodedTvb tvbListItemHigh("FL_LIST_ITEM_HIGH");
basicTvb tvbListMoreLow("FL_LIST_MORE_LOW");
basicTvb tvbListMoreHigh("FL_LIST_MORE_HIGH");
basicTvb tvbListAccess("FL_LIST_ACCESS");
basicTvb tvbListType("FL_LIST_TYPE");
basicTvb tvbListParent("FL_LIST_PARENT");
urlEncodedTvb tvbListParentUrl("FL_LIST_PARENT");

basicTvb** tvbListNone=NULL; // FL_LIST_NONE_n (1-9)

basicTvb tvbArcFileDateD("FL_ARCFILE_DATE_D");
basicTvb tvbArcFileDateD0("FL_ARCFILE_DATE_D0");
basicTvb tvbArcFileDateEurL("FL_ARCFILE_DATE_EUR_L");
basicTvb tvbArcFileDateEurS("FL_ARCFILE_DATE_EUR_S");
basicTvb tvbArcFileDateML("FL_ARCFILE_DATE_M_L");
basicTvb tvbArcFileDateMN("FL_ARCFILE_DATE_M_N");
basicTvb tvbArcFileDateMN0("FL_ARCFILE_DATE_M_N0");
basicTvb tvbArcFileDateMS("FL_ARCFILE_DATE_M_S");
basicTvb tvbArcFileDateUsaL("FL_ARCFILE_DATE_USA_L");
basicTvb tvbArcFileDateUsaS("FL_ARCFILE_DATE_USA_S");
basicTvb tvbArcFileDateWL("FL_ARCFILE_DATE_W_L");
basicTvb tvbArcFileDateWS("FL_ARCFILE_DATE_W_S");
basicTvb tvbArcFileDateYL("FL_ARCFILE_DATE_Y_L");
basicTvb tvbArcFileDateYS("FL_ARCFILE_DATE_Y_S");
basicTvb tvbArcFileTime12L("FL_ARCFILE_TIME_12_L");
basicTvb tvbArcFileTime12S("FL_ARCFILE_TIME_12_S");
basicTvb tvbArcFileTime24L("FL_ARCFILE_TIME_24_L");
basicTvb tvbArcFileTime24S("FL_ARCFILE_TIME_24_S");
basicTvb tvbArcFileTimeAL("FL_ARCFILE_TIME_A_L");
basicTvb tvbArcFileTimeALC("FL_ARCFILE_TIME_A_LC");
basicTvb tvbArcFileTimeALP("FL_ARCFILE_TIME_A_LP");
basicTvb tvbArcFileTimeALPC("FL_ARCFILE_TIME_A_LPC");
basicTvb tvbArcFileTimeAS("FL_ARCFILE_TIME_A_S");
basicTvb tvbArcFileTimeASC("FL_ARCFILE_TIME_A_SC");
basicTvb tvbArcFileTimeH12("FL_ARCFILE_TIME_H_12");
basicTvb tvbArcFileTimeH120("FL_ARCFILE_TIME_H_120");
basicTvb tvbArcFileTimeH24("FL_ARCFILE_TIME_H_24");
basicTvb tvbArcFileTimeH240("FL_ARCFILE_TIME_H_240");
basicTvb tvbArcFileTimeM("FL_ARCFILE_TIME_M");
basicTvb tvbArcFileTimeM0("FL_ARCFILE_TIME_M0");
basicTvb tvbArcFileTimeS("FL_ARCFILE_TIME_S");
basicTvb tvbArcFileTimeS0("FL_ARCFILE_TIME_S0");

basicTvb tvbArcFileCrcDec("FL_ARCFILE_CRC_DEC");
basicTvb tvbArcFileCrcHex("FL_ARCFILE_CRC_HEX");
basicTvb tvbArcFileCrcHexLC("FL_ARCFILE_CRC_HEX_LC");
htmlEncodedTvb tvbArcFileMethod("FL_ARCFILE_METHOD");
htmlEncodedTvb tvbArcFileName("FL_ARCFILE_NAME");
htmlEncodedTvb tvbArcFilePercentOriginal("FL_ARCFILE_PERCENT_ORIGINAL");
htmlEncodedTvb tvbArcFilePercentReduced("FL_ARCFILE_PERCENT_REDUCED");
basicTvb tvbArcFileSizeCompressed("FL_ARCFILE_SIZE_COMP");
basicTvb tvbArcFileSizeCompressedAbbr("FL_ARCFILE_SIZE_COMP_ABBR");
htmlEncodedTvb tvbArcFileSizeCompressedC("FL_ARCFILE_SIZE_COMP_C");
basicTvb tvbArcFileSizeUnCompressed("FL_ARCFILE_SIZE_UNCOMP");
basicTvb tvbArcFileSizeUnCompressedAbbr("FL_ARCFILE_SIZE_UNCOMP_ABBR");
htmlEncodedTvb tvbArcFileSizeUnCompressedC("FL_ARCFILE_SIZE_UNCOMP_C");

basicTvb tvbSearchType("FL_SEARCH_TYPE");
basicTvb tvbSearchTypeDisp("FL_SEARCH_TYPE_DISP");
htmlEncodedTvb tvbSearchWildcard("FL_SEARCH_WILDCARD");
htmlEncodedTvb tvbSearchKeywords("FL_SEARCH_KEYWORDS");
urlEncodedTvb tvbSearchWildcardUrl("FL_SEARCH_WILDCARD_U");
urlEncodedTvb tvbSearchKeywordsUrl("FL_SEARCH_KEYWORDS_U");

basicTvb tvbPrefLibListOrder("FL_PREF_LIB_LIST_ORDER");
basicTvb tvbPrefBrowseType("FL_PREF_BROWSE_TYPE");
basicTvb tvbPrefBrowseOrder("FL_PREF_BROWSE_ORDER");

basicTvb** tvbAdminLinks=NULL; // FL_ADMIN_LINK_n (1-9)
basicTvb** tvbFlTarget=NULL; // FL_TARGET_N (1-9)

basicTvb tvbFlTemplateMask("FL_TEMPLATE_MASK");

basicTvb tvbFlErrorCode("FL_ERR_CODE");
basicTvb tvbFlErrorMessage("FL_ERR_MESSAGE");

MARKSOURCE(filtvb)


VOID
initMcvText()                      // initalize strings for text variables
{
     ::setmbk(filahmb);
     for (INT i=0, j=NOFILE1 ; i < FILNOLIST ; i++, j++) {
          g_pszNoList[i]=stpans(stgopt(j));
     }
     for (INT i=0, j=NOLIB1 ; i < FILNOLIST ; i++, j++) {
          g_pszNoListLib[i]=stpans(stgopt(j));
     }
     for (INT i=0, j=GADMINY1 ; i < NOADMINLINKS ; i++, j++) {
          g_pszAdminLinks[i]=stpans(stgopt(j));
     }
     for (INT i=0, j=GADMINN1 ; i < NOADMINLINKS ; i++, j++) {
          g_pszNoAdminLinks[i]=stpans(stgopt(j));
     }
     for (INT i=0, j=TARGET1 ; i < NOTARGETS ; i++, j++) {
          g_pszTargets[i]=stpans(stgopt(j));
     }
     g_pszFlagon=stpans(stgopt(FLAGON));
     g_pszFlagoff=stpans(stgopt(FLAGOFF));
     g_pszParsep=stpans(stgopt(PARSEP));
     g_pszNodesc=stpans(stgopt(NODESC));
     g_pszSTypeName=stpans(stgopt(STNAME));
     g_pszSTypeDate=stpans(stgopt(STDATE));
     g_pszSTypePop=stpans(stgopt(STPOP));
     g_pszSTypeKeywords=stpans(stgopt(STKEY));
     g_pszAppdsp=stpans(stgopt(APPDSP));
     g_pszUnapdsp=stpans(stgopt(UNAPDSP));

     g_iWraplen=numopt(WRAPLEN,0,256);
     g_pszParacc=stgopt(PARACC);
     g_bJoin1st=ynopt(JOIN1ST);
}

VOID
finishMcvText()                    // cleanup the text variable text strings
{
     for (INT i=0 ; i < FILNOLIST ; i++) {
          if (g_pszNoList[i] != NULL) {
               free(g_pszNoList[i]);
               g_pszNoList[i]=NULL;
          }
     }
     for (INT i=0 ; i < FILNOLIST ; i++) {
          if (g_pszNoListLib[i] != NULL) {
               free(g_pszNoListLib[i]);
               g_pszNoListLib[i]=NULL;
          }
     }
     for (INT i=0 ; i < NOADMINLINKS ; i++) {
          if (g_pszAdminLinks[i] != NULL) {
               free(g_pszAdminLinks[i]);
               g_pszAdminLinks[i]=NULL;
          }
     }
     for (INT i=0 ; i < NOADMINLINKS ; i++) {
          if (g_pszNoAdminLinks[i] != NULL) {
               free(g_pszNoAdminLinks[i]);
               g_pszNoAdminLinks[i]=NULL;
          }
     }
     for (INT i=0 ; i < NOADMINLINKS ; i++) {
          if (g_pszTargets[i] != NULL) {
               free(g_pszTargets[i]);
               g_pszTargets[i]=NULL;
          }
     }
     if (g_pszFlagon != NULL) {
          free (g_pszFlagon);
          g_pszFlagon=NULL;
     }
     if (g_pszFlagoff != NULL) {
          free (g_pszFlagoff);
          g_pszFlagoff=NULL;
     }
     if (g_pszParsep != NULL) {
          free (g_pszParsep);
          g_pszParsep=NULL;
     }
     if (g_pszNodesc != NULL) {
          free (g_pszNodesc);
          g_pszNodesc=NULL;
     }
     if (g_pszParacc != NULL) {
          free (g_pszParacc);
          g_pszParacc=NULL;
     }
     if (g_pszSTypePop != NULL) {
          free (g_pszSTypePop);
          g_pszSTypePop=NULL;
     }
     if (g_pszSTypeName != NULL) {
          free (g_pszSTypeName);
          g_pszSTypeName=NULL;
     }
     if (g_pszSTypeKeywords != NULL) {
          free (g_pszSTypeKeywords);
          g_pszSTypeKeywords=NULL;
     }
     if (g_pszSTypeDate != NULL) {
          free (g_pszSTypeDate);
          g_pszSTypeDate=NULL;
     }
}

VOID
initTvars()                        // initalize text variables
{
     tvbListNone=new basicTvb* [FILNOLIST];
     registerRange(tvbListNone,TVB_BASIC,"FL_LIST_NONE_",FILNOLIST,1,NULL);
     tvbLibParent=new basicTvb* [FILPARENT];
     registerRange(tvbLibParent,TVB_BASIC,"FL_LIB_PARENT_",FILPARENT,0,NULL);
     tvbCurLibParent=new basicTvb* [FILPARENT];
     registerRange(tvbCurLibParent,TVB_BASIC,"FL_CURLIB_PARENT_",FILPARENT,0,NULL);
     tvbAdminLinks=new basicTvb* [NOADMINLINKS];
     registerRange(tvbAdminLinks,TVB_BASIC,"FL_ADMIN_LINK_",NOADMINLINKS,1,NULL);
     tvbFlTarget=new basicTvb* [NOTARGETS];
     registerRange(tvbFlTarget,TVB_BASIC,"FL_TARGET_",NOTARGETS,1,NULL);
}

VOID
finishTvars()                      // cleanup text variables
{
     if (tvbListNone != NULL) {
          for (INT i=0 ; i < FILNOLIST ; i++) {
               delete tvbListNone[i];
          }
          delete [] tvbListNone;
          tvbListNone=NULL;
     }
     if (tvbLibParent != NULL) {
          for (INT i=0 ; i < FILPARENT ; i++) {
               delete tvbLibParent[i];
          }
          delete [] tvbLibParent;
          tvbLibParent=NULL;
     }
     if (tvbCurLibParent != NULL) {
          for (INT i=0 ; i < FILPARENT ; i++) {
               delete tvbCurLibParent[i];
          }
          delete [] tvbCurLibParent;
          tvbCurLibParent=NULL;
     }
     if (tvbAdminLinks != NULL) {
          for (INT i=0 ; i < NOADMINLINKS ; i++) {
               delete tvbAdminLinks[i];
          }
          delete [] tvbAdminLinks;
          tvbAdminLinks=NULL;
     }
     if (tvbFlTarget != NULL) {
          for (INT i=0 ; i < NOTARGETS ; i++) {
               delete tvbFlTarget[i];
          }
          delete [] tvbFlTarget;
          tvbFlTarget=NULL;
     }
}

VOID
clearVars()                        // clear text variables
{
     clearFileVars();
     clearLibVars();
     clearArcVars();
     clearCurLibVars();
     clearListVars();
     clearSearchVars();
     clearGlobalVars();
}

VOID
clearGlobalVars()                  // clear global variables
{
     tvbPrefLibListOrder="";
     tvbPrefBrowseType="";
     tvbPrefBrowseOrder="";
     tvbFlTemplateMask="";
     tvbFlErrorCode="";
     tvbFlErrorMessage="";
     setAdminLinks(false);
     setTarget(false);
}

VOID
clearSearchVars()                  // clear search variables
{
     tvbSearchType="";
     tvbSearchWildcard="";
     tvbSearchKeywords="";
     tvbSearchKeywordsUrl="";
     tvbSearchWildcardUrl="";
}


VOID
clearFileVars()                    // clear file variables
{
     tvbFileAddDateD="";
     tvbFileAddDateD0="";
     tvbFileAddDateEurL="";
     tvbFileAddDateEurS="";
     tvbFileAddDateML="";
     tvbFileAddDateMN="";
     tvbFileAddDateMN0="";
     tvbFileAddDateMS="";
     tvbFileAddDateUsaL="";
     tvbFileAddDateUsaS="";
     tvbFileAddDateWL="";
     tvbFileAddDateWS="";
     tvbFileAddDateYL="";
     tvbFileAddDateYS="";
     tvbFileAddTime12L="";
     tvbFileAddTime12S="";
     tvbFileAddTime24L="";
     tvbFileAddTime24S="";
     tvbFileAddTimeAL="";
     tvbFileAddTimeALC="";
     tvbFileAddTimeALP="";
     tvbFileAddTimeALPC="";
     tvbFileAddTimeAS="";
     tvbFileAddTimeASC="";
     tvbFileAddTimeH12="";
     tvbFileAddTimeH120="";
     tvbFileAddTimeH24="";
     tvbFileAddTimeH240="";
     tvbFileAddTimeM="";
     tvbFileAddTimeM0="";
     tvbFileAddTimeS="";
     tvbFileAddTimeS0="";
     tvbFileStampDateD="";
     tvbFileStampDateD0="";
     tvbFileStampDateEurL="";
     tvbFileStampDateEurS="";
     tvbFileStampDateML="";
     tvbFileStampDateMN="";
     tvbFileStampDateMN0="";
     tvbFileStampDateMS="";
     tvbFileStampDateUsaL="";
     tvbFileStampDateUsaS="";
     tvbFileStampDateWL="";
     tvbFileStampDateWS="";
     tvbFileStampDateYL="";
     tvbFileStampDateYS="";
     tvbFileStampTime12L="";
     tvbFileStampTime12S="";
     tvbFileStampTime24L="";
     tvbFileStampTime24S="";
     tvbFileStampTimeAL="";
     tvbFileStampTimeALC="";
     tvbFileStampTimeALP="";
     tvbFileStampTimeALPC="";
     tvbFileStampTimeAS="";
     tvbFileStampTimeASC="";
     tvbFileStampTimeH12="";
     tvbFileStampTimeH120="";
     tvbFileStampTimeH24="";
     tvbFileStampTimeH240="";
     tvbFileStampTimeM="";
     tvbFileStampTimeM0="";
     tvbFileStampTimeS="";
     tvbFileStampTimeS0="";
     tvbFileApproved="";
     tvbFileApprovedChk="";
     tvbFileApprovedNum="";
     tvbFileArchive="";
     tvbFileDescription="";
     tvbFileDescriptionRaw="";
     tvbFileDetail="";
     tvbFileDetailLine="";
     tvbFileDetailRaw="";
     tvbFileDetailJS="";
     tvbFileDownloads="";
     tvbFileDownloadsC="";
     tvbFileLib="";
     tvbFileLibUrl="";
     tvbFileName="";
     tvbFileNameUrl="";
     tvbFileSize="";
     tvbFileSizeAbbr="";
     tvbFileSizeC="";
     tvbFileUnapproved="";
     tvbFileUploadedBy="";
     tvbFileUploadedByUrl="";
     tvbFileDownloadCharge="";
     tvbFileHeldName="";
     tvbFileHeldNameUrl="";
}

VOID
clearArcVars()                     // clear archive variables
{
     tvbArcFileDateD="";
     tvbArcFileDateD0="";
     tvbArcFileDateEurL="";
     tvbArcFileDateEurS="";
     tvbArcFileDateML="";
     tvbArcFileDateMN="";
     tvbArcFileDateMN0="";
     tvbArcFileDateMS="";
     tvbArcFileDateUsaL="";
     tvbArcFileDateUsaS="";
     tvbArcFileDateWL="";
     tvbArcFileDateWS="";
     tvbArcFileDateYL="";
     tvbArcFileDateYS="";
     tvbArcFileTime12L="";
     tvbArcFileTime12S="";
     tvbArcFileTime24L="";
     tvbArcFileTime24S="";
     tvbArcFileTimeAL="";
     tvbArcFileTimeALC="";
     tvbArcFileTimeALP="";
     tvbArcFileTimeALPC="";
     tvbArcFileTimeAS="";
     tvbArcFileTimeASC="";
     tvbArcFileTimeH12="";
     tvbArcFileTimeH120="";
     tvbArcFileTimeH24="";
     tvbArcFileTimeH240="";
     tvbArcFileTimeM="";
     tvbArcFileTimeM0="";
     tvbArcFileTimeS="";
     tvbArcFileTimeS0="";
     tvbArcFileCrcDec="";
     tvbArcFileCrcHex="";
     tvbArcFileCrcHexLC="";
     tvbArcFileMethod="";
     tvbArcFileName="";
     tvbArcFilePercentOriginal="";
     tvbArcFilePercentReduced="";
     tvbArcFileSizeCompressed="";
     tvbArcFileSizeCompressedAbbr="";
     tvbArcFileSizeCompressedC="";
     tvbArcFileSizeUnCompressed="";
     tvbArcFileSizeUnCompressedAbbr="";
     tvbArcFileSizeUnCompressedC="";
}

VOID
clearLibVars()                     // clear lib variables
{
     tvbLibAccessAdmin="";
     tvbLibAccessAutoApprove="";
     tvbLibAccessDownload="";
     tvbLibAccessOverwrite="";
     tvbLibAccessUpload="";
     tvbLibAccessView="";
     tvbLibAdminUser="";
     tvbLibAdminUserUrl="";
     tvbLibAuditDownload="";
     tvbLibAuditDownloadChk="";
     tvbLibAuditDownloadNum="";
     tvbLibAuditUpload="";
     tvbLibAuditUploadChk="";
     tvbLibAuditUploadNum="";
     tvbLibOnCD="";
     tvbLibOnCDChk="";
     tvbLibOnCDNum="";
     tvbLibDownloadFileCharge="";
     tvbLibDownloadFileKbyte="";
     tvbLibClusterSize="";
     tvbLibCreateDateD="";
     tvbLibCreateDateD0="";
     tvbLibCreateDateEurL="";
     tvbLibCreateDateEurS="";
     tvbLibCreateDateML="";
     tvbLibCreateDateMN="";
     tvbLibCreateDateMN0="";
     tvbLibCreateDateMS="";
     tvbLibCreateDateUsaL="";
     tvbLibCreateDateUsaS="";
     tvbLibCreateDateWL="";
     tvbLibCreateDateWS="";
     tvbLibCreateDateYL="";
     tvbLibCreateDateYS="";
     tvbLibCreateTime12L="";
     tvbLibCreateTime12S="";
     tvbLibCreateTime24L="";
     tvbLibCreateTime24S="";
     tvbLibCreateTimeAL="";
     tvbLibCreateTimeALC="";
     tvbLibCreateTimeALP="";
     tvbLibCreateTimeALPC="";
     tvbLibCreateTimeAS="";
     tvbLibCreateTimeASC="";
     tvbLibCreateTimeH12="";
     tvbLibCreateTimeH120="";
     tvbLibCreateTimeH24="";
     tvbLibCreateTimeH240="";
     tvbLibCreateTimeM="";
     tvbLibCreateTimeM0="";
     tvbLibCreateTimeS="";
     tvbLibCreateTimeS0="";
     tvbLibDescription="";
     tvbLibDetail="";
     tvbLibDetailLine="";
     tvbLibDetailRaw="";
     tvbLibDetailJS="";
     tvbLibHidden="";
     tvbLibHiddenChk="";
     tvbLibHiddenNum="";
     tvbLibKeyAdmin="";
     tvbLibKeyAutoApprove="";
     tvbLibKeyDownload="";
     tvbLibKeyOverwrite="";
     tvbLibKeyUpload="";
     tvbLibKeyView="";
     tvbLibMaxBytes="";
     tvbLibMaxBytesAbbr="";
     tvbLibMaxBytesC="";

     tvbLibMaxFileBytes="";
     tvbLibMaxFileBytesAbbr="";
     tvbLibMaxFileBytesC="";
     tvbLibMaxFiles="";
     tvbLibMaxFilesC="";
     tvbLibName="";
     tvbLibNameUrl="";
     tvbLibNoChargeDownload="";
     tvbLibNoChargeDownloadChk="";
     tvbLibNoChargeDownloadNum="";
     tvbLibNoChargeUpload="";
     tvbLibNoChargeUploadChk="";
     tvbLibNoChargeUploadNum="";
     tvbLibNumFiles="";
     tvbLibNumFilesC="";
     tvbLibNumFilesJoined="";
     tvbLibNumFilesJoinedC="";
     tvbLibNumJoined="";
     tvbLibNumUnapproved="";
     tvbLibNumUnapprovedC="";
     tvbLibOSOnly="";
     tvbLibOSOnlyChk="";
     tvbLibOSOnlyNum="";
     for (INT i=0 ; i < FILPARENT ; i++) {
          *(tvbLibParent[i])="";
     }
     tvbLibParentCount="";
     tvbLibParentList="";
     tvbLibPath="";
     tvbLibReadOnly="";
     tvbLibReadOnlyChk="";
     tvbLibReadOnlyNum="";
     tvbLibRoyalty="";
     tvbLibTotalBytes="";
     tvbLibTotalBytesAbbr="";
     tvbLibTotalBytesC="";
     tvbLibUploadsDay="";
     tvbLibUploadsDayC="";
     tvbLibUploadsWeek="";
     tvbLibUploadsWeekC="";
}

VOID
clearCurLibVars()                  // clear current lib variables
{
     tvbCurLibAccessAdmin="";
     tvbCurLibAccessAutoApprove="";
     tvbCurLibAccessDownload="";
     tvbCurLibAccessOverwrite="";
     tvbCurLibAccessUpload="";
     tvbCurLibAccessView="";
     tvbCurLibAdminUser="";
     tvbCurLibAdminUserUrl="";
     tvbCurLibAuditDownload="";
     tvbCurLibAuditDownloadChk="";
     tvbCurLibAuditDownloadNum="";
     tvbCurLibAuditUpload="";
     tvbCurLibAuditUploadChk="";
     tvbCurLibAuditUploadNum="";
     tvbCurLibOnCD="";
     tvbCurLibOnCDChk="";
     tvbCurLibOnCDNum="";
     tvbCurLibDownloadFileCharge="";
     tvbCurLibDownloadFileKbyte="";
     tvbCurLibClusterSize="";
     tvbCurLibCreateDateD="";
     tvbCurLibCreateDateD0="";
     tvbCurLibCreateDateEurL="";
     tvbCurLibCreateDateEurS="";
     tvbCurLibCreateDateML="";
     tvbCurLibCreateDateMN="";
     tvbCurLibCreateDateMN0="";
     tvbCurLibCreateDateMS="";
     tvbCurLibCreateDateUsaL="";
     tvbCurLibCreateDateUsaS="";
     tvbCurLibCreateDateWL="";
     tvbCurLibCreateDateWS="";
     tvbCurLibCreateDateYL="";
     tvbCurLibCreateDateYS="";
     tvbCurLibCreateTime12L="";
     tvbCurLibCreateTime12S="";
     tvbCurLibCreateTime24L="";
     tvbCurLibCreateTime24S="";
     tvbCurLibCreateTimeAL="";
     tvbCurLibCreateTimeALC="";
     tvbCurLibCreateTimeALP="";
     tvbCurLibCreateTimeALPC="";
     tvbCurLibCreateTimeAS="";
     tvbCurLibCreateTimeASC="";
     tvbCurLibCreateTimeH12="";
     tvbCurLibCreateTimeH120="";
     tvbCurLibCreateTimeH24="";
     tvbCurLibCreateTimeH240="";
     tvbCurLibCreateTimeM="";
     tvbCurLibCreateTimeM0="";
     tvbCurLibCreateTimeS="";
     tvbCurLibCreateTimeS0="";
     tvbCurLibDescription="";
     tvbCurLibDetail="";
     tvbCurLibDetailLine="";
     tvbCurLibDetailRaw="";
     tvbCurLibDetailJS="";
     tvbCurLibHidden="";
     tvbCurLibHiddenChk="";
     tvbCurLibHiddenNum="";
     tvbCurLibKeyAdmin="";
     tvbCurLibKeyAutoApprove="";
     tvbCurLibKeyDownload="";
     tvbCurLibKeyOverwrite="";
     tvbCurLibKeyUpload="";
     tvbCurLibKeyView="";
     tvbCurLibMaxBytes="";
     tvbCurLibMaxBytesAbbr="";
     tvbCurLibMaxBytesC="";
     tvbCurLibMaxFileBytes="";
     tvbCurLibMaxFileBytesAbbr="";
     tvbCurLibMaxFileBytesC="";
     tvbCurLibMaxFiles="";
     tvbCurLibMaxFilesC="";
     tvbCurLibName="";
     tvbCurLibNameUrl="";
     tvbCurLibNoChargeDownload="";
     tvbCurLibNoChargeDownloadChk="";
     tvbCurLibNoChargeDownloadNum="";
     tvbCurLibNoChargeUpload="";
     tvbCurLibNoChargeUploadChk="";
     tvbCurLibNoChargeUploadNum="";
     tvbCurLibNumFiles="";
     tvbCurLibNumFilesC="";
     tvbCurLibNumFilesJoined="";
     tvbCurLibNumFilesJoinedC="";
     tvbCurLibNumJoined="";
     tvbCurLibNumUnapproved="";
     tvbCurLibNumUnapprovedC="";
     tvbCurLibOSOnly="";
     tvbCurLibOSOnlyChk="";
     tvbCurLibOSOnlyNum="";
     for (INT i=0 ; i < FILPARENT ; i++) {
          *(tvbCurLibParent[i])="";
     }
     tvbCurLibParentCount="";
     tvbCurLibParentList="";
     tvbCurLibPath="";
     tvbCurLibReadOnly="";
     tvbCurLibReadOnlyChk="";
     tvbCurLibReadOnlyNum="";
     tvbCurLibRoyalty="";
     tvbCurLibTotalBytes="";
     tvbCurLibTotalBytesAbbr="";
     tvbCurLibTotalBytesC="";
     tvbCurLibUploadsDay="";
     tvbCurLibUploadsDayC="";
     tvbCurLibUploadsWeek="";
     tvbCurLibUploadsWeekC="";
}

VOID
clearListVars()                    // clear list variables
{
     tvbListCount="";
     tvbListOrder="";
     tvbListItemLow="";
     tvbListItemHigh="";
     tvbListMoreLow="";
     tvbListMoreHigh="";
     tvbListAccess="";
     tvbListType="";
     tvbListParent="";
     tvbListParentUrl="";

     setNoList(false,NULL);
}


VOID
setNoList(                         // set FL_NOLIST tvbs
bool bIsList,                      // was there a list?
CHAR** opts)                       // options to use
{
     ASSERT(tvbListNone != NULL);
     ASSERT(g_pszNoList != NULL);
     setTvbArray(tvbListNone,opts,FILNOLIST,bIsList);
}

VOID
setAdminLinks(                     // set administrator links
bool isAdmin)                      // is user administrator
{
     ASSERT(tvbAdminLinks != NULL);
     ASSERT(g_pszAdminLinks != NULL);
     if (isAdmin) {
          setTvbArray(tvbAdminLinks,g_pszAdminLinks,NOADMINLINKS,!isAdmin);
     }
     else {
          setTvbArray(tvbAdminLinks,g_pszNoAdminLinks,NOADMINLINKS,isAdmin);
     }
}

VOID
setTarget(                         // set target variables
bool inFrames)                     // using frames?
{
     ASSERT(tvbFlTarget != NULL);
     ASSERT(g_pszTargets != NULL);
     setTvbArray(tvbFlTarget,g_pszTargets,NOTARGETS,!inFrames);
}


VOID
setListContextVars(
INT iCount,                        // value to set FL_LIST_COUNT
LISTORDER loOrder,                 // value to set FL_LIST_ORDER
const CHAR* strLowItem,            // value to set FL_LIST_ITEM_LOW
const CHAR* strHighItem,           // value to set FL_LIST_ITEM_HIGH
bool bIsMoreLow,                   // value to set FL_LIST_MORE_LOW
bool bIsMoreHigh,                  // value to set FL_LIST_MORE_HIGH
bool bProducedResults,             // is there stuff in the list?
LISTTYPE iListType)                // type of list
{
     if (iCount > 0) {
          tvbListCount=iCount;
          tvbListOrder=(loOrder == ORDER_DESC) ? "descending" : "ascending";
          tvbListItemLow=strLowItem;
          tvbListItemHigh=strHighItem;
          tvbListMoreLow=bIsMoreLow ? 1 : 0;
          tvbListMoreHigh=bIsMoreHigh ? 1 : 0;
          setNoList(bProducedResults,iListType == LTYPE_FILE ? g_pszNoList
                                                             : g_pszNoListLib);
     }
     else {
          tvbListCount=0;
          tvbListMoreLow=0;
          tvbListMoreHigh=0;
          setNoList(false, NULL);
     }
}

VOID
setListLibContextVars(             // set lib list context variables
LIBACCESS laAccess,                // level of access to list (d, u, or a)
LIBTYPE ltType,                    // lib type (os, normal, or all
const char* parent)                // parent lib
{
     if (laAccess == LIST_DOWNLOAD) {
          tvbListAccess="d";
     }
     else if (laAccess == LIST_UPLOAD) {
          tvbListAccess="u";
     }
     else if (laAccess == LIST_ADMIN) {
          tvbListAccess="a";
     }
     else {
          tvbListAccess="";
     }
     if (ltType == TYPE_OS) {
          tvbListType="os";
     }
     else if (ltType == TYPE_NORMAL) {
          tvbListType="normal";
     }
     else {
          tvbListType="";
     }
     tvbListParent=parent;
     tvbListParentUrl=parent;
}

VOID
setSearchVars(                     // set search vars
SEARCHTYPE stype,                  // search type
const string& wc,                  // wildcard string
const string& kw)                  // keyword string
{
     switch (stype) {
     case STYPE_NAME:
          tvbSearchType="name";
          tvbSearchTypeDisp=g_pszSTypeName;
          break;
     case STYPE_DATE:
          tvbSearchType="date";
          tvbSearchTypeDisp=g_pszSTypeDate;
          break;
     case STYPE_POPULARITY:
          tvbSearchType="popularity";
          tvbSearchTypeDisp=g_pszSTypePop;
          break;
     case STYPE_KEYWORDS:
          tvbSearchType="keywords";
          tvbSearchTypeDisp=g_pszSTypeKeywords;
          break;
     default:
          ASSERTM(FALSE,spr("Err: %d",(INT)stype));
     }
     tvbSearchWildcard=wc;
     tvbSearchWildcardUrl=wc;

     tvbSearchKeywords=kw;
     tvbSearchKeywordsUrl=kw;
}

VOID
setLibVars(                        // set lib text variables
const struct fllib* flib,          // ptr to lib
acthUserID* uid)                   // User doing request
{
     CHAR fmtbuf[50];              // this should be large enough

     if (flib == NULL) {
          return;
     }

     USHORT iday=flib->day;
     USHORT itime=flib->time;

     tvbLibAccessAdmin=(LONG)ahIsFlop(uid,flib);
     tvbLibAccessAutoApprove=(LONG)ahHasLibKey(uid,flib,flib->autoap);
     tvbLibAccessDownload=(LONG)ahHasLibKey(uid,flib,flib->dlkey);
     tvbLibAccessOverwrite=(LONG)ahHasLibKey(uid,flib,flib->overw);
     tvbLibAccessUpload=(LONG)ahHasLibKey(uid,flib,flib->ulkey);
     tvbLibAccessView=(LONG)ahHasLibKey(uid,flib,flib->keyreq);
     tvbLibAdminUser=flib->primary;
     tvbLibAdminUserUrl=flib->primary;
     tvbLibAuditDownload=((flib->flags&FLGADL) != 0 ? g_pszFlagon : g_pszFlagoff);
     tvbLibAuditDownloadChk=((flib->flags&FLGADL) != 0 ? "CHECKED" : "");
     tvbLibAuditDownloadNum=((flib->flags&FLGADL) != 0 ? 1 : 0);
     tvbLibAuditUpload=((flib->flags&FLGAUL) != 0 ? g_pszFlagon : g_pszFlagoff);
     tvbLibAuditUploadChk=((flib->flags&FLGAUL) != 0 ? "CHECKED" : "");
     tvbLibAuditUploadNum=((flib->flags&FLGAUL) != 0 ? 1 : 0);
     tvbLibOnCD=((flib->flags&FLGCBD) != 0 ? g_pszFlagon : g_pszFlagoff);
     tvbLibOnCDChk=((flib->flags&FLGCBD) != 0 ? "CHECKED" : "");
     tvbLibOnCDNum=((flib->flags&FLGCBD) != 0 ? 1 : 0);
     tvbLibDownloadFileCharge=flib->dlchge;
     tvbLibDownloadFileKbyte=flib->kdlchge;
     tvbLibClusterSize=flib->cluster;

     tvbLibCreateDateD=ddday(iday);
     sprintf(fmtbuf,"%.2d",ddday(iday));
     tvbLibCreateDateD0=fmtbuf;
     sprintf(fmtbuf,"%d %s %d",ddday(iday)
                              ,strMonths[ddmon(iday)-1]
                              ,ddyear(iday));
     tvbLibCreateDateEurL=fmtbuf;
     tvbLibCreateDateEurS=ncedat(iday);
     tvbLibCreateDateML=strMonths[ddmon(iday)-1];
     tvbLibCreateDateMN=ddmon(iday);
     sprintf(fmtbuf,"%.2d",ddmon(iday));
     tvbLibCreateDateMN0=fmtbuf;
     stlcpy(fmtbuf,strMonths[ddmon(iday)-1],4);
     tvbLibCreateDateMS=fmtbuf;
     tvbLibCreateDateUsaL=prndat(PRND_MMMDYY,iday,'/');
     tvbLibCreateDateUsaS=ncdate(iday);
     tvbLibCreateDateWL=strDays[DOFWEEK(iday)];
     tvbLibCreateDateWS=shortDays[DOFWEEK(iday)];
     string year=stringFormat(ddyear(iday));
     tvbLibCreateDateYL=year;
     tvbLibCreateDateYS=year.c_str()+2;
     tvbLibCreateTime12L=prntim(PRNT_HMS_PM,itime);
     tvbLibCreateTime12S=prntim(PRNT_HM_PM,itime);
     tvbLibCreateTime24L=prntim(PRNT_HMS,itime);
     tvbLibCreateTime24S=prntim(PRNT_HM,itime);
     tvbLibCreateTimeAL=formatMeridiem(itime,FMT_L);
     tvbLibCreateTimeALC=formatMeridiem(itime,FMT_LC);
     tvbLibCreateTimeALP=formatMeridiem(itime,FMT_LP);
     tvbLibCreateTimeALPC=formatMeridiem(itime,FMT_LPC); //
     tvbLibCreateTimeAS=formatMeridiem(itime,FMT_S);
     tvbLibCreateTimeASC=formatMeridiem(itime,FMT_SC);

     INT hour=dthour(itime);
     tvbLibCreateTimeH12=hour%12;
     sprintf(fmtbuf,"%.2d",hour%12);
     tvbLibCreateTimeH120=fmtbuf;
     tvbLibCreateTimeH24=hour;
     sprintf(fmtbuf,"%.2d",hour);
     tvbLibCreateTimeH240=fmtbuf;

     INT min=dtmin(itime);
     tvbLibCreateTimeM=min;
     sprintf(fmtbuf,"%.2d",min);
     tvbLibCreateTimeM0=fmtbuf;

     INT sec=dtsec(itime);
     tvbLibCreateTimeS=sec;
     sprintf(fmtbuf,"%.2d",sec);
     tvbLibCreateTimeS0=fmtbuf;

     tvbLibDescription=flib->libdesc;
     struct libdisk ldisk;
     stlcpy(ldisk.lib.libname,flib->libname,FLNAMESZ);
     loadldsc(&ldisk);
     string descfull("");
     string descfullbr("");
     for (INT i=0; i < NDESCLN; i++) {
          if (strlen(ldisk.ldesc[i]) == 0) {
               break;
          }
          descfullbr+=htmlEncode(string(ldisk.ldesc[i]))+"<BR>";
          descfull+=(ldisk.ldesc[i]);
          descfull+=" ";
     }
     tvbLibDetail=descfull;
     tvbLibDetailRaw=descfull;
     tvbLibDetailJS=jsEncode(descfull.c_str());
     tvbLibDetailLine=descfullbr;
     tvbLibHidden=((flib->flags&FLGHID) != 0 ? g_pszFlagon : g_pszFlagoff);
     tvbLibHiddenChk=((flib->flags&FLGHID) != 0 ? "CHECKED" : "");
     tvbLibHiddenNum=((flib->flags&FLGHID) != 0 ? 1 : 0);
     tvbLibKeyAdmin=flib->libop;
     tvbLibKeyAutoApprove=flib->autoap;
     tvbLibKeyDownload=flib->dlkey;
     tvbLibKeyOverwrite=flib->overw;
     tvbLibKeyUpload=flib->ulkey;
     tvbLibKeyView=flib->keyreq;
     tvbLibMaxBytes=flib->maxbyt;
     tvbLibMaxBytesAbbr=skpwht(filsize(flib->maxbyt,1024));
     formatCommas(&tvbLibMaxBytesC,flib->maxbyt);
     tvbLibMaxFileBytes=flib->maxbup;
     tvbLibMaxFileBytesAbbr=skpwht(filsize(flib->maxbup,1024));
     formatCommas(&tvbLibMaxFileBytesC,flib->maxbup);
     tvbLibMaxFiles=flib->maxfil;
     formatCommas(&tvbLibMaxFilesC,flib->maxfil);
     tvbLibName=flib->libname;
     tvbLibNameUrl=flib->libname;
     tvbLibNoChargeDownload=((flib->flags&FLGFDL) != 0 ? g_pszFlagon : g_pszFlagoff);
     tvbLibNoChargeDownloadChk=((flib->flags&FLGFDL) != 0 ? "CHECKED" : "");
     tvbLibNoChargeDownloadNum=((flib->flags&FLGFDL) != 0 ? 1 : 0);
     tvbLibNoChargeUpload=((flib->flags&FLGFUL) != 0 ? g_pszFlagon : g_pszFlagoff);
     tvbLibNoChargeUploadChk=((flib->flags&FLGFUL) != 0 ? "CHECKED" : "");
     tvbLibNoChargeUploadNum=((flib->flags&FLGFUL) != 0 ? 1 : 0);
     tvbLibNumFiles=flib->numfiles;
     formatCommas(&tvbLibNumFilesC,flib->numfiles);
     tvbLibNumFilesJoined=flib->totfiles;
     formatCommas(&tvbLibNumFilesJoinedC,flib->totfiles);
     tvbLibNumJoined=flib->libs;
     tvbLibNumUnapproved=flib->appwait;
     formatCommas(&tvbLibNumUnapprovedC,flib->appwait);
     tvbLibOSOnly=((flib->flags&FLGDOS) != 0 ? g_pszFlagon : g_pszFlagoff);
     tvbLibOSOnlyChk=((flib->flags&FLGDOS) != 0 ? "CHECKED" : "");
     tvbLibOSOnlyNum=((flib->flags&FLGDOS) != 0 ? 1 : 0);

     SHORT numParents=0;
     bool hasParent=false;
     for (INT i=0 ; i < FILPARENT ; i++) {
          if (flib->cat[i][0] != '\0') {
               // found a parent
               if (hasParent) {
                    tvbLibParentList+=g_pszParsep;
               }
               *(tvbLibParent[i])=flib->cat[i];
               tvbLibParentList+=flib->cat[i];
               ++numParents;
               hasParent=true;
          }
     }
     tvbLibParentCount=numParents;

     tvbLibPath=flib->path;
     tvbLibReadOnly=((flib->flags&FLGRDO) != 0 ? g_pszFlagon : g_pszFlagoff);
     tvbLibReadOnlyChk=((flib->flags&FLGRDO) != 0 ? "CHECKED" : "");
     tvbLibReadOnlyNum=((flib->flags&FLGRDO) != 0 ? 1 : 0);
     tvbLibRoyalty=flib->royal;
     tvbLibTotalBytes=flib->totbytes;
     tvbLibTotalBytesAbbr=skpwht(filsize(flib->totbytes,1024));

     formatCommas(&tvbLibTotalBytesC,flib->totbytes);
     tvbLibUploadsDay=flib->newfiles[0];
     formatCommas(&tvbLibUploadsDayC,flib->newfiles[0]);
     INT numthisweek=0;
     for (INT i=0; i < ULDAYS; i++) {
          numthisweek+=flib->newfiles[i];
     }
     tvbLibUploadsWeek=numthisweek;
     formatCommas(&tvbLibUploadsWeekC,numthisweek);
}

VOID
setCurLibVars(                     // set current lib text vars
const struct fllib* flib,          // ptr to lib
acthUserID* uid)                   // User doing request
{
     CHAR fmtbuf[50];              // this should be large enough

     if (!validateLib(flib,uid)) {
          flib=libfind(deflname);
     }
     if (flib == NULL) {
          return;
     }
     USHORT iday=flib->day;
     USHORT itime=flib->time;

     tvbCurLibAccessAdmin=(LONG)ahIsFlop(uid,flib);
     tvbCurLibAccessAutoApprove=(LONG)ahHasLibKey(uid,flib,flib->autoap);
     tvbCurLibAccessDownload=(LONG)ahHasLibKey(uid,flib,flib->dlkey);
     tvbCurLibAccessOverwrite=(LONG)ahHasLibKey(uid,flib,flib->overw);
     tvbCurLibAccessUpload=(LONG)ahHasLibKey(uid,flib,flib->ulkey);
     tvbCurLibAccessView=(LONG)ahHasLibKey(uid,flib,flib->keyreq);
     tvbCurLibAdminUser=flib->primary;
     tvbCurLibAdminUserUrl=flib->primary;
     tvbCurLibAuditDownload=((flib->flags&FLGADL) != 0 ? g_pszFlagon : g_pszFlagoff);
     tvbCurLibAuditDownloadChk=((flib->flags&FLGADL) != 0 ? "CHECKED" : "");
     tvbCurLibAuditDownloadNum=((flib->flags&FLGADL) != 0 ? 1 : 0);
     tvbCurLibAuditUpload=((flib->flags&FLGAUL) != 0 ? g_pszFlagon : g_pszFlagoff);
     tvbCurLibAuditUploadChk=((flib->flags&FLGAUL) != 0 ? "CHECKED" : "");
     tvbCurLibAuditUploadNum=((flib->flags&FLGAUL) != 0 ? 1 : 0);
     tvbCurLibOnCD=((flib->flags&FLGCBD) != 0 ? g_pszFlagon : g_pszFlagoff);
     tvbCurLibOnCDChk=((flib->flags&FLGCBD) != 0 ? "CHECKED" : "");
     tvbCurLibOnCDNum=((flib->flags&FLGCBD) != 0 ? 1 : 0);
     tvbCurLibDownloadFileCharge=flib->dlchge;
     tvbCurLibDownloadFileKbyte=flib->kdlchge;
     tvbCurLibClusterSize=flib->cluster;

     tvbCurLibCreateDateD=ddday(iday);
     sprintf(fmtbuf,"%.2d",ddday(iday));
     tvbCurLibCreateDateD0=fmtbuf;
     sprintf(fmtbuf,"%d %s %d",ddday(iday)
                              ,strMonths[ddmon(iday)-1]
                              ,ddyear(iday));
     tvbCurLibCreateDateEurL=fmtbuf;
     tvbCurLibCreateDateEurS=ncedat(iday);
     tvbCurLibCreateDateML=strMonths[ddmon(iday)-1];
     tvbCurLibCreateDateMN=ddmon(iday);
     sprintf(fmtbuf,"%.2d",ddmon(iday));
     tvbCurLibCreateDateMN0=fmtbuf;
     stlcpy(fmtbuf,strMonths[ddmon(iday)-1],4);
     tvbCurLibCreateDateMS=fmtbuf;
     tvbCurLibCreateDateUsaL=prndat(PRND_MMMDYY,iday,'/');
     tvbCurLibCreateDateUsaS=ncdate(iday);
     tvbCurLibCreateDateWL=strDays[DOFWEEK(iday)];
     tvbCurLibCreateDateWS=shortDays[DOFWEEK(iday)];
     string year=stringFormat(ddyear(iday));
     tvbCurLibCreateDateYL=year;
     tvbCurLibCreateDateYS=year.c_str()+2;
     tvbCurLibCreateTime12L=prntim(PRNT_HMS_PM,itime);
     tvbCurLibCreateTime12S=prntim(PRNT_HM_PM,itime);
     tvbCurLibCreateTime24L=prntim(PRNT_HMS,itime);
     tvbCurLibCreateTime24S=prntim(PRNT_HM,itime);
     tvbCurLibCreateTimeAL=formatMeridiem(itime,FMT_L);
     tvbCurLibCreateTimeALC=formatMeridiem(itime,FMT_LC);
     tvbCurLibCreateTimeALP=formatMeridiem(itime,FMT_LP);
     tvbCurLibCreateTimeALPC=formatMeridiem(itime,FMT_LPC); //
     tvbCurLibCreateTimeAS=formatMeridiem(itime,FMT_S);
     tvbCurLibCreateTimeASC=formatMeridiem(itime,FMT_SC);

     INT hour=dthour(itime);
     tvbCurLibCreateTimeH12=hour%12;
     sprintf(fmtbuf,"%.2d",hour%12);
     tvbCurLibCreateTimeH120=fmtbuf;
     tvbCurLibCreateTimeH24=hour;
     sprintf(fmtbuf,"%.2d",hour);
     tvbCurLibCreateTimeH240=fmtbuf;

     INT min=dtmin(itime);
     tvbCurLibCreateTimeM=min;
     sprintf(fmtbuf,"%.2d",min);
     tvbCurLibCreateTimeM0=fmtbuf;

     INT sec=dtsec(itime);
     tvbCurLibCreateTimeS=sec;
     sprintf(fmtbuf,"%.2d",sec);
     tvbCurLibCreateTimeS0=fmtbuf;

     tvbCurLibDescription=flib->libdesc;
     struct libdisk ldisk;
     stlcpy(ldisk.lib.libname,flib->libname,FLNAMESZ);
     loadldsc(&ldisk);
     string descfull("");
     string descfullbr("");
     for (INT i=0; i < NDESCLN; i++) {
          if (strlen(ldisk.ldesc[i]) == 0) {
               break;
          }
          descfullbr+=htmlEncode(string(ldisk.ldesc[i]))+"<BR>";
          descfull+=(ldisk.ldesc[i]);
          descfull+=" ";
     }
     tvbCurLibDetail=descfull;
     tvbCurLibDetailRaw=descfull;
     tvbCurLibDetailJS=jsEncode(descfull.c_str());
     tvbCurLibDetailLine=descfullbr;
     tvbCurLibHidden=((flib->flags&FLGHID) != 0 ? g_pszFlagon : g_pszFlagoff);
     tvbCurLibHiddenChk=((flib->flags&FLGHID) != 0 ? "CHECKED" : "");
     tvbCurLibHiddenNum=((flib->flags&FLGHID) != 0 ? 1 : 0);
     tvbCurLibKeyAdmin=flib->libop;
     tvbCurLibKeyAutoApprove=flib->autoap;
     tvbCurLibKeyDownload=flib->dlkey;
     tvbCurLibKeyOverwrite=flib->overw;
     tvbCurLibKeyUpload=flib->ulkey;
     tvbCurLibKeyView=flib->keyreq;
     tvbCurLibMaxBytes=flib->maxbyt;
     tvbCurLibMaxBytesAbbr=skpwht(filsize(flib->maxbyt,1024));
     formatCommas(&tvbCurLibMaxBytesC,flib->maxbyt);
     tvbCurLibMaxFileBytes=flib->maxbup;
     tvbCurLibMaxFileBytesAbbr=skpwht(filsize(flib->maxbup,1024));
     formatCommas(&tvbCurLibMaxFileBytesC,flib->maxbup);
     tvbCurLibMaxFiles=flib->maxfil;
     formatCommas(&tvbCurLibMaxFilesC,flib->maxfil);
     tvbCurLibName=flib->libname;
     tvbCurLibNameUrl=flib->libname;
     tvbCurLibNoChargeDownload=((flib->flags&FLGFDL) != 0 ? g_pszFlagon : g_pszFlagoff);
     tvbCurLibNoChargeDownloadChk=((flib->flags&FLGFDL) != 0 ? "CHECKED" : "");
     tvbCurLibNoChargeDownloadNum=((flib->flags&FLGFDL) != 0 ? 1 : 0);
     tvbCurLibNoChargeUpload=((flib->flags&FLGFUL) != 0 ? g_pszFlagon : g_pszFlagoff);
     tvbCurLibNoChargeUploadChk=((flib->flags&FLGFUL) != 0 ? "CHECKED" : "");
     tvbCurLibNoChargeUploadNum=((flib->flags&FLGFUL) != 0 ? 1 : 0);
     tvbCurLibNumFiles=flib->numfiles;
     formatCommas(&tvbCurLibNumFilesC,flib->numfiles);
     tvbCurLibNumFilesJoined=flib->totfiles;
     formatCommas(&tvbCurLibNumFilesJoinedC,flib->totfiles);
     tvbCurLibNumJoined=flib->libs;
     tvbCurLibNumUnapproved=flib->appwait;
     formatCommas(&tvbCurLibNumUnapprovedC,flib->appwait);
     tvbCurLibOSOnly=((flib->flags&FLGDOS) != 0 ? g_pszFlagon : g_pszFlagoff);
     tvbCurLibOSOnlyChk=((flib->flags&FLGDOS) != 0 ? "CHECKED" : "");
     tvbCurLibOSOnlyNum=((flib->flags&FLGDOS) != 0 ? 1 : 0);

     SHORT numParents=0;
     bool hasParent=false;
     for (INT i=0 ; i < FILPARENT ; i++) {
          if (flib->cat[i][0] != '\0') {
               // found a parent
               if (hasParent) {
                    tvbCurLibParentList+=g_pszParsep;
               }
               *(tvbCurLibParent[i])=flib->cat[i];
               tvbCurLibParentList+=flib->cat[i];
               ++numParents;
               hasParent=true;
          }
     }
     tvbCurLibParentCount=numParents;

     tvbCurLibPath=flib->path;
     tvbCurLibReadOnly=((flib->flags&FLGRDO) != 0 ? g_pszFlagon : g_pszFlagoff);
     tvbCurLibReadOnlyChk=((flib->flags&FLGRDO) != 0 ? "CHECKED" : "");
     tvbCurLibReadOnlyNum=((flib->flags&FLGRDO) != 0 ? 1 : 0);
     tvbCurLibRoyalty=flib->royal;
     tvbCurLibTotalBytes=flib->totbytes;
     tvbCurLibTotalBytesAbbr=skpwht(filsize(flib->totbytes,1024));

     formatCommas(&tvbCurLibTotalBytesC,flib->totbytes);
     tvbCurLibUploadsDay=flib->newfiles[0];
     formatCommas(&tvbCurLibUploadsDayC,flib->newfiles[0]);
     INT numthisweek=0;
     for (INT i=0; i < 7; i++) {
          numthisweek+=flib->newfiles[i];
     }
     tvbCurLibUploadsWeek=numthisweek;
     formatCommas(&tvbCurLibUploadsWeekC,numthisweek);
}


bool
isArchive(                         // is specified file an archive
const CHAR* fname)                 // file name to check
{
     ASSERT(fname != NULL);
     CHAR fileExtension[GCMAXEXT+1];
     fileparts(GCPART_EXTN,fname,fileExtension,GCMAXEXT+1);
     return(viewmode(fileExtension) == CMPVIEW);
}


VOID
setStampDateVars(                  // set file stamp text vars
USHORT iday,                       // DOS day
USHORT itime)                      // DOS time
{
     CHAR fmtbuf[50];              // should be big enough

     tvbFileStampDateD=ddday(iday);
     sprintf(fmtbuf,"%.2d",ddday(iday));
     tvbFileStampDateD0=fmtbuf;
     sprintf(fmtbuf,"%d %s %d",ddday(iday)
                              ,strMonths[ddmon(iday)-1]
                              ,ddyear(iday));
     tvbFileStampDateEurL=fmtbuf;
     tvbFileStampDateEurS=ncedat(iday);
     tvbFileStampDateML=strMonths[ddmon(iday)-1];
     tvbFileStampDateMN=ddmon(iday);
     sprintf(fmtbuf,"%.2d",ddmon(iday));
     tvbFileStampDateMN0=fmtbuf;
     stlcpy(fmtbuf,strMonths[ddmon(iday)-1],4);
     tvbFileStampDateMS=fmtbuf;
     tvbFileStampDateUsaL=prndat(PRND_MMMDYY,iday,'/');
     tvbFileStampDateUsaS=ncdate(iday);
     tvbFileStampDateWL=strDays[DOFWEEK(iday)];
     tvbFileStampDateWS=shortDays[DOFWEEK(iday)];
     string year=stringFormat(ddyear(iday));
     tvbFileStampDateYL=year;
     tvbFileStampDateYS=year.c_str()+2;
     tvbFileStampTime12L=prntim(PRNT_HMS_PM,itime);
     tvbFileStampTime12S=prntim(PRNT_HM_PM,itime);
     tvbFileStampTime24L=prntim(PRNT_HMS,itime);
     tvbFileStampTime24S=prntim(PRNT_HM,itime);
     tvbFileStampTimeAL=formatMeridiem(itime,FMT_L);
     tvbFileStampTimeALC=formatMeridiem(itime,FMT_LC);
     tvbFileStampTimeALP=formatMeridiem(itime,FMT_LP);
     tvbFileStampTimeALPC=formatMeridiem(itime,FMT_LPC);
     tvbFileStampTimeAS=formatMeridiem(itime,FMT_S);
     tvbFileStampTimeASC=formatMeridiem(itime,FMT_SC);

     INT hour=dthour(itime);
     tvbFileStampTimeH12=hour%12;
     sprintf(fmtbuf,"%.2d",hour%12);
     tvbFileStampTimeH120=fmtbuf;
     tvbFileStampTimeH24=hour;
     sprintf(fmtbuf,"%.2d",hour);
     tvbFileStampTimeH240=fmtbuf;

     INT min=dtmin(itime);
     tvbFileStampTimeM=min;
     sprintf(fmtbuf,"%.2d",min);
     tvbFileStampTimeM0=fmtbuf;

     INT sec=dtsec(itime);
     tvbFileStampTimeS=sec;
     sprintf(fmtbuf,"%.2d",sec);
     tvbFileStampTimeS0=fmtbuf;
}

VOID
setFileVars(                       // set file variables
const struct flfile* ffile,        // ptr to file info
acthUserID* usr)                   // User-ID making request
{
     CHAR fmtbuf[50];              // should be big enough
     bool approved=false;
     if (ffile == NULL) {
          return;
     }

     USHORT iday=dcdate(srt2datl(ffile->udate));
     USHORT itime=ffile->utime;
     if (!sameas(ffile->udate,NOTAPPED)) {
          approved=true;
          tvbFileAddDateD=ddday(iday);
          sprintf(fmtbuf,"%.2d",ddday(iday));
          tvbFileAddDateD0=fmtbuf;
          sprintf(fmtbuf,"%d %s %d",ddday(iday)
                                   ,strMonths[ddmon(iday)-1]
                                   ,ddyear(iday));
          tvbFileAddDateEurL=fmtbuf;
          tvbFileAddDateEurS=ncedat(iday);
          tvbFileAddDateML=strMonths[ddmon(iday)-1];
          tvbFileAddDateMN=ddmon(iday);
          sprintf(fmtbuf,"%.2d",ddmon(iday));
          tvbFileAddDateMN0=fmtbuf;
          stlcpy(fmtbuf,strMonths[ddmon(iday)-1],4);
          tvbFileAddDateMS=fmtbuf;
          tvbFileAddDateUsaL=prndat(PRND_MMMDYY,iday,'/');
          tvbFileAddDateUsaS=ncdate(iday);
          tvbFileAddDateWL=strDays[DOFWEEK(iday)];
          tvbFileAddDateWS=shortDays[DOFWEEK(iday)];
          string year=stringFormat(ddyear(iday));
          tvbFileAddDateYL=year;
          tvbFileAddDateYS=year.c_str()+2;
          tvbFileAddTime12L=prntim(PRNT_HMS_PM,itime);
          tvbFileAddTime12S=prntim(PRNT_HM_PM,itime);
          tvbFileAddTime24L=prntim(PRNT_HMS,itime);
          tvbFileAddTime24S=prntim(PRNT_HM,itime);
          tvbFileAddTimeAL=formatMeridiem(itime,FMT_L);
          tvbFileAddTimeALC=formatMeridiem(itime,FMT_LC);
          tvbFileAddTimeALP=formatMeridiem(itime,FMT_LP);
          tvbFileAddTimeALPC=formatMeridiem(itime,FMT_LPC); //
          tvbFileAddTimeAS=formatMeridiem(itime,FMT_S);
          tvbFileAddTimeASC=formatMeridiem(itime,FMT_SC);

          INT hour=dthour(itime);
          tvbFileAddTimeH12=hour%12;
          sprintf(fmtbuf,"%.2d",hour%12);
          tvbFileAddTimeH120=fmtbuf;
          tvbFileAddTimeH24=hour;
          sprintf(fmtbuf,"%.2d",hour);
          tvbFileAddTimeH240=fmtbuf;

          INT min=dtmin(itime);
          tvbFileAddTimeM=min;
          sprintf(fmtbuf,"%.2d",min);
          tvbFileAddTimeM0=fmtbuf;

          INT sec=dtsec(itime);
          tvbFileAddTimeS=sec;
          sprintf(fmtbuf,"%.2d",sec);
          tvbFileAddTimeS0=fmtbuf;
     }
     iday=dcdate(srt2datl(ffile->fdate));
     itime=ffile->tim;
     setStampDateVars(iday,itime);
     tvbFileApproved=approved ? g_pszAppdsp : g_pszUnapdsp;
     tvbFileApprovedChk=approved ? "CHECKED" : "";
     tvbFileApprovedNum=approved ? 1 : 0;
     tvbFileArchive=isArchive(ffile->filname) ? 1 : 0;
     tvbFileDownloads=atoi(ffile->numdls);
     formatCommas(&tvbFileDownloadsC,atoi(ffile->numdls));
     tvbFileLib=ffile->libname;
     tvbFileLibUrl=ffile->libname;
     struct fllib* flib=libfind(ffile->libname);
     ASSERT(flib != NULL);
     tvbFileDownloadCharge=dnlPrice(ffile->siz,flib,usr);
     tvbFileName=ffile->filname;
     tvbFileNameUrl=ffile->filname;
     tvbFileSize=ffile->siz;
     tvbFileSizeAbbr=skpwht(filsize(ffile->siz,1024));
     formatCommas(&tvbFileSizeC,ffile->siz);
     tvbFileUnapproved=!approved ? g_pszUnapdsp : "";
     tvbFileUploadedBy=ffile->ulby;
     tvbFileUploadedByUrl=ffile->ulby;
}



static VOID
setTvbArray(                            // set tvbs to set or cleared state
basicTvb** tvbPtr,                      //   pointer to tvbs
CHAR** repStrings,                      //   strings to set with
INT numElems,                           //   number of tvbs/strings
bool bClear)                            //   clear them?
{
     ASSERT(tvbPtr != NULL);
     if (tvbPtr == NULL || *tvbPtr == NULL) {
          return;
     }
     if (bClear || repStrings == NULL) {
          for (INT i=0 ; i < numElems ; i++) {
               *(tvbPtr[i])="";
          }
          return;
     }
     for (INT i=0 ; i < numElems ; i++) {
          *(tvbPtr[i])=repStrings[i];
     }
}

static VOID
registerRange(                          // register a range of Tvbs
basicTvb ** tvbPtr,                     //   pointer to tvbs
enum tvbtype ttype,                     //   tvb type to create
CHAR const * pszBody,                   //   body to set equal to
INT num,                                //   set from 0-num
INT startnum,                           //   start numbering at this value
CHAR const * anchor)                    //   anchor to use for linking
{
     ASSERT(tvbPtr != NULL);
     ASSERT(pszBody != NULL);
     ASSERT(*pszBody != '\0');

     for (INT i=0 ; i < num ; i++) {
          ostrstream ost;
          ost << pszBody << i+startnum << ends;
          switch (ttype) {
          case TVB_BASIC:
               tvbPtr[i]=new basicTvb(ost.str());
               break;
          case TVB_HTML:
               tvbPtr[i]=new htmlEncodedTvb(ost.str());
               break;
          case TVB_ENC:
               tvbPtr[i]=new urlEncodedTvb(ost.str());
               break;
          case TVB_LINKED:
               if (anchor != NULL ) {
                    tvbPtr[i]=new linkedHtmlEncodedTvb(ost.str(),anchor);
               }
               else {
                    tvbPtr[i]=new htmlEncodedTvb(ost.str());
               }
               break;
          default:
               ASSERTM(FALSE,"Bad TVB type");
          }
          ost.rdbuf()->freeze(0);
     }
}

const CHAR*                        // returned String
formatMeridiem(                    // format meridiem as desired
unsigned time,                     // time to work with
SHORT type)                        // type of formatting
{
     static CHAR merBuf[sizeof("am")];
     setmem(merBuf,sizeof(merBuf),0);
     static string retstr("");

     const CHAR *ptr=prntim(PRNT_HM_PM,time);
     if (dthour(time)/12 == 0) {
          stlcpy(merBuf,"am",sizeof("am"));
     }
     else {
          stlcpy(merBuf,"pm",sizeof("pm"));
     }
     switch(type) {
     case FMT_LC:
          strupr(merBuf);
          // fall through intentional
     case FMT_L:
          return(merBuf);
     case FMT_SC:
          strupr(merBuf);
          // fall through intentional
     case FMT_S:
          merBuf[1]='\0';
          return(merBuf);
     case FMT_LPC:
          strupr(merBuf);
          // fall through intentional
     case FMT_LP:
          retstr=spr("%c.%c.",merBuf[0],merBuf[1]);
          return(retstr.c_str());
     default:
          ASSERT(false);
     }
     return("");
}

VOID
setErrorVars(                      // set error variables
INT err,                           // error code
const CHAR* errstg)                // error string to set
{
     tvbFlErrorCode=err;
     tvbFlErrorMessage=errstg;
}

VOID
setOSFileVars(                     // set os-lib file text vars
const struct ffblk* ffil,          // ptr to file
const struct fllib* flib,          // ptr to lib
acthUserID* usr)                   // User-ID doing request
{
     clearFileVars();
     tvbFileArchive=isArchive(ffil->ff_name) ? "1" : "0";
     tvbFileLib=flib->libname;
     tvbFileLibUrl=flib->libname;
     CHAR filename[GCMAXFNM];
     fileparts(GCPART_FNAM,ffil->ff_name,filename,GCMAXFNM);
     tvbFileName=filename;
     tvbFileNameUrl=filename;
     tvbFileSize=ffil->ff_fsize;
     tvbFileSizeAbbr=skpwht(filsize(ffil->ff_fsize,1024));
     formatCommas(&tvbFileSizeC,ffil->ff_fsize);
     setStampDateVars(ffil->ff_fdate,ffil->ff_ftime);
     tvbFileDownloadCharge=dnlPrice(ffil->ff_fsize,flib,usr);
}

VOID
setArchiveFileDetailVars(            // set archive file item detail vars
CHAR** ppInfo)                       // info on file in archive
{
     CHAR* length=ppInfo[0];
     CHAR* method=ppInfo[1];
     CHAR* size=ppInfo[2];
     CHAR* ratio=ppInfo[3];
     CHAR* dat=ppInfo[4];
     CHAR* crc=ppInfo[5];
     CHAR* fname=ppInfo[6];

     CHAR fmtbuf[50];                // should be big enough

     USHORT iday=v2ddat(atof(dat));
     USHORT itime=v2dtim(atof(dat));

     tvbArcFileDateD=ddday(iday);
     sprintf(fmtbuf,"%.2d",ddday(iday));
     tvbArcFileDateD0=fmtbuf;
     sprintf(fmtbuf,"%d %s %d",ddday(iday)
                              ,strMonths[ddmon(iday)-1]
                              ,ddyear(iday));
     tvbArcFileDateEurL=fmtbuf;
     tvbArcFileDateEurS=ncedat(iday);
     tvbArcFileDateML=strMonths[ddmon(iday)-1];
     tvbArcFileDateMN=ddmon(iday);
     sprintf(fmtbuf,"%.2d",ddmon(iday));
     tvbArcFileDateMN0=fmtbuf;
     stlcpy(fmtbuf,strMonths[ddmon(iday)-1],4);
     tvbArcFileDateMS=fmtbuf;
     tvbArcFileDateUsaL=prndat(PRND_MMMDYY,iday,'/');
     tvbArcFileDateUsaS=ncdate(iday);
     tvbArcFileDateWL=strDays[DOFWEEK(iday)];
     tvbArcFileDateWS=shortDays[DOFWEEK(iday)];
     string year=stringFormat(ddyear(iday));
     tvbArcFileDateYL=year;
     tvbArcFileDateYS=year.c_str()+2;
     tvbArcFileTime12L=prntim(PRNT_HMS_PM,itime);
     tvbArcFileTime12S=prntim(PRNT_HM_PM,itime);
     tvbArcFileTime24L=prntim(PRNT_HMS,itime);
     tvbArcFileTime24S=prntim(PRNT_HM,itime);
     tvbArcFileTimeAL=formatMeridiem(itime,FMT_L);
     tvbArcFileTimeALC=formatMeridiem(itime,FMT_LC);
     tvbArcFileTimeALP=formatMeridiem(itime,FMT_LP);
     tvbArcFileTimeALPC=formatMeridiem(itime,FMT_LPC); //
     tvbArcFileTimeAS=formatMeridiem(itime,FMT_S);
     tvbArcFileTimeASC=formatMeridiem(itime,FMT_SC);

     INT hour=dthour(itime);
     tvbArcFileTimeH12=hour%12;
     sprintf(fmtbuf,"%.2d",hour%12);
     tvbArcFileTimeH120=fmtbuf;
     tvbArcFileTimeH24=hour;
     sprintf(fmtbuf,"%.2d",hour);
     tvbArcFileTimeH240=fmtbuf;

     INT min=dtmin(itime);
     tvbArcFileTimeM=min;
     sprintf(fmtbuf,"%.2d",min);
     tvbArcFileTimeM0=fmtbuf;

     INT sec=dtsec(itime);
     tvbArcFileTimeS=sec;
     sprintf(fmtbuf,"%.2d",sec);
     tvbArcFileTimeS0=fmtbuf;

     tvbArcFileCrcHex=strlwr(crc);
     tvbArcFileCrcHexLC=strupr(crc);
     tvbArcFileCrcDec=(UINT)htoi(crc);

     tvbArcFileMethod=method;
     tvbArcFileName=fname;

     tvbArcFilePercentOriginal=ratio;
     tvbArcFilePercentReduced=100-atoi(ratio);

     tvbArcFileSizeCompressed=size;
     tvbArcFileSizeCompressedAbbr=skpwht(filsize(atol(size),1024));
     formatCommas(&tvbArcFileSizeCompressedC,size);

     tvbArcFileSizeUnCompressed=length;
     tvbArcFileSizeUnCompressedAbbr=skpwht(filsize(atol(length),1024));
     formatCommas(&tvbArcFileSizeUnCompressedC,length);
}

bool
isPChar(                           // is paragraph continuation char?
CHAR ch)                           // char to check
{
     if (ch == '\0' || ch == ' ') {
          return(false);
     }
     return(strchr(g_pszParacc,ch) != NULL);
}



VOID
setPrefVars(                       // set preference variables
LISTORDER libOrder,                // prefered lib list order
LISTORDER browseOrder,             // prefered file browse order
SEARCHTYPE browseType)             // prefered browse type
{
     tvbPrefLibListOrder=libOrder == ORDER_DESC ? "descending" : "ascending";
     tvbPrefBrowseOrder=browseOrder == ORDER_DESC ? "descending" : "ascending";
     if (browseType == STYPE_DATE) {
          tvbPrefBrowseType="date";
     }
     else if (browseType == STYPE_POPULARITY) {
          tvbPrefBrowseType="popularity";
     }
     else if (browseType == STYPE_NAME) {
          tvbPrefBrowseType="name";
     }
     else {
          tvbPrefBrowseType="";
          ASSERT(FALSE);
     }
}

VOID
setTemplateMask(                   // set template mask variable
const string& templ,               // the template name used
const dnfHandler* dnf)             // ptr to dnf for this request
{
     if (templ.length() == 0) {
          if (dnf != NULL) {
               tvbFlTemplateMask=dnf->getMap().getFile();
          }
          else {
               // else the dnf wasn't created yet, so we don't know!
               tvbFlTemplateMask="";
          }
     }
     else {
          tvbFlTemplateMask=templ;
     }
}

bool
validateLib(                       // make sure lib exists and user has access
const struct fllib* pLib,          // ptr to lib
acthUserID*  usr)                  // User requesting access.
{
     if (pLib == NULL) {
          return(false);
     }
     if (usr == NULL && strlen(pLib->keyreq) > 0) {
          return(false);
     }
     if (usr != NULL
       && !ahHasLibKey(usr,pLib,pLib->keyreq)) {
          return(false);
     }
     return(true);
}

VOID
buildDetailLine(                   // build detail with <br>'s
const CHAR* desc,                  // original description
string* dstr,                      // ptr to string to receive one line desc
string* str)                       // ptr to string to receive file detail w/ <br>'s
{
     CHAR descbuf[DESCSIZ];

     *str="";
     *dstr="";
     stlcpy(descbuf,desc,DESCSIZ);
     if (descbuf[0] == '\0' || descbuf[0] == '\r') {
          *dstr=g_pszNodesc;
          return;
     }
     CHAR* line[NDESCLN];
     buildLines(descbuf,line);
     ASSERT(line[0] != NULL);
     *dstr=unpad(line[0]);
     for (INT i=0 ; i < NDESCLN ; i++) {
          if (line[i] != NULL) {
               *str+=htmlEncode(string(line[i]));
               if (i != NDESCLN-1) {
                    *str+="<BR>";
               }
          }
     }
}

string
jsEncode(                          // encode for javascript
const CHAR* str)                   // raw formatted description
{
     string result("");

     while (*str != '\0') {
          if (*str == '\r' || *str =='\n') {
               result+="\\n";
          }
          else {
               result+=*str;
          }
          if (*str == '\r' && *(str+1) == '\n') {
               ++str;
          }
          ++str;
     }
     return(result);
}


VOID
buildDetailRaw(                    // build raw detail
const CHAR* desc,                  // original description
string* str)                       // ptr to string to receive raw detail
{
     CHAR descbuf[DESCSIZ];
     *str="";
     stlcpy(descbuf,desc,DESCSIZ);
     if (descbuf[0] == '\0') {
          return;
     }
     CHAR* line[NDESCLN];
     buildLines(descbuf,line);
     for (INT i=0 ; i < NDESCLN ; i++) {
          if (line[i] != NULL) {
               *str+=line[i];
               if (i != NDESCLN-1) {
                    *str+="\r\n";
               }
          }
     }
}

VOID
buildDetail(                       // build detail
const CHAR* desc,                  // original description
string* str)                       // ptr to string to hold detail
{
     CHAR descbuf[DESCSIZ];
     *str="";
     stlcpy(descbuf,desc,DESCSIZ);
     if (descbuf[0] == '\0') {
          return;
     }
     CHAR* line[NDESCLN];
     string para[NDESCLN];
     buildLines(descbuf,line);

     INT nump=buildParagraphs(line,para);
     for (INT i=0 ; i < nump ; i++) {
          *str+=htmlEncode(para[i]);
          if (i+1 < nump) {
               if (sameas(para[i+1].c_str(),"")) {
                    ++i;
                    *str+="<P>";
               }
               else {
                    *str+="<BR>";
               }
          }
     }
}

INT
buildParagraphs(                   // build paragraphs in descriptions
CHAR** line,                       // array of ptrs to lines
string* para)                      // string to hold the built paragraph
{
     INT cnt=1;
     INT l=1;
     INT p=(g_bJoin1st ? 0 : 1);

     para[0]=line[0];
     string* currentPara=&para[p];
     bool didone=false;
     while (l < NDESCLN && line[l] != NULL) {
          CHAR* currentLine=line[l];
          INT curLineLength=strlen(firstwd(currentLine));
          if (!isPChar(currentLine[0])
           || (l > 0 && strlen(line[l-1])+curLineLength+1 < g_iWraplen)) {
               if (didone) {
                    cnt++;
                    currentPara++;
               }
          }
          else {
               // join that line to current paragraph;
               *currentPara+=" ";
          }
          *currentPara+=currentLine;
          l++;
          didone=true;
     }
     return(cnt);
}

VOID
buildLines(                        // build detail lines
CHAR* descbuf,                     // original description
CHAR** line)                       // array of ptrs to set to beginnings of lines
{
     INT lno=0;
     for (INT i=0 ; i < NDESCLN ; i++) {
          line[i]=NULL;
     }
     line[lno++]=descbuf;
     while (lno < NDESCLN) {
          line[lno]=strchr(line[lno-1],'\r');
          if (line[lno] != NULL && line[lno][1] != '\0') {
               line[lno][0]='\0';
               line[lno]+=1;
               unpad(line[lno]);
               lno++;
          }
          else {
               break;
          }
     }
}

VOID
setFileDetailVars(                 // set file detail vars
const string& strDesc,             // one line description
const string& strDetail,           // detail
const string& strDetailLine,       // detail, with <br>'s
const string& strDetailRaw,        // detail, raw
const string& strDetailJS)         // detail, js
{
     tvbFileDescription=strDesc;
     tvbFileDescriptionRaw=strDesc;
     tvbFileDetail=strDetail;
     tvbFileDetailLine=strDetailLine;
     tvbFileDetailRaw=strDetailRaw;
     tvbFileDetailJS=strDetailJS;
}

VOID
buildAllDetail(                    // build detail variables
CHAR* desc,                        // description
string* strDesc,                   // ptr to string to hold description
string* strDetail,                 // ptr to string to hold detail
string* strDetailLine,             // ptr to string to hold detail with <br>'s
string* strDetailRaw,              // ptr to string to hold raw detail
string* strDetailJS)               // ptr to string to hold js detail
{
     desc=stpans(desc);
     buildDetail(desc,strDetail);
     buildDetailLine(desc,strDesc,strDetailLine);
     buildDetailRaw(desc,strDetailRaw);
     *strDetailJS=jsEncode(strDetailRaw->c_str());
}


