/****************************************************************************
 *                                                                         *
 *   FILTDEF.CPP                                                           *
 *                                                                         *
 *   Copyright (c) 1998       Galacticomm, Inc.    All Rights Reserved.    *
 *                                                                         *
 *   Active HTML File Libraries typedefs                                   *
 *                                                                         *
 *                                                - Phil Henning 10/22/98  *
 *                                                                         *
 ***************************************************************************/

#ifndef __FILTDEF_H
#define __FILTDEF_H

#pragma option -w-par
#define _RWSTDLL
#include <cstring.h>
#include <deque>
#include <map>
using namespace std;
#include "mapstore.h"
#include "galfilh.h"

#define PPFIX "galacth/galfilah"   // root directory for html files
#define FRAMECOOKIE "flframe"      // file library frame cookie

typedef enum {                     // library type codes, for listing
     TYPE_OS,                      //   operating system only library
     TYPE_NORMAL,                  //   normal library
     TYPE_ALL                      //   all libraries
} LIBTYPE;

typedef enum {                     // library list types
     LIST_DOWNLOAD,                //   download access only
     LIST_UPLOAD,                  //   upload access only
     LIST_ADMIN,                   //   admin access only
     LIST_ALL                      //   all libs
} LIBACCESS;

typedef enum {                     // list order
     ORDER_DESC,                   //   descending order
     ORDER_ASCEND                  //   ascending order
} LISTORDER;

#define DIR_EQ 1                   // direction - equal
#define DIR_LT 2                   // direction - less then
#define DIR_GT 4                   // direction - greater than
#define DIR_LE (DIR_LT|DIR_EQ)     // direction - less than or equal to
#define DIR_GE (DIR_GT|DIR_EQ)     // direction - greater than or equal to

typedef INT LISTDIR;               // list direction typedef

typedef enum {
     ERR_NOERROR,                  // no error (0)
     ERR_PARAMMISSING,             // parameter missing (1)
     ERR_INVALIDPARAM,             // parameter invalid (2)
     ERR_INVALIDLIB,               // bad lib param (3)
     ERR_INVALIDFILE,              // bad file param (4)
     ERR_NOACCESS,                 // no access (5)
     ERR_NOTARCHIVE,               // archive view on non-archive (6)
     ERR_FILEIO,                   // file read/write error (7)
     ERR_NOCREDITS,                // no credits (8)
     ERR_NOTFROMCD,                // view archive from cd (9)
     ERR_UPENCODE,                 // encoding error - uploads (10)
     ERR_UPNOSUP,                  // browser does not support http upl (11)
     ERR_UPNOSUPIE,                // browser does not support http upl -ie (12)
     ERR_FILEEXISTSINLIB,          // upload - file is in lib already (13)
     ERR_FILEEXISTSGLOBAL,         // upload - file is in another lib (14)
     ERR_FSTREAMDATA,              // upload - error in stream data (15)
     ERR_UPTOOBIG,                 // upload - file too big (16)
     ERR_INUSE,                    // upload - file in use (17)
     ERR_KWDTOOLONG,               // keyword - too long (18)
     ERR_KWDSYNTAX,                // keyword - syntax (19)
     ERR_KWDPARENS,                // keyword - parenthesis mismatch (20)
     ERR_KWDNOWORD,                // keyword - no keyword (21)
	 ERR_NOSPACE,					//  NO SPACE IN THE LIB
     ERR_LASTERR                   // place holder, insert new errors before this
} errorcodes;

#define HIERRNUM (ERR_LASTERR-1)

typedef enum {                     // search type
     STYPE_NAME,                   //  name search
     STYPE_DATE,                   //  date search
     STYPE_POPULARITY,             //  popularity search
     STYPE_KEYWORDS                //  keyword search
} SEARCHTYPE;

typedef enum {                     // name start
     NS_NONE,                      //  not specified
     NS_FIRST,                     //  first name
     NS_LAST                       //  last name
} NAMESTART;

typedef enum {                     // popularity start
     PS_NONE,                      //  not specified
     PS_FIRST,                     //  most popular
     PS_LAST                       //  least popular
} POPSTART;

typedef enum {                     // date start
     DTYPE_NONE,                   //  not specified
     DTYPE_ABS,                    //  absolute date
     DTYPE_FIRST,                  //  first uploaded
     DTYPE_LAST                    //  last uploaded
} DATETYPE;

typedef enum {                     // calculate list context state
     INIT_LOW,                     //  init low
     READ_LOW,                     //  read low
     INIT_HIGH,                    //  init high
     READ_HIGH                     //  read high
} CONTEXTSTATE;

typedef enum {                     // type of list
     LTYPE_FILE,                   // file list
     LTYPE_LIB                     // lib list
} LISTTYPE;

typedef deque<struct fllib> LIBQUE, *pLIBQUE;          // lib list queue
typedef deque<struct flfile> FILQUE, *pFILQUE;         // file list queue
typedef deque<struct ffblk> OSFILQUE, *pOSFILQUE;      // os files queue
typedef mapStore<string> STRSTORE, *pSTRSTORE;         // string storage class
typedef map<STRSTORE,string,less<STRSTORE> > LIBMAP, *pLIBMAP; // libs to include in file lists

extern const CHAR STARTDELIM[];

#endif // __FILTDEF_H
