/***************************************************************************
 *                                                                         *
 *   FILAGENT.H                                                            *
 *                                                                         *
 *   Copyright (c) 1998       Galacticomm, Inc.    All Rights Reserved.    *
 *                                                                         *
 *   Active HTML File Library Agent                                        *
 *   Declaration                                                           *
 *                                                                         *
 *                                                - Phil Henning 10/16/98  *
 *                                                                         *
 ***************************************************************************/

#ifndef __FILAGENT_H
#define __FILAGENT_H

#define AHPREFVER   1              // this is the user-preference version
                                   // update this when updating the structure
                                   // be sure to add code to the load to check
                                   // for incompatabilities on version changes

typedef struct tagFILAHPREF {      // user-preference structure
     CHAR userid[UIDSIZ];          // User-ID
     CHAR modnam[MNMSIZ];          // module name
     SHORT m_prefver;              // preference version
     LISTORDER m_lorder;           // library list order
     LISTORDER m_forder;           // file list order
     SEARCHTYPE m_browse;          // browse type
     bool m_frames;                // frames preference
} FILAHPREF, *pFILAHPREF;

class filAgent : public acthAgent {
public:
     filAgent();                   // constructor
     ~filAgent();                  // destructor

     acthSynthesis*                //   pointer to new synthesis obj
     newSynthesis(                 // create a new registry synthesis
     acthSession* ses);            //   acthSession ptr

     VOID
     LoadPrefs(                    // Load preferences
     const CHAR* uid,              // User-ID, NULL for system default
     pFILAHPREF pPref);            // pointer to struct to recieve prefs

     VOID
     SetDftPrefs(                  // Set default prefs
     pFILAHPREF pPref);            //  ptr to struct to recieve prefs

     VOID
     SavePrefs(                    // Save prefs
     pFILAHPREF pPref);            //  ptr to struct to save

     LISTORDER
     LoadLibOrder(                 // load library list order
     const CHAR* uid);             //   User-ID to get, NULL for sys default

     VOID
     SaveLibOrder(                 // save library list order
     const CHAR* uid,              //   User-ID to save
     LISTORDER neworder);          //   the new list order

     LISTORDER
     LoadFileOrder(                // load file list forder
     const CHAR* uid);             //   User-ID to get, NULL for sys default

     VOID
     SaveFileOrder(                // save file list order
     const CHAR* uid,              //   User-ID to save
     LISTORDER neworder);          //   the new list order

     SEARCHTYPE
     LoadSearchType(               // load search type
     const CHAR* uid);             //   User-ID to get, NULL for sys default

     VOID
     SaveSearchType(               // save search type
     const CHAR* uid,              //   User-ID to save
     SEARCHTYPE newtype);          //   new search type

     bool
     LoadFramePref(                // load frame preference
     const CHAR* uid);             //   User-ID to get, NULL for sys default

     VOID
     SaveFramePref(                // save frame preference
     const CHAR* uid,              //   User-ID to save
     bool bFrames);                //   new frames preference

public:
     bool m_anonlib;               // allow anon listings
     bool m_anondft;               // allow anon dft url
     bool m_frameset;              // use frames by default
     bool m_bReqEncoding;          // require proper encoding for uploads
     CHAR* m_hfilkey;              // key to access HTML libraries
     INT m_maxlst;                 // max number of entries in list
     INT m_dftlst;                 // dft number of entries in list
     INT m_timeslice;              // timeslice for generating resp
     LISTORDER m_deflord;          // default library list order
     LISTORDER m_defford;          // default file list order
     SEARCHTYPE m_defftyp;         // default file browse type
     string m_strRedirFrame;       // default redirect for init resp frame
     string m_strRedirNoFrame;     // default redirect for init resp noframe

private:
     VOID
     initAgent();                  // initialize registry options

     VOID
     finishAgent();                // cleanup agent for shutdown

     VOID
     initMcvOptions();             // initialize MCV file options
};

bool
ahHasLibKey(                       // has lib key?
acthUserID* user,                  // User-ID
const struct fllib *libptr,        // ptr to lib
const CHAR* keyname);              // keyname

bool
ahIsFlop(                          // is user an operator at all?
acthUserID* user,                  // User-ID
const struct fllib *libptr);       // ptr to lib

bool
isChildOf(                         // is lib a child of a lib?
const CHAR* libname,               // lib to check
const struct fllib *libptr);       // alleged parent lib

LISTORDER
LoadDftOrder(                      // load default order
const CHAR* uid);                  // User-ID

VOID
SaveDftOrder(                      // save default order
const CHAR* uid,                   // User-ID
LISTORDER neworder);               // new order

LONG
dnlPrice(                               // price of download, one file + size
LONG siz,                               //   size of file
const struct fllib *libptr,             //   library info
acthUserID* usr);                       //   user id


extern filAgent* theFilAgent;      // the agent
extern HMCVFILE filahmb;           // file library active html msg file
extern CHAR* g_pszAnonul;

#endif // __FILAGENT_H

