/***************************************************************************
 *                                                                         *
 *   WGSFLGCV.C                                                            *
 *                                                                         *
 *   Copyright (c) 1996-1997 Galacticomm, Inc.    All Rights Reserved.    *
 *                                                                         *
 *   Conversion utility for File Libraries Generic Database Records.       *
 *                                                                         *
 *                                           - Bill Hyatt   7/10/96        *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "excphand.h"
#include "majorbbs.h"
#include "dfcapi.h"

#define IDSTG "WGSFLGCV"           /* id stg for API calls                 */

/* following taken from DOS 3.0 / NT version of GALFILH.H */

#define FLNAMESZ    9              /* size of Library names                */
#define DATESZ      8              /* size of date, "srt" format           */

struct fluser {                    /* structure for saved user data        */
     CHAR lib[FLNAMESZ];           /* last Library a user was in           */
     CHAR proto[3];                /* default download transfer protocol   */
     SHORT askme;                  /* ask to logoff after default transfer */
     SHORT mytyp;                  /* user preference: search parameters   */
     SHORT mylib;                  /* user preference: current/all libs    */
     SHORT cdayin;                 /* cofdat() date of last Library access */
     CHAR newdate[DATESZ];         /* date user last did the L list option */
};

struct flusave {                   /* structure for saving user data       */
     CHAR userid[UIDSIZ];          /* User-Id of user data belongs to      */
     CHAR modnam[MNMSIZ];          /* "File Library" module key            */
     struct fluser udata;          /* data to save on above user           */
};
/* end GALFILH.H declarations */

#define DSTDAT ((struct flusave *)dstbb->data) /* cast for dest data       */

_NOSCNS_                           /* keep DFCDISP.C happy                 */

CHAR recbuf[GENSIZ];               /* buffer for generic db records        */

INT
main(INT argc,CHAR *argv[])
{
     INT cvtflg,srcflg=0,dstflg=0,keyno;
     GBOOL fnd,eatSpare;
     ULONG currec;
     LONG srcfsiz;

TRY
     if (dfcCustInitGen(argc,argv,IDSTG) != 0) {
          catastro(dfcLastErr());
     }
#ifdef GCDOS
     eatSpare=TRUE;
#else
     eatSpare=sameas(getUpdType(),"2.0 to NT");
#endif // GCDOS
     if (!dfcOpenFilesGen(GENSIZ,&srcfsiz,GENSIZ)) {
          catastro(dfcLastErr());
     }
     if (!dfcChkDskSpc(srcfsiz)) {
          catastro(dfcLastErr());
     }
     if (dfcSupFlags(&srcflg,&dstflg) != 0) {
          catastro(dfcLastErr());
     }
     if (dfaCountRec() > 0L) {
          keyno=atoi(itemidxd(argv[RECORDIDX],1,","));
          for (fnd=dfaAcqEQ(recbuf,argv[MODULEIDX],keyno),currec=0L ; fnd
                                                       ; fnd=dfaAcqNX(recbuf)) {
               dfcDspRecs(++currec,NODISP);
               memset(dstbb->data,0,sizeof(struct flusave));
               takeInit(recbuf,dfaLastLen(),srcflg,dstflg);
               /* these calls based on struct flusave DOS 2.0 and DOS 3.0/NT */
               cvtflg=takeChar(DSTDAT->userid,UIDSIZ);
               cvtflg&=takeChar(DSTDAT->modnam,MNMSIZ);
               cvtflg&=takeChar(DSTDAT->udata.lib,FLNAMESZ);
               cvtflg&=takeChar(DSTDAT->udata.proto,3);
               cvtflg&=takeShort(&DSTDAT->udata.askme,1);
               cvtflg&=takeShort(&DSTDAT->udata.mytyp,1);
               cvtflg&=takeShort(&DSTDAT->udata.mylib,1);
               cvtflg&=takeShort(&DSTDAT->udata.cdayin,1);
               cvtflg&=takeChar(DSTDAT->udata.newdate,DATESZ);
               if (eatSpare) {
                    cvtflg&=takeChar(NULL,22);
               }
               if (cvtflg&1) {
                    dfaSetBlk(dstbb);
                    dfaInsertV(NULL,sizeof(struct flusave));
               }
               else {
                    catastro("WGSFLGCV: Error getting source data!");
               }
               dfaSetBlk(srcbb);
          }
     }
     dfaClose(srcbb);
     dfaClose(dstbb);
     dfcClrRecs();
     clsvid();
EXCEPT
     return(0);
}
