/***************************************************************************
 *                                                                         *
 *   GALFLCVT.C                                                            *
 *                                                                         *
 *   Copyright (c) 1996-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   File Libraries conversion utility for GALFILL.DAT.                    *
 *                                                                         *
 *                                           - Bill Hyatt   7/3/96         *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "excphand.h"
#include "majorbbs.h"
#include "dfcapi.h"

#define IDSTG "GALFLCVT"           /* id stg for API calls                 */

#define OFLRECSZ    1018
                     /* old fil lib rec siz, from GALFILL.BCR, DOS 2.0 ver */

/* following taken from NT/DOS 3.0 version of GALFILH.H */

#define FLNAMESZ    9              /* size of Library names                */
#define FLDESCSZ   41              /* size of Library descriptions         */
#define FLLDESCS   80              /* size of long Library descriptions    */
#define FLNMCATS   10              /* number of top-level libs joinable    */
#define PATHSIZE   50              /* size of directory path               */

#define NLDLIN      5              /* number of lines in long description  */
#define ULDAYS      7              /* number of days to count new files    */

_NOSCNS_                           /* keep DFCDISP.C happy                 */

struct fllib {                     /* structure for Library data           */
     CHAR libname[FLNAMESZ];       /* Library name                         */
     LONG flags;                   /* various saved bit flags              */
     SHORT day;                    /* day this Library was created         */
     SHORT time;                   /* time of day this Library was created */
     CHAR libdesc[FLDESCSZ];       /* Library short description            */
     SHORT appwait;                /* number of files awaiting approval    */
     CHAR keyreq[KEYSIZ];          /* key to see files at all              */
     CHAR libop[KEYSIZ];           /* key to be a Lib-Op (blank is OK)     */
     CHAR autoap[KEYSIZ];          /* key to auto-approve uploaded files   */
     CHAR dlkey[KEYSIZ];           /* key to download files                */
     CHAR ulkey[KEYSIZ];           /* key to upload files                  */
     CHAR overw[KEYSIZ];           /* key to overwrite files               */
     CHAR cat[FLNMCATS][FLNAMESZ]; /* top-level Libraries a member of      */
     CHAR path[GCSTRPTH];          /* name of alternate path, if any       */
     LONG dlchge;                  /* per-file charge for downloads        */
     LONG kdlchge;                 /* per-K charge for downloads           */
     LONG numfiles;                /* number of files in Library           */
     LONG totfiles;                /* number of files in Library + joined  */
     SHORT royal;                  /* royalty percentage                   */
     SHORT libs;                   /* number of joined Libraries           */
     LONG maxfil;                  /* maximum number of files in Library   */
     LONG maxbyt;                  /* maximum number of bytes in Library   */
     LONG maxbup;                  /* maximum upload size to Library       */
     CHAR primary[UIDSIZ];         /* user who is primary Lib-Op           */
     SHORT newfiles[ULDAYS];       /* added files in last x days, [0]=today*/
     LONG totbytes;                /* total number of bytes in Library     */
     USHORT cluster;               /* cluster size of Library drive        */
};

struct libdisk {                   /* structure for saving Library data    */
     struct fllib lib;             /* structure to save                    */
     CHAR ldesc[NLDLIN][FLLDESCS]; /* long description                     */
};
/* end GALFILH.H declarations */

#define DSTDAT ((struct libdisk *)dstbb->data) /* cast for dest data file    */

INT
main(INT argc,CHAR *argv[])
{
     INT cvtflg,srcflg=0,dstflg=0,srcFileRecSiz,pathLen;
     GBOOL fnd,eatSpare;
     ULONG totrec,currec;

TRY
     if (dfcCustInit(argc,argv,IDSTG) != 0) {
          catastro(dfcLastErr());
     }
#ifdef GCDOS
     srcFileRecSiz=OFLRECSZ;
     pathLen=PATHSIZE;
     eatSpare=TRUE;
#else
     if (sameas(getUpdType(),"2.0 to NT")) {
          srcFileRecSiz=OFLRECSZ;
          pathLen=PATHSIZE;
          eatSpare=TRUE;
     }
     else {
          srcFileRecSiz=sizeof(struct libdisk);
          pathLen=GCSTRPTH;
          eatSpare=FALSE;
     }
#endif // GCDOS
     dfcOpenFiles(srcFileRecSiz,sizeof(struct libdisk));
     totrec=dfaCountRec();
     if (!dfcChkDskSpc(totrec*srcFileRecSiz)) {
          catastro(dfcLastErr());
     }
     if (dfcSupFlags(&srcflg,&dstflg) != 0) {
          catastro(dfcLastErr());
     }
     for (fnd=dfaStepLO(NULL),currec=0L ; fnd ; fnd=dfaStepNX(NULL)) {
          dfcDspRecs(++currec,totrec);
          memset(dstbb->data,0,sizeof(struct libdisk));
          takeInit(srcbb->data,dfaLastLen(),srcflg,dstflg);
          /* these calls based on struct libdisk in 2.0 version of GALFILH.H */
          cvtflg=takeChar(DSTDAT->lib.libname,FLNAMESZ);
          cvtflg&=takeLong(&DSTDAT->lib.flags,1);
          cvtflg&=takeShort(&DSTDAT->lib.day,1);
          cvtflg&=takeShort(&DSTDAT->lib.time,1);
          cvtflg&=takeChar(DSTDAT->lib.libdesc,FLDESCSZ);
          cvtflg&=takeShort(&DSTDAT->lib.appwait,1);
          cvtflg&=takeChar(DSTDAT->lib.keyreq,KEYSIZ);
          cvtflg&=takeChar(DSTDAT->lib.libop,KEYSIZ);
          cvtflg&=takeChar(DSTDAT->lib.autoap,KEYSIZ);
          cvtflg&=takeChar(DSTDAT->lib.dlkey,KEYSIZ);
          cvtflg&=takeChar(DSTDAT->lib.ulkey,KEYSIZ);
          cvtflg&=takeChar(DSTDAT->lib.overw,KEYSIZ);
          cvtflg&=takeChar(DSTDAT->lib.cat,FLNMCATS*FLNAMESZ);
          cvtflg&=takeChar(DSTDAT->lib.path,pathLen);
          cvtflg&=takeLong(&DSTDAT->lib.dlchge,1);
          cvtflg&=takeLong(&DSTDAT->lib.kdlchge,1);
          cvtflg&=takeLong(&DSTDAT->lib.numfiles,1);
          cvtflg&=takeLong(&DSTDAT->lib.totfiles,1);
          cvtflg&=takeShort(&DSTDAT->lib.royal,1);
          cvtflg&=takeShort(&DSTDAT->lib.libs,1);
          cvtflg&=takeLong(&DSTDAT->lib.maxfil,1);
          cvtflg&=takeLong(&DSTDAT->lib.maxbyt,1);
          cvtflg&=takeLong(&DSTDAT->lib.maxbup,1);
          cvtflg&=takeChar(DSTDAT->lib.primary,UIDSIZ);
          cvtflg&=takeShort(&DSTDAT->lib.newfiles,ULDAYS);
          cvtflg&=takeLong(&DSTDAT->lib.totbytes,1);
          cvtflg&=takeShort(&DSTDAT->lib.cluster,1);
          if (eatSpare) {
               cvtflg&=takeChar(NULL,240);
          }
          cvtflg&=takeChar(DSTDAT->ldesc,NLDLIN*FLLDESCS);
          if (cvtflg&1) {
               dfaSetBlk(dstbb);
               dfaInsert(dstbb->data);
          }
          else {
               catastro("GALFLCVT: Error getting source data!");
          }
          dfaSetBlk(srcbb);
     }
     dfaClose(srcbb);
     dfaClose(dstbb);
     dfcClrRecs();
     clsvid();
EXCEPT
     return(0);
}
