/***************************************************************************
 *                                                                         *
 *   GALFILIN.C                                                            *
 *                                                                         *
 *   Copyright (c) 1993-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   File Library - Offline Utility to read file info into a library       *
 *                                                                         *
 *                                                 - D. Pitchford  9/28/93 *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "filexfer.h"
#include "reserve.h"
#include "galfilh.h"
#include "excphand.h"

#define FILREV "$Revision: 11 $"

static CHAR dosscn[GVIDSCNSIZ];

extern CHAR scntbl[][GVIDSCNSIZ];

INT gohome(INT errc);
VOID dobuild(struct flfile *ff,INT insert);
INT makwdlst(const CHAR *stg,const CHAR *filname);
VOID darsdesc(INT limit,CHAR c);
CHAR *inplog(VOID);
CHAR *inplib(VOID);
VOID bubkwds(VOID);
CHAR *cutpunc(CHAR *stg);
VOID strcrep(CHAR *stg,CHAR from,CHAR to);
VOID go(FILE *logfile);
VOID gofbbs(FILE *logfile);
GBOOL valrou(INT c,CHAR *sval);
VOID parsin(VOID);
VOID rstrin(VOID);
CHAR *libpath(struct fllib *libptr);

DFAFILE *newfils;
DFAFILE *newkwd;
DFAFILE *newlib;

struct libdisk l;

CHAR input[INPSIZ],           /* raw user input data buffer                */
     *margv[INPSIZ/2],        /* array of ptrs to word starts, a la argv[] */
     *margn[INPSIZ/2];        /* array of ptrs to word ends, for rstrin()  */

INT margc,
    inplen;

CHAR *descedit;

CHAR loglib[FLNAMESZ];

INT dargc;

CHAR *dargv[MAXKWDS];

CHAR *nonkwds="\
. MOST TEXT COMPUTER FILE NICE DISK YOUR REQUIRES GOOD VERSION RAM MEG MEGS .\
. LATEST LITTLE SOFTWARE DURING ALL BEST .\
. ABLE ABOUT ABOVE ACCEPT ACCESS ACROSS ACTUAL ACTUALLY ADD AFTER AGAIN .\
. AGO AGREE AGREES AHEAD AIN AINT ALL ALLOW ALLOWED ALLOWS ALMOST ALONE .\
. ALONG ALREADY ALRIGHT ALSO ALWAYS AND ANOTHER ANSWER ANSWERS ANY .\
. ANYONE ANYTHING ANYTIME ANYWAY ANYWHERE APPLIES APPLY ARE AREN ARENT .\
. AROUND ASK ASKED ASKING ASKS ATTACH ATTACHED AVE AWAIT AWAITED AWAITING .\
. AWAY BACK BARE BARELY BE BECAME BECAUSE BECOME BECOMES BEEN BEFORE BEGAN .\
. BEGIN BEGINS BEGUN BEING BETTER BOTH BREAK BRING BRINGS BUSY BUT CALL .\
. CALLED CALLING CAN CANNOT CARE CAUSES CHANCE CHANGE CHANGED CHANGES .\
. CHANGING CHOICES CLEARLY CLOSELY COME COMES COMING COULD COULDN COVER .\
. CURRENT DID DOES DOESN DOING DON DURING EACH ELSE ENJOY ENOUGH ENTIRE .\
. ENTIRELY EVEN EVER EVERY EVERYONE EXCEPT FEEL FILL FILLED FILLS FIND FINDS .\
. FOR FORTH FROM FULL FULLY GAVE GET GETS GETTING GIVE GIVEN GIVES GIVING .\
. GOES GOING GONE GOT HAD HAS HAVE HAVEN HER HERE HERS HERSELF HEY HIM HIMSELF .\
. HIS HISELF HIT HITS HOPE HOW INSTEAD INTO ISN ISSUE ISSUES ISSUING ITS .\
. ITSELF JUST KEEP KEEPING KEPT KIND KINDS KNOW LET LETS LETTING LIKE LIKED .\
. LIKELY LOT LOTS MAKE MAKES MAKING MANY MAY MAYBE MIGHT MINE MORE MOVE MOVES .\
. MOVING MRS MUCH MUST NEED NEEDS NEVER NEW NONE NONETHELESS NORMALLY NOT .\
. NOTHING NOW OCCUR OFF OFFER OFFERING OFFERS OFTEN ONCE ONE ONLY OTHER .\
. OTHERS OUR OUT OVER OWN PER PLACE PLACED PULL PUT PUTS PUTTING QUITE READY .\
. REST SAID SAME SAY SAYING SAYS SEE SEE SEEING SEEM SEEMED SEEN SEES SEND .\
. SENDING SENT SEVERAL SHALL SHE SHOULD SHOULDN SINCE SOME SOON SUCH SURE .\
. TAKE TAKEN TAKING TELL TELLING TELLS THAN THAT THATS THE THEIR THEM .\
. THEMSELVES THEN THERE THESE THEY THING THINGS THIS THOSE THROW THRU TOLD .\
. TOO TOWARD TOWARDS TRIED TRY TRYING UNLIKE UNTIL UPON USE USES USUAL VARY .\
. VERY WANT WANTED WANTS WAS WASN WAY WAYS WELL WENT WERE WEREN WHAT WHEN .\
. WHERE WHICH WHILE WHO WHOEVER WHOM WHY WILL WITH WITHIN WITHOUT WON WOULD .\
. YET YOU YOUR YOURS .";

static INT cc=4,rr=7,changed=0;

static INT casesens=0;
static INT pcboard=0;

INT
main(                              /* main program loop                    */
INT argc,
CHAR *argv[])
{
TRY
     INT ec,loop,accel=0,fbbs=0;
     CHAR *a1,*a2;

#ifdef GCWINNT
     if (!canRunUtil()) {
          MessageBox(NULL,NOPROCEED,
                    argv[0],MB_ICONSTOP|MB_OK|MB_TASKMODAL|MB_SETFOREGROUND);
          return(1);
     }
#endif // GCWINNT
     initvid();
     if ((ec=setjmp(disaster)) != 0) {
          return(gohome(ec));
     }
     cursiz(GVIDNOCURS);
     scn2mem(dosscn,0,GVIDSCNSIZ);
     monorcol();
     explodeto(cvtscn(scntbl[0]),0,0,70,10,cc,rr);
     setatr(0x1E);
     setwin(NULL,cc+2,rr+3,cc+70-1,rr+10-1,1);
     locate(cc+2,rr+3);
     descedit=(CHAR *)alczer(DESCSIZ);
     for (loop=1 ; loop < argc ; loop++) {
          if (sameas(argv[loop],"-C")) {
               casesens=1;
          }
          else if (sameas(argv[loop],"-P")) {
               pcboard=1;
          }
          else if (sameas(argv[loop],"-CP")) {
               casesens=1;
               pcboard=1;
          }
     }
     if (argc == 4 || argc==3 || argc == 2) {
          for (loop=1 ; loop < argc ; loop++) {
               if (sameas(argv[loop],"-X")) {
                    accel=1;
                    break;
               }
          }
     }
     if (argc-accel != 3) {
          if ((argc > 1 && samend(a1=argv[1],".BBS"))
           || (argc > 2 && samend(a1=argv[2],".BBS"))) {
               fbbs=1;
          }
          else {
               a1=inplog();
               if (!strlen(a1)) {
                    return(gohome(ec));
               }
               if (!samend(a1,".BBS")) {
                    a2=inplib();
                    if (!strlen(a2)) {
                         return(gohome(ec));
                    }
               }
               else {
                    fbbs=1;
               }
          }
     }
     else {
          a1=argv[1];
          a2=argv[2];
          if (sameas(a1,"-X")) {
               a1=argv[2];
               a2=argv[3];
          }
          else if (sameas(a2,"-X")) {
               a2=argv[3];
          }
     }
     explodem=0;
     explodeto(cvtscn(scntbl[0]),0,0,70,10,cc,rr);
     explodem=1;
     dfaMode(PRIMBV);
     newlib=dfaOpen("galfill2.dat",sizeof(struct libdisk),NULL);
     if (accel) {
          dfaMode(ACCLBV);
     }
     newfils=dfaOpen("galfilf2.dat",FLFILREC+DESCSIZ,NULL);
     dfaMode(PRIMBV);
     locate(cc+2,rr+3);
     if (fbbs || accel) {
          dfaMode(ACCLBV);
     }
     newkwd=dfaOpen("galfilk2.dat",FLKEYREC,NULL);
     dfaMode(PRIMBV);
     if (!fbbs) {
          printf("Now logging in files...\n");
          dfaSetBlk(newlib);
          if (dfaAcqEQ(&l,a2,0)) {
               stzcpy(loglib,l.lib.libname,FLNAMESZ);
               go(fopen(a1,FOPRB));
          }
          else {
               printf("Could not find a \"%s\" Library. hit a key...\n",strupr(a2));
               getch();
          }
     }
     else {
          printf("Now logging in new descriptions...\n");
          gofbbs(fopen(a1,FOPRB));
     }
     dfaClose(newfils);
     dfaClose(newkwd);
     dfaSetBlk(newlib);
     if (changed && dfaAcqEQ(NULL,l.lib.libname,0)) {
          dfaUpdate(&l);
     }
     dfaClose(newlib);
     return(gohome(ec));
EXCEPT
#ifdef GCWINNT
     return(1);
#endif // GCWINNT
}

CHAR *
libpath(                           /* return path to lib's files           */
struct fllib *libptr)
{
     return(libptr->path[0] != '\0' ? libptr->path : libptr->libname);
}

INT
gohome(                            /* get ready to go back to DOS now      */
INT errc)
{
     setatr(0x07);
     if (errc == 0) {
          printf(" ");
          mem2scn(dosscn,0,GVIDSCNSIZ);
     }
     locate(0,24);
     cursiz(GVIDLILCURS);
     clsvid();
     return(errc);
}

VOID
rstrin(VOID)                  /* restore parsed input to a single string   */
{
     INT i;

     for (i=0 ; i < margc-1 ; i++) {
          *margn[i]=' ';
     }
}

VOID
dobuild(                           /* update file record and keywords      */
struct flfile *ff,
INT insert)
{
     struct key2 kwdy;
     INT loop;
     struct flfile *gg;
     CHAR filkey[FLFILENM+FLNAMESZ];

     dfaSetBlk(newfils);
     if (strlen(ff->libname) || !insert) {
          stzcpy(ff->numdls,spr(NUMSZP,0L),NUMSZ);
          if (!insert) {
               stzcpy(filkey,ff->filname,FLFILENM+FLNAMESZ);
               gg=(struct flfile *)newfils->data;
               while (dfaAcqGT(NULL,filkey,3) && sameas(filkey,gg->filname)) {
                    stzcpy(&filkey[FLFILENM],gg->libname,FLNAMESZ);
                    if (gg->desc[0] == '\0' || pcboard) {
                         printf("Updating description: %s/%s...\n",
                                gg->libname,gg->filname);
                         stzcpy(gg->desc,ff->desc,DESCSIZ);
                         dfaUpdateV(NULL,FLFILREC+strlen(gg->desc)+1);
                         if (makwdlst(gg->desc,gg->filname)) {
                              printf("Inserting new keywords...\n");
                              stzcpy(kwdy.libkey,gg->libname,FLNAMESZ);
                              stzcpy(kwdy.filname,gg->filname,FLFILENM);
                              dfaSetBlk(newkwd);
                              while (dfaAcqEQ(NULL,filkey,1)) {
                                   dfaDelete();
                              }
                              for (loop=0 ; loop < dargc ; loop++) {
                                   if (!samein(spr(" %s ",dargv[loop]),nonkwds)) {
                                        stzcpy(kwdy.keyword,dargv[loop],FLKEYSIZ);
                                        dfaInsert(&kwdy);
                                   }
                              }
                              dfaSetBlk(newfils);
                         }
                    }
               }
               return;
          }
          else {
               if (dfaAcqEQ(NULL,ff->libname,1)) {
                    gg=ff;
                    ff=(struct flfile *)newfils->data;
                    stzcpy(ff->desc,gg->desc,DESCSIZ);
                    dfaUpdateV(NULL,FLFILREC+strlen(ff->desc)+1);
               }
               else {
                    dfaInsertV(ff,FLFILREC+strlen(ff->desc)+1);
               }
          }
          if (makwdlst(ff->desc,ff->filname)) {
               printf("%c%s/%s%c%c",13,ff->libname,ff->filname,13,10);
               stzcpy(kwdy.libkey,ff->libname,FLNAMESZ);
               stzcpy(kwdy.filname,ff->filname,FLFILENM);
               stzcpy(filkey,ff->filname,FLFILENM+FLNAMESZ);
               stzcpy(&filkey[FLFILENM],ff->libname,FLNAMESZ);
               dfaSetBlk(newkwd);
               while (dfaAcqEQ(NULL,filkey,1)) {
                    dfaDelete();
               }
               for (loop=0 ; loop < dargc ; loop++) {
                    if (!samein(spr(" %s ",dargv[loop]),nonkwds)) {
                         stzcpy(kwdy.keyword,dargv[loop],FLKEYSIZ);
                         dfaInsert(&kwdy);
                         printf("%c               %c%s%c",
                                13,13,dargv[loop],13);
                    }
               }
               dfaSetBlk(newfils);
          }
          l.lib.numfiles++;
          if (sameas(ff->udate,NOTAPPED)) {
               l.lib.appwait++;
          }
          else {
               l.lib.newfiles[0]++;
          }
          l.lib.totbytes+=clfit(ff->siz,l.lib.cluster);
          changed=1;
     }
}

INT
makwdlst(                          /* make keyword list                    */
const CHAR *stg,
const CHAR *filname)
{
     CHAR filnmem[FLFILENM],*ext;

     descedit[0]='\0';
     stzcpy(filnmem,filname,FLFILENM);
     ext=strchr(strupr(filnmem),'.');
     if (ext != NULL) {
          *ext++='\0';
          if (strlen(ext) == 3) {
               strcat(descedit,ext);
               strcat(descedit," ");
          }
     }
     if (strlen(filnmem) > 2) {
          strcat(descedit,filnmem);
          strcat(descedit," ");
     }
     stzcat(descedit,stg,DESCSIZ);
     strcrep(descedit,'\r',' ');
     strupr(descedit);
     darsdesc(MAXKWDS,' ');
     bubkwds();
     return(dargc > 0);
}

VOID
darsdesc(                          /* parsin() on descedit                 */
INT limit,
CHAR c)
{
     CHAR *s;
     INT loop;

     s=descedit;
     dargc=0;
     for (loop=0 ; loop < limit ; loop++) {
          dargv[loop]=s;
          if (strlen(s)) {
               s=strchr(s,c);
               if (s == NULL) {
                    s=&descedit[strlen(descedit)];
               }
               else {
                    *s='\0';
                    s++;
               }
               dargc++;
          }
     }
}

VOID
bubkwds(VOID)                      /* edit and sort keywords               */
{
     CHAR *current,*newarg;
     INT loop,loop2;

     for (loop=0 ; loop < dargc ; loop++) {
          cutpunc(dargv[loop]);              /* cut symbols                */
          loop2=strlen(dargv[loop]);
          if (loop2 > FLKEYSIZ-1) {          /* shorten long words         */
               dargv[loop][FLKEYSIZ-1]='\0';
          }
          else if (loop2 < 3) {              /* cut really short words     */
               dargc--;
               if (loop != dargc) {
                    dargv[loop--]=dargv[dargc];
               }
          }
     }
     for (loop=0 ; loop < (dargc-1) ; loop++) { /* sort them now           */
          current=dargv[loop];
          for (loop2=(loop+1) ; loop2 < dargc ; loop2++) {
               newarg=dargv[loop2];
               if (stricmp(current,newarg) > 0) {
                    dargv[loop2]=current;
                    current=dargv[loop]=newarg;
               }
          }
     }
     for (loop=0 ; loop < dargc-1 ; loop++) { /* eliminate duplicates      */
          if (stricmp(dargv[loop],dargv[loop+1]) == 0) {
               for (loop2=loop+1 ; loop2 < dargc-1 ; loop2++) {
                    dargv[loop2]=dargv[loop2+1];
               }
               dargc--;
               loop--;
          }
     }
}

CHAR *
cutpunc(                           /* cuts words at punctuation            */
CHAR *stg)
{
     INT loop,l;
     CHAR *s;

     l=strlen(stg);
     for (loop=0 ; loop < l ; loop++) {
          s=&stg[loop];
          if ((*s < '0') || ((*s > '9') && (*s < 'A')) || (*s > 'Z')) {
               if (*s < '') {
                    *s='\0';
                    if (strlen(++s) && (dargc < (MAXKWDS-1))) {
                         dargv[dargc++]=s;
                    }
                    loop=l;
               }
          }
     }
     return(stg);
}

VOID
strcrep(                           /* replace a char in a string w/ a char */
CHAR *stg,
CHAR from,
CHAR to)
{
     INT loop,s;

     s=strlen(stg);
     for (loop=0 ; loop < s ; loop++) {
          if (*stg == from) {
               *stg=to;
          }
          stg++;
     }
}

VOID
go(                                /* main conversion routine              */
FILE *logfile)
{
     INT x;
     CHAR *s;
     struct flfile flflog;
     struct ffblk fb;

     setmem(&flflog,sizeof(struct flfile),0);
     if (logfile == NULL) {
          printf("Could not open file - exiting\n");
          gcdelay(2*1000);
     }
     do {
          x=readline(logfile);
          if (!x) {
               fclose(logfile);
               logfile=NULL;
          }
          inplen=strlen(input);
          if (pcboard && inplen && *((CHAR *)input) == 179
           && *((CHAR *)(input+1)) == 250) {
               continue;
          }
          if (inplen && (*input != ' ')) {
               dobuild(&flflog,1);
               setmem(&flflog,sizeof(struct flfile),0);
          }
          if (inplen) {
               if (*input != ' ') {
                    parsin();
                    if (margc > 0) {
                         stzcpy(flflog.filname,fnmcse(margv[0]),FLFILENM);
                         stzcpy(flflog.libname,loglib,FLNAMESZ);
                         if (margc > 2
                          || fndfile(&fb,spr("%s"SLS"%s",libpath(&l.lib),
                                     flflog.filname),0)) {
                              flflog.siz=margc > 1
                                        ? atol(margv[1]) : fb.ff_fsize;
                              stzcpy(flflog.fdate,margc > 2 ? dat2srt(margv[2])
                                                : ddat2srt(fb.ff_fdate),DATESZ);
                              s=margc > 3 && !sameas(margv[3],"U")
                               ? ddat2srt(today()) : NOTAPPED;
                              stzcpy(flflog.udate,s,DATESZ);
                              rstrin();
                              if (pcboard) {
                                   stzcpy(flflog.ulby,"Sysop",UIDSIZ);
                                   if (margc > 3) {
                                        strcpy(flflog.desc,margv[3]);
                                   }
                              }
                              else {
                                   stzcpy(flflog.ulby,(margc > 4)
                                                   ? margv[4] : "Sysop",UIDSIZ);
                              }
                         }
                    }
               }
               else if ((strlen(flflog.desc)+strlen(input)) < (DESCSIZ-3)) {
                    strcat(flflog.desc,&input[1]);
                    strcat(flflog.desc,"\r");
               }
          }
          if (logfile == NULL) {
               dobuild(&flflog,1);
               setmem(&flflog,sizeof(struct flfile),0);
          }
          if (kbhit() && (getch() == ESC)) {
               return;
          }
     } while (logfile != NULL);
}

VOID
parsin(VOID)                       /* parse input into margv[], etc.       */
{
     CHAR *inpptr;

     margc=0;
     inplen=0;
     inpptr=input-1;
     while (1) {
          while (*++inpptr == ' ') {
          }
          if (*inpptr == '\0') {
               break;
          }
          margv[margc]=inpptr;
          while (*++inpptr != ' ') {
               if (*inpptr == '\0') {
                    margn[margc++]=inpptr;
                    inplen=(INT)(inpptr-input);
                    return;
               }
          }
          *inpptr='\0';
          margn[margc++]=inpptr;
     }
     if (margc != 0) {
          inplen=(INT)(margn[margc-1]-input);
          setmem(margn[margc-1],sizeof(input)-inplen,0);
     }
     else {
          margv[0]="";
     }
}

CHAR *
dat2srtu(                          /* convert 10/24/1993 to "1070207"      */
INT year,                          /* 2100-1993==107, 12-10==02, 31-24==07 */
INT month,
INT day)
{
     static CHAR retval[4][DATESZ];
     static INT cycle=0;

     memset(retval[cycle=((cycle+1)&3)],0,DATESZ);
     if (year <= 2100 && validDate(year,month,day)) {
          sprintf(retval[cycle],"%03d%02d%02d",2100-year,12-month,31-day);
     }
     else {
          strcpy(retval[cycle],NOTAPPED);
     }
     return(retval[cycle]);
}

CHAR *
dat2srt(                           /* convert "10/24/[19]93" to "1070207"  */
const CHAR *dt)                    /* 2100-1993==107, 12-10==02, 31-24==07 */
{
     INT y,m,d;

     dateDecode(dt,&y,&m,&d);
     return(dat2srtu(y,m,d));
}

CHAR *
ddat2srt(                          /* convert DOS date to "1070207"        */
USHORT dosDate)
{
     return(dat2srtu(ddyear(dosDate),ddmon(dosDate),ddday(dosDate)));
}

INT
readline(                          /* read a line from a text file         */
FILE *ptr)
{
     INT c=0,rv=1;
     static INT last=0;
     CHAR *pos;

     setmem(input,INPSIZ,0);
     pos=input;
     while ((c != 13) && (c != 10) && (ptr != NULL)) {
          c=fgetc(ptr);
          if (feof(ptr) || ferror(ptr)) {
               last=0;
               rv=0;
               rewind(ptr);
               c=13;
          }
          else {
               switch (c) {
               case 10:
               case 13:
                    if (!last) {
                         last=1;
                    }
                    else {
                         if (!strlen(input)) {
                              c=0;
                         }
                         last=0;
                    }
                    break;
               case 0:
                    c=13;
                    break;
               default:
                    last=0;
                    *pos=c;
                    pos++;
                    if (strlen(input) == 255) {
                         c=13;
                    }
               case 26:
               case EOF:
                    break;
               }
          }
     }
     return(rv);
}

GBOOL
valrou(                            /* validation routine                   */
INT c,
CHAR *sval)
{
     return((strlen(sval) || c) ? TRUE : FALSE);
}

CHAR *
inplog(VOID)                      /* input log file name                  */
{
     static CHAR log[13];

     setmem(log,13,0);
     locate(cc+2,rr+3);
     printf("    In addition to the capabilities detailed in the manual,\n");
     printf("    this program will add descriptions from industry-standard\n");
     printf("    FILES.BBS files, found on most CD-ROMs.  Please note that\n");
     printf("    the files must already be logged in for FILES.BBS "
         "importing\n");
     printf("    to work.\n");
     locate(cc+10,rr+9);
     printf("Enter script to log in, or ESC to exit: ");
     if (!edtval(cc+50,rr+9,13,log,valrou,0)) {
          setmem(log,13,0);
     }
     locate(cc+10,rr+9);
     printf("                                                     ");
     return(log);
}

CHAR *
inplib(VOID)                      /* input library name                   */
{
     static CHAR log[9];

     setmem(log,9,0);
     locate(cc+10,rr+9);
     printf("                                                    ");
     locate(cc+10,rr+9);
     printf("Enter Library to log into, or ESC to exit: ");
     if (!edtval(cc+53,rr+9,9,log,valrou,ALLCAPS)) {
          setmem(log,9,0);
     }
     locate(cc+10,rr+9);
     printf("                                                    ");
     return(log);
}

VOID
gofbbs(                            /* main conversion routine              */
FILE *logfile)
{
     INT x,ctskip=-1;
     CHAR *s;
     struct flfile flflog;

     setmem(&flflog,sizeof(struct flfile),0);
     if (logfile == NULL) {
          printf("Could not open file - exiting\n");
          gcdelay(2*1000);         // HACH WGS 2.0 does not have it
     }
     do {
          x=readline(logfile);
          if (!x) {
               fclose(logfile);
               logfile=NULL;
          }
          inplen=strlen(input);
          if (pcboard && inplen && *((CHAR *)input) == 179
           && *((CHAR *)(input+1)) == 250) {
               continue;
          }
          if (inplen && (*input != ' ')) {
               dobuild(&flflog,0);
               setmem(&flflog,sizeof(struct flfile),0);
          }
          if (inplen) {
               if (*input != ' ') {
                    parsin();
                    if (margc >= 1) {
                         stzcpy(flflog.filname,fnmcse(margv[0]),FLFILENM);
                    }
                    if (pcboard) {
                         rstrin();
                         strcat(flflog.desc,margv[3]);
                         strcat(flflog.desc,"\r");
                    }
                    else if (margc >= 2) {
                         if (ctskip != -1) {
                              if (ctskip > 0) {
                                   if (atol(margv[ctskip]) == 0L
                                      && isalpha(margv[ctskip][0])) {
                                        ctskip--;
                                   }
                              }
                              rstrin();
                              strcat(flflog.desc,margv[1+ctskip]);
                              strcat(flflog.desc,"\r");
                         }
                         else {
                              ctskip++;
                              for (x=1 ; x < margc ; x++) {
                                   if (atol(margv[x]) == 0L) {
                                        if (isalpha(margv[x][0])) {
                                             rstrin();
                                             strcat(flflog.desc,margv[x]);
                                             strcat(flflog.desc,"\r");
                                             break;
                                        }
                                        else {
                                             ctskip++;
                                        }
                                   }
                                   else {
                                        ctskip++;
                                   }
                              }
                         }
                    }
               }
               else {
                    s=input;
                    while (*s == ' ') {
                         s++;
                    }
                    if (*s == '|') {
                         s++;
                    }
                    while (*s == ' ') {
                         s++;
                    }
                    if ((strlen(flflog.desc)+strlen(s)) < (DESCSIZ-3)) {
                         strcat(flflog.desc,s);
                         strcat(flflog.desc,"\r");
                    }
               }
          }
          if (logfile == NULL) {
               dobuild(&flflog,0);
               setmem(&flflog,sizeof(struct flfile),0);
          }
          if (kbhit() && (getch() == ESC)) {
               return;
          }
     } while (logfile != NULL);
}
