/****************************************************************************
 *                                                                          *
 *  GMETVBAH.H                                                              *
 *                                                                          *
 *  Active HTML Text Variable Class Decs                                    *
 *                                                                          *
 *  Copyright 1998, Galacticomm, Inc., All Rights Reserved                  *
 *                                                                          *
 *                                                     6/8/98 N C Osterc    *
 *                                                                          *
 ****************************************************************************/

#include "tvb.h"
#include "dnf.h"
#include "efcommon.h"

#ifndef __GMETVBAH_H
#define __GMETVBAH_H

#if defined(GCWINNT)
#ifdef __BUILDMSGAH
#define TVBEXP __export
#else
#define TVBEXP __import
#endif // __BUILDMSGAH
#else
#define TVBEXP
#endif // GCWINNT

class string;

class EXPORT gmeTvb : public tvbDefinition {  // our tvb class implementation
public:

     gmeTvb(                       // constructor
     const CHAR* name);            // name of text variable

     ~gmeTvb();                    // destructor

     virtual VOID
     set(                          // set tvb value
     const CHAR *fmt,              // format specifier(s)
     ...);                         // argument list

     virtual const CHAR*           // the value gotten
     get() const;                  // get value of tvb

     VOID
     clr();                        // clear text variable value

     GBOOL
     htmlEncodeIt();               // should we HTML encode?

     GBOOL
     cgiEncodeIt();                // should we CGI encode?

     VOID
     setHtmlEncode(                // enable HTML encoding?
     GBOOL bVal);                  // boolean set

     VOID
     setCgiEncode(                 // enable CGI encoding?
     GBOOL bVal);                  // boolean set

     virtual const CHAR*           // value of variable
     resolve(                      // resolve the value of a tvb
     const CHAR *nam);             // tvb to resolve

protected:

     string* m_pVal;               // the tvb value
     GBOOL bHtmlEncode;            // html encode?
     GBOOL bCgiEncode;             // cgi encode?
};

extern gmeTvb TVBEXP mMsgId;              // MHDR_MSGID
extern gmeTvb TVBEXP mThrdId;             // MHDR_THRID
extern gmeTvb TVBEXP mForId;              // MHDR_FORID
extern gmeTvb TVBEXP mGlbId;              // MHDR_GLBID
extern gmeTvb TVBEXP mForName;            // MHDR_FORNAME
extern gmeTvb TVBEXP mForNameUrl;         // MHDR_FORNAME_U
extern gmeTvb TVBEXP mForDisp;            // MHDR_FORDISP
extern gmeTvb TVBEXP mTo;                 // MHDR_TO
extern gmeTvb TVBEXP mToUrl;              // MHDR_TO_U
extern gmeTvb TVBEXP mToNoPfx;            // MHDR_TO_NOPFX
extern gmeTvb TVBEXP mToMailTo;           // MHDR_TO_MAILTO
extern gmeTvb TVBEXP mFrom;               // MHDR_FR
extern gmeTvb TVBEXP mFromUrl;            // MHDR_FR_U
extern gmeTvb TVBEXP mFromNoPfx;          // MHDR_FR_NOPFX
extern gmeTvb TVBEXP mFromMailTo;         // MHDR_FR_MAILTO
extern gmeTvb TVBEXP mTopic;              // MHDR_TOPIC
extern gmeTvb TVBEXP mHistory;            // MHDR_HISTORY
extern gmeTvb TVBEXP mHistoryP;           // MHDR_HISTORY_P
extern gmeTvb TVBEXP mAttName;            // MHDR_ATTNAME
extern gmeTvb TVBEXP mAttPfx;             // MHDR_ATTPFX
extern gmeTvb TVBEXP mReplyTo;            // MHDR_REPLYTO
extern gmeTvb TVBEXP mDateUsaLong;        // MHDR_DATE_USA_L
extern gmeTvb TVBEXP mDateUsaShort;       // MHDR_DATE_USA_S
extern gmeTvb TVBEXP mDateEurLong;        // MHDR_DATE_EUR_L
extern gmeTvb TVBEXP mDateEurShort;       // MHDR_DATE_EUR_S
extern gmeTvb TVBEXP mYearLong;           // MHDR_DATE_Y_L
extern gmeTvb TVBEXP mYearShort;          // MHDR_DATE_Y_S
extern gmeTvb TVBEXP mMonthLong;          // MHDR_DATE_M_L
extern gmeTvb TVBEXP mMonthShort;         // MHDR_DATE_M_S
extern gmeTvb TVBEXP mMonthNumeric;       // MHDR_DATE_M_N
extern gmeTvb TVBEXP mMonthNumPad;        // MHDR_DATE_M_N0
extern gmeTvb TVBEXP mDayNum;             // MHDR_DATE_D
extern gmeTvb TVBEXP mDayNumPad;          // MHDR_DATE_D0
extern gmeTvb TVBEXP mDayWeekLong;        // MHDR_DATE_W_L
extern gmeTvb TVBEXP mDayWeekShort;       // MHDR_DATE_W_S
extern gmeTvb TVBEXP mTime12Long;         // MHDR_TIME_12_L
extern gmeTvb TVBEXP mTime12Short;        // MHDR_TIME_12_S
extern gmeTvb TVBEXP mTime24Long;         // MHDR_TIME_24_L
extern gmeTvb TVBEXP mTime24Short;        // MHDR_TIME_24_S
extern gmeTvb TVBEXP mHour12;             // MHDR_TIME_H_12
extern gmeTvb TVBEXP mHour120;            // MHDR_TIME_H_120
extern gmeTvb TVBEXP mHour24;             // MHDR_TIME_H_24
extern gmeTvb TVBEXP mHour240;            // MHDR_TIME_H_240
extern gmeTvb TVBEXP mMinute;             // MHDR_TIME_M
extern gmeTvb TVBEXP mMinutePad;          // MHDR_TIME_M0
extern gmeTvb TVBEXP mSec;                // MHDR_TIME_S
extern gmeTvb TVBEXP mSecPad;             // MHDR_TIME_S0
extern gmeTvb TVBEXP mMeridiemLong;       // MHDR_TIME_A_L
extern gmeTvb TVBEXP mMeridiemLongPeriods;// MHDR_TIME_A_LP
extern gmeTvb TVBEXP mMeridiemShort;      // MHDR_TIME_A_S
extern gmeTvb TVBEXP mMeridiemLongCaps;   // MHDR_TIME_A_LC
extern gmeTvb TVBEXP mMeridiemLongCapPer; // MHDR_TIME_A_LPC
extern gmeTvb TVBEXP mMeridiemShortCap;   // MHDR_TIME_A_SC
extern gmeTvb TVBEXP mNumberOfReplies;    // MHDR_NREPLIES
extern gmeTvb TVBEXP mDisplayNumReplies;  // MHDR_NRPL_DISP
extern gmeTvb TVBEXP mPriority;           // MHDR_PRIORITY
extern gmeTvb TVBEXP mExempt;             // MHDR_EXEMPT
extern gmeTvb TVBEXP mReceipt;            // MHDR_RECEIPT
extern gmeTvb TVBEXP mAttImage;           // MHDR_ATT_IMG
extern gmeTvb TVBEXP mPriImage;           // MHDR_PRI_IMG
extern gmeTvb TVBEXP mXmtImage;           // MHDR_XMT_IMG
extern gmeTvb TVBEXP mRRRImage;           // MHDR_RRR_IMG
extern gmeTvb TVBEXP mAttSize;            // MHDR_ATT_SIZ
extern gmeTvb TVBEXP mMsgSize;            // MHDR_MSG_SIZ not being used currently
extern gmeTvb TVBEXP mIsAuthor;           // MHDR_ISAUTHOR

VOID EXPORT
setUpMessageHeaderDefs(            // work-horse method-sets up majority of tvbs
struct message *msghdr);           // passed message structure to use

extern gmeTvb TVBEXP mNoMessage1;         // MLST_NOMSG_1
extern gmeTvb TVBEXP mNoMessage2;         // MLST_NOMSG_2
extern gmeTvb TVBEXP mNoMessage3;         // MLST_NOMSG_3
extern gmeTvb TVBEXP mNoMessage4;         // MLST_NOMSG_4
extern gmeTvb TVBEXP mNoMessage5;         // MLST_NOMSG_5
extern gmeTvb TVBEXP mNoMessage6;         // MLST_NOMSG_6
extern gmeTvb TVBEXP mNoMessage7;         // MLST_NOMSG_7
extern gmeTvb TVBEXP mNoMessage8;         // MLST_NOMSG_8
extern gmeTvb TVBEXP mNoMessage9;         // MLST_NOMSG_9

extern gmeTvb TVBEXP mCount;              // MLST_COUNT
extern gmeTvb TVBEXP mOrder;              // MLST_ORDER
extern gmeTvb TVBEXP mMsgIdLow;           // MLST_MSGID_LOW
extern gmeTvb TVBEXP mMsgIdHi;            // MLST_MSGID_HIGH
extern gmeTvb TVBEXP mMoreLow;            // MSG_MORE_LOW
extern gmeTvb TVBEXP mMoreHi;             // MSG_MORE_HIGH

VOID EXPORT
setCountTvb(                       // establish value of count tvb
INT count);                        // value to establish

VOID EXPORT
setOrderTvb(                       // establish value of order tvb
const CHAR *order);                // order ; // ascending"/"descending")

VOID EXPORT
setMsgIdLowTvb(                    // establish value of low msg
ULONG msgid);                      // value to establish

VOID EXPORT
setMsgIdHiTvb(                     // establish value of hi msg
ULONG msgid);                      // value to establish

VOID EXPORT
setMoreLowTvb(                     // establish if there are more low msgs
GBOOL more);                       // yes or no

VOID EXPORT
setMoreHiTvb(                      // establish if there are more hi msgs
GBOOL more);                       // yes or no

VOID EXPORT
setUpNoMessages();                 // handle no msg tvbs

extern gmeTvb TVBEXP mWriteType;          // MWRT_TYPE
extern gmeTvb TVBEXP mWriteOrgForId;      // MWRT_ORGFORID
extern gmeTvb TVBEXP mWriteOrgMsgId;      // MWRT_ORGMSGID
extern gmeTvb TVBEXP mWritePriChk;        // MWRT_PRI_CHK
extern gmeTvb TVBEXP mWriteRRRChk;        // MWRT_RRR_CHK
extern gmeTvb TVBEXP mWriteCCList;        // MWRT_CCLIST
extern gmeTvb TVBEXP mWriteIncList;       // MWRT_INCLIST
extern gmeTvb TVBEXP mWriteTmpid;         // MWRT_TMPID
extern gmeTvb TVBEXP mWriteUseTags;       // MWRT_USETAGS
extern gmeTvb TVBEXP mWriteAttFlag;       // MWRT_ATT_FLG

extern gmeTvb TVBEXP ePrefType;           // EPREF_TYPE
extern gmeTvb TVBEXP ePrefTypeHtml;       // EPREF_TYPE_HTML
extern gmeTvb TVBEXP ePrefTypeJava;       // EPREF_TYPE_JAVA
extern gmeTvb TVBEXP ePrefUseFrames;      // EPREF_USEFRAMES
extern gmeTvb TVBEXP mPrefReflow;         // MPREF_REFLOW
extern gmeTvb TVBEXP mPrefQuote;          // MPREF_QUOTE
extern gmeTvb TVBEXP mPrefIncList;        // MPREF_INCLIST
extern gmeTvb TVBEXP mPrefUseTags;        // MPREF_USETAGS
extern gmeTvb TVBEXP ePrefForwardee;      // EPREF_FORWARDEE
extern gmeTvb TVBEXP ePrefClrReply;       // EPREF_CLRREPLY
extern gmeTvb TVBEXP ePrefForumTo;        // EPREF_FORUMTO

extern gmeTvb TVBEXP mErrorMsg;           // MERR_MESSAGE
extern gmeTvb TVBEXP mErrorCode;          // MERR_CODE

VOID EXPORT
setErrorMessage(                   // set read message error tvb
const CHAR *errMsg);               // the error message

VOID EXPORT
setErrorCode(                      // set read error code tvb
INT code);                         // the error code

extern gmeTvb TVBEXP emlTarget1;          // EML_TARGET_1
extern gmeTvb TVBEXP emlTarget2;          // EML_TARGET_2
extern gmeTvb TVBEXP emlTarget3;          // EML_TARGET_3
extern gmeTvb TVBEXP emlTarget4;          // EML_TARGET_4
extern gmeTvb TVBEXP emlTarget5;          // EML_TARGET_5
extern gmeTvb TVBEXP emlTarget6;          // EML_TARGET_6
extern gmeTvb TVBEXP emlTarget7;          // EML_TARGET_7
extern gmeTvb TVBEXP emlTarget8;          // EML_TARGET_8
extern gmeTvb TVBEXP emlTarget9;          // EML_TARGET_9

VOID EXPORT
setEmailTargetTvbs(                       // set or clear eml_target_x vbs
GBOOL set);

extern gmeTvb TVBEXP forID;               // FDEF_FORID
extern gmeTvb TVBEXP forName;             // FDEF_FORNAME
extern gmeTvb TVBEXP forNameU;            // FDEF_FORNAME_U
extern gmeTvb TVBEXP forTopic;            // FDEF_TOPIC
extern gmeTvb TVBEXP forOP;               // FDEF_FOROP
extern gmeTvb TVBEXP forThreads;          // FDEF_THRS
extern gmeTvb TVBEXP forMessages;         // FDEF_MSGS
extern gmeTvb TVBEXP forFiles;            // FDEF_FILES
extern gmeTvb TVBEXP forFilesWaiting;     // FDEF_FILES_WAIT
extern gmeTvb TVBEXP forMsgLife;          // FDEF_MSGLIFE
extern gmeTvb TVBEXP forChgPost;          // FDEF_CHG_POST
extern gmeTvb TVBEXP forChgRead;          // FDEF_CHG_READ
extern gmeTvb TVBEXP forChgUL;            // FDEF_CHG_UL
extern gmeTvb TVBEXP forChgDL;            // FDEF_CHG_DL
extern gmeTvb TVBEXP forChgULk;           // FDEF_CHG_ULK
extern gmeTvb TVBEXP forChgDLk;           // FDEF_CHG_DLK
extern gmeTvb TVBEXP forCrtDateUSALong;   // FDEF_CDAT_USL
extern gmeTvb TVBEXP forCrtDateUSAShort;  // FDEF_CDAT_USS
extern gmeTvb TVBEXP forCrtDateEurLong;   // FDEF_CDAT_EUL
extern gmeTvb TVBEXP forCrtDateEurShort;  // FDEF_CDAT_EUS
extern gmeTvb TVBEXP forCrtDateYearLong;  // FDEF_CDAT_YL
extern gmeTvb TVBEXP forCrtDateYearShort; // FDEF_CDAT_YS
extern gmeTvb TVBEXP forCrtDateMonthLong; // FDEF_CDATE_ML
extern gmeTvb TVBEXP forCrtDateMonthShort;// FDEF_CDAT_MS
extern gmeTvb TVBEXP forCrtDateMonthNum;  // FDEF_CDAT_MN
extern gmeTvb TVBEXP forCrtDateMonthNumPadded; // FDEF_CDAT_MN0
extern gmeTvb TVBEXP forCrtDateDayNum;    // FDEF_CDAT_D
extern gmeTvb TVBEXP forCrtDateDayNumPadded;   // FDEF_CDAT_D0
extern gmeTvb TVBEXP forCrtDateDayLong;   // FDEF_CDAT_WL
extern gmeTvb TVBEXP forCrtDateDayShort;  // FDEF_CDAT_WS
extern gmeTvb TVBEXP forInQScan;          // FDEF_INQSCAN
extern gmeTvb TVBEXP forInQScanCH;          // FDEF_INQSCANCH
extern gmeTvb TVBEXP forUsrAccess;           // FDEF_USRACCESS


extern gmeTvb TVBEXP curforID;               // FCUR_FORID
extern gmeTvb TVBEXP curforName;             // FCUR_FORNAME
extern gmeTvb TVBEXP curforNameU;            // FCUR_FORNAME_U
extern gmeTvb TVBEXP curforTopic;            // FCUR_TOPIC
extern gmeTvb TVBEXP curforOP;               // FCUR_FOROP
extern gmeTvb TVBEXP curforThreads;          // FCUR_THRS
extern gmeTvb TVBEXP curforMessages;         // FCUR_MSGS
extern gmeTvb TVBEXP curforFiles;            // FCUR_FILES
extern gmeTvb TVBEXP curforFilesWaiting;     // FCUR_FILES_WAIT
extern gmeTvb TVBEXP curforMsgLife;          // FCUR_MSGLIFE
extern gmeTvb TVBEXP curforChgPost;          // FCUR_CHG_POST
extern gmeTvb TVBEXP curforChgRead;          // FCUR_CHG_READ
extern gmeTvb TVBEXP curforChgUL;            // FCUR_CHG_UL
extern gmeTvb TVBEXP curforChgDL;            // FCUR_CHG_DL
extern gmeTvb TVBEXP curforChgULk;           // FCUR_CHG_ULK
extern gmeTvb TVBEXP curforChgDLk;           // FCUR_CHG_DLK
extern gmeTvb TVBEXP curforCrtDateUSALong;   // FCUR_CDAT_USL
extern gmeTvb TVBEXP curforCrtDateUSAShort;  // FCUR_CDAT_USS
extern gmeTvb TVBEXP curforCrtDateEurLong;   // FCUR_CDAT_EUL
extern gmeTvb TVBEXP curforCrtDateEurShort;  // FCUR_CDAT_EUS
extern gmeTvb TVBEXP curforCrtDateYearLong;  // FCUR_CDAT_YL
extern gmeTvb TVBEXP curforCrtDateYearShort; // FCUR_CDAT_YS
extern gmeTvb TVBEXP curforCrtDateMonthLong; // FCUR_CDATE_ML
extern gmeTvb TVBEXP curforCrtDateMonthShort;// FCUR_CDAT_MS
extern gmeTvb TVBEXP curforCrtDateMonthNum;  // FCUR_CDAT_MN
extern gmeTvb TVBEXP curforCrtDateMonthNumPadded; // FCUR_CDAT_MN0
extern gmeTvb TVBEXP curforCrtDateDayNum;    // FCUR_CDAT_D
extern gmeTvb TVBEXP curforCrtDateDayNumPadded;   // FCUR_CDAT_D0
extern gmeTvb TVBEXP curforCrtDateDayLong;   // FCUR_CDAT_WL
extern gmeTvb TVBEXP curforCrtDateDayShort;  // FCUR_CDAT_WS
extern gmeTvb TVBEXP curforInQScan;          // FCUR_INQSCAN
extern gmeTvb TVBEXP curforInQScanCH;          // FCUR_INQSCANCH
extern gmeTvb TVBEXP curforUsrAccess;           // FCU_USRACCESS



extern gmeTvb TVBEXP forQuotePref;           // FPREF_QUOTE
extern gmeTvb TVBEXP forReflowPref;          // FPREF_REFLOW
extern gmeTvb TVBEXP forType;                // FPREF_TYPE
extern gmeTvb TVBEXP forTypeHTML;            // FPREF_TYPE_HTML
extern gmeTvb TVBEXP forTypeJava;            // FPREF_TYPE_JAVA

extern gmeTvb TVBEXP forTarget1;             // FOR_TARGET_1
extern gmeTvb TVBEXP forTarget2;             // FOR_TARGET_2
extern gmeTvb TVBEXP forTarget3;             // FOR_TARGET_3
extern gmeTvb TVBEXP forTarget4;             // FOR_TARGET_4
extern gmeTvb TVBEXP forTarget5;             // FOR_TARGET_5
extern gmeTvb TVBEXP forTarget6;             // FOR_TARGET_6
extern gmeTvb TVBEXP forTarget7;             // FOR_TARGET_7
extern gmeTvb TVBEXP forTarget8;             // FOR_TARGET_8
extern gmeTvb TVBEXP forTarget9;             // FOR_TARGET_9


GBOOL EXPORT
setForumDefByID(            // set up forum definition Tvb by fid
USHORT fmid);                      // fid to setup

GBOOL EXPORT
setForumDefByName(          // set up forum definition Tvb by forum name
const CHAR* name);          // forum name

VOID EXPORT
setInQScanVar(              // set inqscan text variable
const CHAR* forum,          // forum to check
const CHAR* userid);        // user to check

GBOOL EXPORT
setCurForumDefByID(            // set up forum definition Tvb by fid
USHORT fmid);                      // fid to setup

GBOOL EXPORT
setCurForumDefByName(          // set up forum definition Tvb by forum name
const CHAR* name);          // forum name

VOID EXPORT
setCurForInQScanVar(              // set inqscan text variable
const CHAR* forum,          // forum to check
const CHAR* userid);        // user to check

VOID EXPORT
setAuthorVar(               // set the Author variable value
const CHAR* userid,         // user to
const CHAR* msgfrom);       // user from

VOID EXPORT
clearAllDefs();             // clears all tvb values

VOID EXPORT
setForTargetTvb(            // set form target tvb values
GBOOL useframes);


VOID EXPORT
setDnfTemplateTvb(          // setup the DNF_TEMPLATE TVB
const dnfHandler* dnf);     // dnf to get map from (if NULL, tvb is cleared)

#endif // __GMETVBAH_H
