/****************************************************************************
 *                                                                          *
 *  EFCOMMON.H                                                              *
 *                                                                          *
 *  Common Email/Forum Functions.                                           *
 *                                                                          *
 *                                                                          *
 *                                                      - NC Osterc 6/11/98 *
 *                                                                          *
 ****************************************************************************/

#ifndef __EFCOMMON_H
#define __EFCOMMON_H

#define MAXINPSIZ        1024
#define FMT_L            1         // long lowercase
#define FMT_LP           2         // long lowercase w periods
#define FMT_S            3         // short lowercase
#define FMT_LC           4         // uppercase long
#define FMT_LPC          5         // uppercase long w/ periods
#define FMT_SC           6         // short uppercase

#define OP_VALIDATION    0         // validate error code
#define OP_GENERIC       1         // generic error code

// bit flags for web-type prefs
#define EPREF_TYPE_HTML  0x00000001     // HTML is preferred for email
#define EPREF_TYPE_JAVA  0x00000002     // Java is preferred for email
#define EPREF_USEFRAMES  0x00000004     // Email should use frames
#define MPREF_REFLOW     0x00000008     // Email messages should reflow
#define MPREF_QUOTE      0X00000010     // Use quoting when responding to email
#define MPREF_INCLIST    0x00000020     // Include CC list in body
#define EPREF_NOFRAMES   0x00000040     // indicates user has no preference to frames

#define FPREF_TYPE_HTML  0x00010000     // HTML is preferred for forums
#define FPREF_TYPE_JAVA  0x00020000     // Java is prefererred for forums
#define FPREF_USEFRAMES  0x00040000     // Forums should use frames
#define FPREF_REFLOW     0x00080000     // Forum messages should reflow
#define FPREF_QUOTE      0x00100000     // Use quoting when responding in forums

#define AHMODNAME        "AH Messaging"

struct webPrefs2Disk {             //   on-disk page info (for gen db)
     CHAR userid[UIDSIZ];          //   userid in question
     CHAR modnam[MNMSIZ];          //   module name ("AH Messaging")
     LONG flags;                   //   flags are stored within
};

const CHAR* EXPORT                 // returned formatted meridiem
formatMeridiem(                    // format Meridiem as desired
unsigned time,                     // the time to work with
SHORT type);                       // type of formatting to be done

const CHAR * EXPORT                //   encoded string
cgiEncode(                         // encode a string for CGI "safety"
const CHAR* str);                  //   original string

const CHAR * EXPORT                //   encoded string
cgiDecode(                         // encode a string for CGI "safety"
const CHAR* str);                  //   original string

const CHAR* EXPORT                 // to address with mailto: pre-pended
mailToAddr(                        // convert to address to mailto:<Addr>
const CHAR* address);              // the address to convert

const CHAR* EXPORT                 // history w/ parens
historyParens(                     // convert history to (history)
const CHAR* history);              // history to convert

const CHAR* EXPORT                 // returns error message or NULL
gmeErrorHandler(                   // handle and error code
INT code,                          // the actual error code
INT operation,                     // type of operation
ostream *stream);                  // stream to ooutput to or NULL

const CHAR * EXPORT                //   returns pointer to destination buf
AddComment(                        // add comments to message text
const CHAR *txt,                   //   buffer containing text
const CHAR *cmt,                   //   buffer containing comments
CHAR *buf,                         //   destination buffer
size_t bufLength,                  //   length of buffer
const CHAR *userid);               //   userid of person making comment

LONG EXPORT                        // returns LONG w/ bit flags
getWebPrefs(                       // get stored preferences
const CHAR* user);                 // userid to get prefs for

VOID EXPORT
setWebPrefs(                       // set web prefs on disk
const CHAR* user,                  // user to set prefs for
LONG flags);                       // variable containing set bit flags

const CHAR* EXPORT                 //   pointer to internal buffer
formatMessage(                     // format a message to output
const CHAR* msg,                   //   message to format
GBOOL reflow,                      //   should the message be reflowed?
GBOOL plaintext);                  //   suppress HTML formatting

const CHAR* EXPORT                 //   linked string
formatURLs(                        // parse URLs, and create links
const CHAR* msg,                   //   text to check for URLS
const CHAR* anchor);               //   anchor tag to use for linking

const CHAR * EXPORT
getCCAddresses(                    // roots through text and grabs cc addrs
const CHAR* text,                  // text to search
INT sizeofText,                    // size of text
const CHAR *userWritingMsg);       // user writing message

GBOOL EXPORT
pfnerr(                            /* is string too profane?               */
const CHAR* usr,                   /*   userid to check                    */
CHAR *str,                         /*   string to check                    */
USHORT forum);                     /*   forum to use for profanity level   */

#endif // __EFCOMMON_H
