/***************************************************************************
 *   AHUSRXRF.H                                                            *
 *                                                                         *
 *   Copyright (c) 1997,1998  Galacticomm, Inc.    All Rights Reserved.    *
 *                                                                         *
 *   Active HTML User Cross-Reference API Definition                       *
 *                                                                         *
 *                                                  2/14/97 - Phil Henning *
 *                                                                         *
 ***************************************************************************/

#ifndef __AHUSRXRF_H
#define __AHUSRXRF_H

const INT AHMAXRF=25;                   // max number of matches if
                                        // not specified

EXPWGSV(DFAFILE*) xrfbb;                // user cross-reference data file
typedef struct uidxrf UIDXRF;

class acthUserXrf {                     // Active HTML User Xrf Class
public:
     acthUserXrf(                       // constructor
     const CHAR* uid,                   //  User-ID to find
     INT max);                          //  maximium number of matches

     acthUserXrf(                       // constructor
     const CHAR* uid);                  //  User-ID to find

     ~acthUserXrf();                    // destructor

     LONG
     getabs() const;                    // get current position

     LONG                               //  old position
     setabs(                            // set current position
     LONG pos);                         //  new position

     CHAR*
     getcurrent();                      // get current uid at the pos

     CHAR *                             // full User-ID of possible match
     getmatch();                        //  Get a possible match

     GBOOL
     ismatch();                         // User-ID passed in was EXACT match

     USHORT
     nmatches();                        // Number of possible matches

private:
     VOID
     InitXrf(                           // Internal initalization
     const CHAR* uid,                   //  User-ID to find
     INT numxrf);                       //  maximium number of matches

     INT m_num;                         // number of matches found
     INT m_maxrf;                       // maxium number of matches to find
     LONG m_abspos;                     // xrfdb absolute position
     CHAR m_xrf[XRFSIZ+1];              // User-ID to find
     CHAR* m_retuid;                    // possible match
     UIDXRF m_tmpxrf;                   // temp xref structure
     UIDXRF m_ahxrf;                    // xref structure
     bool m_notset;                     // flag to check it abspos was set
};
#endif // __AHUSRXRF_H
