/***************************************************************************
 *   AHUSRXRF.CPP                                                          *
 *                                                                         *
 *   Copyright (c) 1997,1998  Galacticomm, Inc.    All Rights Reserved.    *
 *                                                                         *
 *   Active HTML User Cross-Reference API                                  *
 *   Implementation                                                        *
 *                                                  2/14/97 - Phil Henning *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "ahusrxrf.h"

acthUserXrf::acthUserXrf(
const CHAR* uid,
INT max)
{
     InitXrf(uid, max);
}

acthUserXrf::acthUserXrf(
const CHAR* uid)
{
     InitXrf(uid, AHMAXRF);
}

acthUserXrf::~acthUserXrf()
{
}

VOID
acthUserXrf::InitXrf(
const CHAR* uid,
INT numxrf)
{
     m_maxrf=numxrf;
     stzcpy(m_xrf,uid,XRFSIZ+1);
     m_num=0;
     m_abspos=0L;
     m_notset=true;
}

GBOOL
acthUserXrf::ismatch()
{
     GBOOL retval;

     dfaSetBlk(xrfbb);
     retval=dfaQueryEQ(m_xrf,0);
     dfaRstBlk();
     return(retval);
}

LONG
acthUserXrf::getabs() const
{
     return(m_abspos);
}

LONG
acthUserXrf::setabs(
LONG pos)
{
     LONG oldpos=m_abspos;
     m_abspos=pos;
     m_notset=false;
     return(oldpos);
}

CHAR*
acthUserXrf::getcurrent()
{
     dfaSetBlk(xrfbb);
     if (m_abspos == 0L || !dfaAcqAbs(&m_ahxrf,m_abspos,0)) {
          dfaRstBlk();
          return(NULL);
     }
     dfaRstBlk();
     return(m_retuid=m_ahxrf.userid);
}

CHAR*
acthUserXrf::getmatch()
{
     if (m_num == m_maxrf && m_maxrf !=0) {
          return(NULL);
     }
     dfaSetBlk(xrfbb);
     if (m_abspos == 0L) {
          setmem(&m_tmpxrf,sizeof(UIDXRF),0);
          if (!dfaAcqGE(&m_ahxrf,m_xrf,0)) {
               dfaRstBlk();
               return(NULL);
          }
     }
     else {
          if (!dfaAcqAbs(&m_ahxrf,m_abspos,0) || !dfaQueryNX()) {
               dfaRstBlk();
               return(NULL);
          }
          if (m_notset) {
               memmove(&m_tmpxrf,&m_ahxrf,sizeof(UIDXRF));
               memmove(&m_ahxrf,xrfbb->data,sizeof(UIDXRF));
          }
          m_notset=true;
     }
     if (sameto(m_xrf,m_ahxrf.xrfstg) && !sameas(m_ahxrf.userid,m_tmpxrf.userid)) {
          m_abspos=dfaAbs();
          ++m_num;
          dfaRstBlk();
          return(m_retuid=m_ahxrf.userid);
     }
     dfaRstBlk();
     return(NULL);
}

USHORT
acthUserXrf::nmatches()
{
     USHORT nmatch=0;

     dfaSetBlk(xrfbb);
     setmem(&m_tmpxrf,sizeof(UIDXRF),0);
     if (dfaAcqGE(&m_ahxrf,m_xrf,0)) {
          do {
               if (sameto(m_xrf,m_ahxrf.xrfstg)
                  && !sameas(m_ahxrf.userid,m_tmpxrf.userid)) {
                    ++nmatch;
               }
               else {
                    break;
               }
               if (!dfaQueryNX()) {
                    break;
               }
               memmove(&m_tmpxrf,&m_ahxrf,sizeof(UIDXRF));
               memmove(&m_ahxrf,xrfbb->data,sizeof(UIDXRF));
          } while ((nmatch < m_maxrf || m_maxrf == 0));
     }
     dfaRstBlk();
     return(nmatch);
}
