/***************************************************************************
 *                                                                         *
 *   WGSUEXT.C                                                             *
 *                                                                         *
 *   Copyright (c) 2002 HSI Software, Inc.  All Rights Reserved            *
 *                                                                         *
 *   This module manages the user account extension table WGSUEXT.DAT      *
 *                                                                         *
 *                                                - J. Alvrus  7/23/2002   *
 *                                                                         *
 ***************************************************************************/
     
#include "gcomm.h"
#include "majorbbs.h"
#include "wgsuext.h"

#define FILREV "$Revision$"

DFAFILE * dfaUserExt=NULL;         /* user account extension database      */
GBOOL isInitialized=FALSE;         /* has DLL been initialized yet?        */

struct dfaSegSpec uextUidKey[]={
     {fldoff(uaccext,userid),UIDSIZ,DFAST_ZSTRING,DFASF_ALTCOLLATE,0}
};

struct dfaSegSpec uextEmlKey[]={
     {fldoff(uaccext,alteml),ALTEMLSIZ,DFAST_ZSTRING,DFASF_ALTCOLLATE,0}
};

struct dfaKeySpec uextKeys[]={
     {0,nelems(uextUidKey),uextUidKey},
     {DFAKF_DUPLICATE|DFAKF_MODIFYABLE,nelems(uextEmlKey),uextEmlKey}
};

VOID
init__wgsuext(VOID)                /* initialize DLL                       */
{
     if (isInitialized) {
          return;
     }
     isInitialized=TRUE;
     if (!isfile(UACCEXTDAT)) {
          dfaCreateSpec(UACCEXTDAT,FALSE,sizeof(struct uaccext),4096,
                        0,0,nelems(uextKeys),uextKeys,"GALCAPS.ALT");
     }
     dfaUserExt=dfaOpen(UACCEXTDAT,sizeof(struct uaccext),NULL);
}

VOID EXPORT
initwc__wgsuext(VOID)              /* initialize for WebCast, just in case */
{
     init__wgsuext();
}

