/***************************************************************************
 *                                                                         *
 *   EDITFSE.H                                                             *
 *                                                                         *
 *   Copyright (c) 1988-1997 Galacticomm, Inc.  All Rights Reserved.       *
 *                                                                         *
 *   This is the Full Screen/Line Editor module's internal header file.    *
 *                                                                         *
 *          Modifications for 6.0 - R. A. Rose 4/6/92                      *
 *             Full Screen Editor - R. A. Rose 11/9/90                     *
 *                                                                         *
 ***************************************************************************/

#ifndef __EDITFSE_H
#define __EDITFSE_H

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

extern
struct fseusr {
     INT signat;                   /* User-ID Signature                    */
     CHAR *topic;                  /* Pointer to topic buffer              */
     INT tpcsiz;                   /* Max size of topic field              */
     CHAR *txtbuf;                 /* pointer to text buffer               */
     INT txtsiz;                   /* size of current allowable text buffer*/
     INT flags;                    /* misc. editor use flags               */
     INT scnlen;                   /* screen height for full screen editor */
     INT pfnlvl;                   /* profanity level for user in effect   */
     INT (*imradr)(LONG);          /* ptr to import-message routine in eff */
     CHAR *topscr;                 /* ptr to top of screen (in memory)     */
     CHAR *begstg;                 /* start of current line being edited   */
     CHAR *endstg;                 /* pointer to first unused line         */
     CHAR *mkstart;                /* start of marked block                */
     CHAR *mkend;                  /* end of marked block                  */
     CHAR *endbuf;                 /* pointer to the zero at end of buffer */
     CHAR *tmpptr;                 /* temporary position holder pointer    */
     INT x;                        /* Cursor X position (counting from 1)  */
     INT y;                        /* Cursor Y position (counting from 1)  */
     INT substt;                   /* Last fsechi state                    */
     INT ech2go;                   /* Amount of echo buffer left           */
     INT stacnt;                   /* Number of Status 3s in the buffer    */
     INT termtyp;                  /* Terminal Type                        */
     INT winstar;                  /* Window starting y                    */
     INT winheig;                  /* Window height                        */
     INT cmd;                      /* BTUCHI to Real Commands              */
     INT txtlen;                   /* cumulative len current text buffer   */
     INT nlines;                   /* number of lines processed            */
                                   /* FSE: nlines=number of chars in line  */
     INT curlin;                   /* line currently being edited          */
     INT rpclen;                   /* length of line to replace            */
                                   /* FSE: command after TAKONE & LINMOD   */
     INT crllen;                   /* target line length                   */
     SHORT (*exitro)(SHORT);       /* ptr to exit/quit routine in effect   */
     INT rflags;                   /* pointer to return flags              */
     CHAR tmpbuf[80];              /* Temporary buffer for each user       */
} *fsecpt;                         /* pointer to current fsechi users data */

VOID chiscon(INT chan);
VOID chimvcl(CHAR *src,CHAR *dst,register INT cnt);
VOID chirmov(CHAR *src,CHAR *dst,register INT cnt);
VOID chiouc(INT btchn,CHAR *stg,INT cnt);
VOID chinum(INT btchn,INT val);

VOID clsedt(VOID);
VOID fse_edtimr(GBOOL (*imradr)());
VOID fse_edtpfn(INT pfnlvl);
INT fse_inedit(INT usn,SHORT (*exipnt)(SHORT));
INT fse_bgnedt(INT siz,CHAR *buf,INT tsiz,CHAR *topic,SHORT (*whndun)(SHORT),
            INT flags);
INT stfse(INT siz,CHAR *buf,INT tsiz,CHAR *topic);
INT stline(INT siz,CHAR *buf,INT tsiz,CHAR *topic);
INT dunedt(VOID);
INT worlen(CHAR *ptr);
GBOOL fsepage(VOID);
VOID fsehup(VOID);
CHAR fsechi(INT chan,INT c);
GBOOL ldunedt(VOID);
VOID rtfedt(VOID);
VOID rststf(VOID);
VOID edtmnu(VOID);
VOID edtpmt(VOID);
VOID hlpmnu(VOID);
INT procln(VOID);
INT morspc(VOID);
INT hdlecm(VOID);
VOID bgnmsg(VOID);
VOID bgntpc(VOID);
VOID hdlhcm(VOID);
VOID rplcwt(VOID);
CHAR *inword(CHAR *stg1,CHAR *stg2);
VOID dellin(VOID);
INT chk4nl(INT msg,LONG parm);
VOID apndtx(VOID);
VOID insttx(VOID);
VOID lstlns(INT shwlines);
VOID extlin(VOID);
INT vldlin(INT msg);
VOID rplctx(VOID);
VOID rstrln(VOID);
VOID strtov(INT siz,CHAR *buf,INT tsiz,CHAR *topic);
INT msgtpc(VOID);
INT edttpc(VOID);
INT uplmsg(CHAR *afile,INT flags);

#ifdef __cplusplus
}; // extern "C"
#endif // __cplusplus

#endif                             /*  __EDITFSE_H                         */
