/***************************************************************************
 *                                                                         *
 *   EDITASM.C                                                             *
 *                                                                         *
 *   Copyright (c) 1988-1997 Galacticomm, Inc.  All Rights Reserved.       *
 *                                                                         *
 *   This is the Full Screen/Line Editor module's assembly source module.  *
 *                                                                         *
 *          Modifications for 6.0 - R. A. Rose 4/6/92                      *
 *             Full Screen Editor - R. A. Rose 11/9/90                     *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "editfse.h"

#define FILREV "$Revision: 4 $"

#define ICRPOS (fsecpt->begstg+(fsecpt->x)-1)

VOID
chiscon(                           /* Display from cursor on to EOL        */
INT chan)
{
     register INT i;

     for (i=80 ; i >= fsecpt->x ; i--) {
          if (fsecpt->begstg[i-1] != ' ') {
               break;
          }
     }
     chiouc(chan,ICRPOS,i-fsecpt->x+1);
     if (i != 80) {
          chious(chan,"\33[0K");
     }
     chious(chan,"\33[");
     chinum(chan,fsecpt->y);
     chious(chan,";");
     chinum(chan,fsecpt->x);
     chious(chan,"f");
}

VOID
chimvcl(                           /* Move memory with source clear        */
CHAR *src,
CHAR *dst,
register INT cnt)
{
     register INT i;

     for (i=0 ; i < cnt ; i++) {
          dst[i]=src[i];
          src[i]=' ';
     }
}

VOID
chirmov(                           /* Move Memory with no clear            */
CHAR *src,
CHAR *dst,
register INT cnt)
{
     register INT i;

     for (i=0 ; i < cnt ; i++) {
          dst[i]=src[i];
     }
}

VOID
chiouc(                            /* Output a string by count             */
register INT btchn,
CHAR *stg,
register INT cnt)
{
     register INT i;

     for (i=0 ; i < cnt ; i++) {
          chiout(btchn,stg[i]);
     }
}

VOID
chinum(                            /* Chiout a numeric value (0-99)        */
register INT btchn,
register INT val)
{
     static CHAR buf[]="00";

     buf[0]='0'+(val/10);
     buf[1]='0'+(val%10);
     chious(btchn,buf+(val > 9 ? 0 : 1));
}
