/***************************************************************************
 *                                                                         *
 *   LERRTEXT.C                                                            *
 *                                                                         *
 *   Copyright (c) 1996-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   Get last error text when Win32 API call failed.                       *
 *                                                                         *
 *                                                - I. Minkin 5/22/96      *
 *                                                                         *
 ***************************************************************************/

#include <windows.h>
#include "gcomm.h"

#define FILREV "$Revision: 3 $"

CHAR *                             //   return error message
getErrorText(                      // converts "Lasr Error" code into text
ULONG errorCode,                   //   error code
CHAR *pBuf,                        //   message buffer
ULONG bufSize)                     //   buffer size
{
     DWORD ret;
     LPTSTR pTemp=NULL;

     if (bufSize < 16) {
          if (bufSize > 0) {
               pBuf[0]='\0';
          }
          return(pBuf);
     }
     ret=FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER|
                       FORMAT_MESSAGE_FROM_SYSTEM|
                       FORMAT_MESSAGE_ARGUMENT_ARRAY,
                       NULL,
                       errorCode,
                       LANG_NEUTRAL,
                       (LPTSTR)&pTemp,
                       0,
                       NULL );
     if (!ret || pTemp == NULL) {
          pBuf[0]='\0';
     }
     else {
          pTemp[strlen(pTemp)-2]='\0'; //remove cr and newline character
          sprintf(pBuf,"%0.*s (0x%x)",bufSize-16,pTemp,errorCode);
          LocalFree((HLOCAL)pTemp);
     }
     return(pBuf);
}

CHAR *                             //   return error message
getLastErrorText(                  // converts "Lasr Error" code into text
CHAR *pBuf,                        //   message buffer
ULONG bufSize)                     //   buffer size
{
     return(getErrorText(GetLastError(),pBuf,bufSize));
}
