/***************************************************************************
 *                                                                         *
 *   ELOGAPI.C                                                             *
 *                                                                         *
 *   Copyright (c) 1996-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   Functions for adding events into the Event Log (NT only)              *
 *                                                                         *
 *                                                - I. Minkin 5/22/96      *
 *                                                                         *
 ***************************************************************************/

#include <windows.h>
#include "gcomm.h"
#include "wgsmsgs.h"
#include "elogapi.h"

static const CHAR *pCurrServName=NULL;
static const CHAR *pCurrServDispName=NULL;

static CHAR *getLastErrorText(CHAR *pBuf,ULONG bufSize);

VOID
elogSetServName(                   // set current source for events
const CHAR *pServName)             //   source name
{
     pCurrServName=pServName;
}

VOID
elogSetServDispName(               // set cur service name to display in ELog
const CHAR *pServDispName)         //   service display name
{
     pCurrServDispName=pServDispName;
}

VOID
elogAPIError(                      // log an API error into the Event Log
const CHAR *pMsg)                  //   additional message to log
{
     CHAR msgText[256];
     const CHAR *pStrings[3];

     if (pCurrServName == NULL) {
          return;
     }
     getLastErrorText(msgText,sizeof(msgText));
     pStrings[0]=pCurrServDispName;
     if (pStrings[0] == NULL) {
          pStrings[0]="";
     }
     pStrings[1]=pMsg;
     pStrings[2]=msgText;
     elogStatus(ELOG_SERVICE_FAILED,pStrings,3);
}

VOID
elogStatus(                        // log status into the Event Log
ULONG status,                      //   status to log
const CHAR **pInsertStg,           //   insert strings
INT numInserts)                    //   number of insert strings
{
     elogStatusEx(status,pInsertStg,numInserts,pCurrServName);
}

VOID
elogStatusEx(                      // log status into the Event Log
ULONG status,                      //   status to log
const CHAR **pInsertStg,           //   insert strings
INT numInserts,                    //   number of insert strings
const CHAR *pSourceName)           //   source name
{
     HANDLE hEventSource;
     WORD eventType;

     if (pSourceName == NULL) {
          return;
     }
     switch ((status&SEV_MASK) >> 30) {
     case STATUS_SEVERITY_INFORMATIONAL:
          eventType=EVENTLOG_INFORMATION_TYPE;
          break;
     case STATUS_SEVERITY_WARNING:
          eventType=EVENTLOG_WARNING_TYPE;
          break;
     case STATUS_SEVERITY_ERROR:
          eventType=EVENTLOG_ERROR_TYPE;
          break;
     default:
          eventType = EVENTLOG_ERROR_TYPE;
     }
     if ((hEventSource=RegisterEventSource(NULL,pSourceName)) != NULL) {
          ReportEvent(hEventSource,               // handle of event source
                      eventType,                  // event type
                      0,                          // event category
                      status,                     // event ID
                      NULL,                       // current user's SID
                      (WORD)numInserts,                 // number of insert strings
                      0,                          // no bytes of raw data
                      pInsertStg,                 // array of insert strings
                      NULL);                      // no raw data
          DeregisterEventSource(hEventSource);
     }
}

static CHAR *                      //   return error message
getLastErrorText(                  // converts "Lasr Error" code into text
CHAR *pBuf,                        //   message buffer
ULONG bufSize)                     //   buffer size
{
     DWORD retSize;
     LPTSTR pTemp=NULL;

     if (bufSize < 16) {
          if (bufSize > 0) {
               pBuf[0]='\0';
          }
          return(pBuf);
     }
     retSize=FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER|
                           FORMAT_MESSAGE_FROM_SYSTEM|
                           FORMAT_MESSAGE_ARGUMENT_ARRAY,
                           NULL,
                           GetLastError(),
                           LANG_NEUTRAL,
                           (LPTSTR)&pTemp,
                           0,
                           NULL );
     if (!retSize || pTemp == NULL) {
          pBuf[0]='\0';
     }
     else {
          pTemp[strlen(pTemp)-2]='\0'; //remove cr and newline character
          sprintf(pBuf,"%0.*s (0x%x)",bufSize-16,pTemp,GetLastError());
          LocalFree((HLOCAL)pTemp);
     }
     return(pBuf);
}
