/***************************************************************************
 *                                                                         *
 *   CANRUN.C                                                              *
 *                                                                         *
 *   Copyright (c) 1996-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   Detect is WGSERVER is running.                                        *
 *                                                                         *
 *                                        - Ilya Minkin 01/26/96           *
 *                                                                         *
 ***************************************************************************/

#include <windows.h>
#include "gcomm.h"

#define FILREV "$Revision: 8 $"

static GBOOL giveAllAccess(HANDLE hEvent);

static const CHAR *eventWGS="/EVENT/WGSERVER/WGS_RUNNING";
static const CHAR *eventGroup="/EVENT/WGSERVER/GROUP_RUNNING";
static const CHAR *eventUtil="/EVENT/WGSERVER/UTIL_RUNNING";
static const CHAR *eventWGSINT="/EVENT/WGSERVER/WGSINT_RUNNING";
static const CHAR *eventCnf="/EVENT/WGSERVER/WGSCNF_RUNNING";

static HANDLE wgsIntEvent = NULL;

GBOOL                              //   return TRUE - can run the program
canRunWGS(VOID)                    // can run WGSERVER.EXE
{
     HANDLE hEvent;

     hEvent=OpenEvent(EVENT_ALL_ACCESS,FALSE,eventGroup);
     if (hEvent != NULL) {
          CloseHandle(hEvent);
          return(FALSE);
     }
     hEvent=OpenEvent(EVENT_ALL_ACCESS,FALSE,eventUtil);
     if (hEvent != NULL) {
          CloseHandle(hEvent);
          return(FALSE);
     }
     hEvent=CreateEvent(NULL,FALSE,FALSE,eventWGS);
     if (hEvent == NULL) {
          return(FALSE);
     }
     else if (GetLastError() == ERROR_ALREADY_EXISTS) {
          CloseHandle(hEvent);
          return(FALSE);
     }
     // give full access to Event so even if WGS runs as a service on another
     // account it can be used
     if (!giveAllAccess(hEvent)) {
          CloseHandle(hEvent);
          return(FALSE);
     }
     return(TRUE);
}

GBOOL                              //   return TRUE - can run the program
canRunGroup(VOID)                  // can run "group" exe (former .BAT)
{
     HANDLE hEvent;

     hEvent=OpenEvent(EVENT_ALL_ACCESS,FALSE,eventWGS);
     if (hEvent != NULL) {
          CloseHandle(hEvent);
          return(FALSE);
     }
     hEvent=OpenEvent(EVENT_ALL_ACCESS,FALSE,eventUtil);
     if (hEvent != NULL) {
          CloseHandle(hEvent);
          return(FALSE);
     }
     hEvent=CreateEvent(NULL,FALSE,FALSE,eventGroup);
     if (hEvent == NULL) {
          return(FALSE);
     }
     else if (GetLastError() == ERROR_ALREADY_EXISTS) {
          CloseHandle(hEvent);
          return(FALSE);
     }
     // give full access to Event so even if WGS runs as a service on another
     // account it can be used
     if (!giveAllAccess(hEvent)) {
          CloseHandle(hEvent);
          return(FALSE);
     }
     return(TRUE);
}

GBOOL                              //   return TRUE - can run the program
canRunUtil(VOID)                   // can run an offline utility
{
     HANDLE hEvent;

     hEvent=OpenEvent(EVENT_ALL_ACCESS,FALSE,eventWGS);
     if (hEvent != NULL) {
          CloseHandle(hEvent);
          return(FALSE);
     }
     hEvent=CreateEvent(NULL,FALSE,FALSE,eventUtil);
     if (hEvent == NULL) {
          return(FALSE);
     }
     else if (GetLastError() == ERROR_ALREADY_EXISTS) {
          CloseHandle(hEvent);
          return(FALSE);
     }
     // give full access to Event so even if WGS runs as a service on another
     // account it can be used
     if (!giveAllAccess(hEvent)) {
          CloseHandle(hEvent);
          return(FALSE);
     }
     return(TRUE);
}

GBOOL                              //   return TRUE - can run WGSCNF.EXE
canRunWGSCNF(VOID)                 // can run WGSCNF.EXE
{
     HANDLE hEvent;

     hEvent=CreateEvent(NULL,FALSE,FALSE,eventCnf);
     if (hEvent == NULL) {
          return(FALSE);
     }
     else if (GetLastError() == ERROR_ALREADY_EXISTS) {
          CloseHandle(hEvent);
          return(FALSE);
     }
     // give full access to Event so even if WGS runs as a service on another
     // account it can be used
     if (!giveAllAccess(hEvent)) {
          CloseHandle(hEvent);
          return(FALSE);
     }
     return(TRUE);
}


GBOOL                              //   return TRUE - can run WGSINT.EXE
canRunWGSINT(VOID)                 // can run WGSINT.EXE
{
     HANDLE hEvent;

     hEvent=OpenEvent(EVENT_ALL_ACCESS,FALSE,eventWGS);
     if (hEvent != NULL) {
          CloseHandle(hEvent);
          return(FALSE);
     }
     hEvent=OpenEvent(EVENT_ALL_ACCESS,FALSE,eventUtil);
     if (hEvent != NULL) {
          CloseHandle(hEvent);
          return(FALSE);
     }
     wgsIntEvent=CreateEvent(NULL,FALSE,FALSE,eventWGSINT);
     if (wgsIntEvent == NULL) {
          return(FALSE);
     }
     else if (GetLastError() == ERROR_ALREADY_EXISTS) {
          CloseHandle(wgsIntEvent);
          wgsIntEvent=NULL;
          return(FALSE);
     }
     // give full access to Event so even if WGS runs as a service on another
     // account it can be used
     if (!giveAllAccess(wgsIntEvent)) {
          CloseHandle(wgsIntEvent);
          wgsIntEvent=NULL;
          return(FALSE);
     }
     return(TRUE);
}

GBOOL                              //   return TRUE-Ok
allowWGSINT(VOID)                  // close WGSINT's event to allow it to run
{
     if (wgsIntEvent != NULL) {
          CloseHandle( wgsIntEvent );
          wgsIntEvent = NULL;
     }

     return( TRUE );
}

static GBOOL                       //   return TRUE-Ok
giveAllAccess(                     // gives unlimited access to handle
HANDLE hEvent)                     //   handle
{
     PSECURITY_DESCRIPTOR pSD;
     GBOOL retVal=TRUE;

     if (!isWinNT()) {
          return(TRUE);
     }
     pSD=(PSECURITY_DESCRIPTOR)LocalAlloc(LPTR,SECURITY_DESCRIPTOR_MIN_LENGTH);
     if (pSD == NULL) {
          retVal=FALSE;
     }
     if (retVal && !InitializeSecurityDescriptor(pSD,SECURITY_DESCRIPTOR_REVISION)) {
          retVal=FALSE;
     }
     // Add a NULL disc. ACL to the security descriptor.
     if (retVal && !SetSecurityDescriptorDacl(pSD,TRUE,(PACL)NULL,FALSE)) {
          retVal=FALSE;
     }
     if (retVal && !SetKernelObjectSecurity(hEvent,DACL_SECURITY_INFORMATION,pSD)) {
          retVal=FALSE;
     }
     if (!retVal && pSD != NULL) {
          LocalFree(pSD);
     }
     return(retVal);
}
