/***************************************************************************
 *                                                                         *
 *   MEMRPL.C                                                              *
 *                                                                         *
 *   Copyright (c) 1994-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the GCOMM.LIB routine for replacing all occurences of a       *
 *   specific byte in a memory block with another byte.  Replacement is    *
 *   done in-place.  The buffer passed is also returned.                   *
 *                                                                         *
 *                                           - J. Alvrus    10/01/1997     *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"

#define FILREV "$Revision: 1 $"

VOID *                             /*   returns ptr to buffer              */
memrpl(                            /* replace bytes in a buffer            */
VOID *buf,                         /*   buffer to do replacing in          */
CHAR oldByte,                      /*   byte to replace                    */
CHAR newByte,                      /*   new byte                           */
size_t bufSiz)                     /*   size of buffer                     */
{
     CHAR *p;

     for (p=(CHAR *)buf ; p < ((CHAR *)buf)+bufSiz ; ++p) {
          if (*p == oldByte) {
               *p=newByte;
          }
     }
     return(buf);
}
