/***************************************************************************
 *                                                                         *
 *   GMKTEMP.C                                                             *
 *                                                                         *
 *   Copyright (c) 1987-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the GCOMM.LIB routine for creating a temporary file.  This    *
 *   was created because the 32 bit Borland mktemp function only outputs   *
 *   26 unique file names in a given process.                              *
 *                                                                         *
 *                                            - W. Muharsky 1/29/99        *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"

#define FILREV "$Revision: 1 $"

#define TEMPSTG     "AA.AAA"       /*  Beginning string for templates      */
#define TEMPREQ     "XXXXXX"       /*  Required paramater on templates     */

VOID
FlipChar(                          /*  Flip characters in Template array   */
CHAR* Template,                    /*  Template to flip characters in      */
INT Slot);                         /*  Slot to flip the character in       */

MARKSOURCE(gmktemp);

CHAR*                              /*  Pointer to Template or NULL         */
gmktemp(                           /* Create temporary file                */
CHAR* Template)                    /*  Path to create file.  Ends "XXXXXX" */
{
     static CHAR MyTemp[]=TEMPSTG;
     CHAR OldTemp[sizeof(TEMPSTG)];
     CHAR* tmpptr;

     ASSERT(Template != NULL);
     if (Template == NULL
      || strlen(Template) < sizeof(MyTemp)
      || !samend(Template,TEMPREQ)) {
          return(NULL);
     }
     tmpptr=(Template+strlen(Template))-strlen(TEMPREQ);
     strcpy(OldTemp,MyTemp);
     while (TRUE) {
          strcpy(tmpptr,MyTemp);
          if (!isfile(Template)) {
               return(Template);
          }
          FlipChar(MyTemp,5);
          if (sameas(MyTemp,OldTemp)) {      /*  Cycled through everything */
               break;
          }
     }
     return(NULL);
}

VOID
FlipChar(                          /*  Flip characters in Template array   */
CHAR* Template,                    /*  Template to flip characters in      */
INT Slot)                          /*  Slot to flip the character in       */
{
     if (Template[Slot] == '.') {
          FlipChar(Template,Slot-1);
          return;
     }
     Template[Slot]++;
     if (Template[Slot] > 'Z') {
          Template[Slot]='A';
          if (Slot == 0) {                   /* Characters are Resetting   */
               return;
          }
          FlipChar(Template,Slot-1);
     }
}
