/***************************************************************************
 *                                                                         *
 *   XTOI.C                                                                *
 *                                                                         *
 *   Copyright (c) 1997      Galacticomm, Inc.      All Rights Reserved.   *
 *                                                                         *
 *   Hexadecimal string to integer and long values.                        *
 *                                                                         *
 *                                            - J. Delekto   12/10/97      *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"

INT                                //   Integer value to return
xtoi(                              // Convert Hex string to Integer
const CHAR* pszHex)                //   Hex string to convert
{
     INT            iTotal=0;
     const CHAR*    pszIndex;

     for (pszIndex=skptwht(pszHex); isxdigit(*pszIndex); pszIndex++) {
          iTotal<<=4;
          iTotal+=hexval(*pszIndex);
     }
     return(iTotal);
}

LONG                               //   Long value to return
xtol(                              // Convert Hex string to Long
const CHAR* pszHex)                //   Hex string to convert
{
     LONG           lTotal=0;
     const CHAR*    pszIndex;

     for (pszIndex=skptwht(pszHex); isxdigit(*pszIndex); pszIndex++) {
          lTotal<<=4;
          lTotal+=hexval(*pszIndex);
     }
     return(lTotal);
}
