/***************************************************************************
 *                                                                         *
 *   VALIDYN.C                                                             *
 *                                                                         *
 *   Copyright (c) 1987-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the GCOMM.LIB routine for use with edtval(), setting stg      *
 *   if c is a valid response to a yes/no prompt.                          *
 *                                                                         *
 *                                            - T. Stryker 2/3/92          *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"

#define FILREV "$Revision: 4 $"

GBOOL                              /*   always returns FALSE               */
validyn(                           /* validate c as yes/no (for edtval())  */
INT c,                             /*   character to check for 'y' or 'n'  */
CHAR *stg)                         /*   display string to put the new stg  */
{
     if (tolower(c) == 'y') {
          strcpy(stg,"Yes");
     }
     else if (tolower(c) == 'n') {
          strcpy(stg,"No");
     }
     else {
          strcpy(stg,(stg[0] == 'Y' ? "No" : "Yes"));
     }
     return(FALSE);
}
