/***************************************************************************
 *                                                                         *
 *   TFSCAN.C                                                              *
 *                                                                         *
 *   Copyright (c) 1993-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   Text file scanning routines.  May use wildcards, but you must stay    *
 *   in the current directory (no path prefixes)                           *
 *                                                                         *
 *                                    - Robert N. Stein 1/8/93             *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"

#define FILREV "$Revision: 5 $"

CHAR tfsbuf[MAXTFS];               /* line when tfsrdl() returns TFSLIN    */
CHAR *tfspst;                      /* buf after skpwht when tfspfx() rets 1*/

struct ffblk tfsfb;               /* ffblk structure from current file   */

FILE *tfsfp;                       /* file ptr when tfsrdl() rets TFSLIN   */

CHAR tfspth[GCMAXPTH],*namptr;     /* file path and pointer to name part   */

INT tfstate;                       /* tfsrdl() state code & return code    */

INT                                /*   returns number of files            */
tfsopn(                            /* prep to scan text file(s)            */
const CHAR *fname)                 /* may use wildcards, may use pth prefix*/
{
     SHORT nfiles=0;
     CHAR fptmp[GCMAXFNM];

     namptr=fileparts(GCPART_FNAM,stzcpy(tfspth,fname,sizeof(tfspth)),fptmp,
                      GCMAXFNM);
     namptr=&tfspth[strlen(tfspth)-strlen(namptr)];
     if (strlen(fname)+1 > sizeof(tfspth)
      || strlen(tfspth)-strlen(namptr)+8+1+3+1 > sizeof(tfspth)) {
          catastro("TFSCAN:  Path too long:\n\"%s\"",fname);
     }
     if (fnd1st(&tfsfb,fname,0)) {
          for (nfiles=1 ; fndnxt(&tfsfb) ; nfiles++) {
          }
          fnd1st(&tfsfb,fname,0);
          tfstate=TFSBGN;
     }
     else {
          tfstate=TFSDUN;
     }
     return(nfiles);
}

INT                                /*   rets 0=done non-0=still scanning   */
tfsrdl(VOID)                       /* read a line from the file(s)         */
{
     INT n;

     tfsbuf[0]='\0';
     switch (tfstate) {
     case TFSBGN:
          tfstate=TFSBOF;
          break;
     case TFSBOF:
          strcpy(namptr,tfsfb.ff_name);
          if ((tfsfp=fopen(tfspth,FOPRA)) == NULL) {
               catastro("TFSCAN: Cannot find \"%s\" file",tfspth);
          }
          tfstate=TFSLIN;
     case TFSLIN:
          if (fgets(tfsbuf,MAXTFS,tfsfp) != NULL) {
               if ((n=strlen(tfsbuf)) > 0 && tfsbuf[n-1] == '\n') {
                    tfsbuf[n-1]='\0';
               }
               depad(tfsbuf);
          }
          else {
               fclose(tfsfp);
               tfstate=TFSEOF;
          }
          break;
     case TFSEOF:
          tfstate=fndnxt(&tfsfb) ? TFSBOF : TFSDUN;
          break;
     }
     return(tfstate);
}

GBOOL                              /*   returns TRUE=prefix'd              */
tfspfx(                            /* is current line pfx'd with prefix stg*/
const CHAR *prefix)                /*   prefix to check for                */
{
     tfspst=NULL;
     if (sameto(prefix,tfsbuf)) {
          tfspst=skpwht(tfsbuf+strlen(prefix));
          return((*tfspst != '\0') ? TRUE : FALSE);
     }
     return(FALSE);
}

VOID
tfsdpr(VOID)                       /* after tfspfx() == 1,use "deeper" pfx */
{
     strcpy(tfsbuf,tfspst);
}

VOID
tfsabt(VOID)                       /* abort file scanning                  */
{
     if (tfstate == TFSLIN) {
          fclose(tfsfp);
     }
     tfstate=TFSDUN;
}
