/***************************************************************************
 *                                                                         *
 *   STRINS.C                                                              *
 *                                                                         *
 *   Copyright (c) 1995-1997 Galacticomm, Inc.  All Rights Reserved.       *
 *                                                                         *
 *   This is the GCOMM.LIB routine for inserting a string before another   *
 *   string.  The string passed is also returned.                          *
 *                                                                         *
 *   Example:  strins("good.","This is ",100) == "This is good."           *
 *                                                                         *
 *                                      - R. Stein & C. Robert 1/19/95     *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"

#define FILREV "$Revision: 4 $"

CHAR *                             /*   returns dststg                     */
strins(                            /* insert a string before another       */
CHAR *dststg,                      /*   original and destination string    */
CHAR *insstg,                      /*   string to insert                   */
INT sizdst)                        /*   room at dststg, including '\0'     */
{
     INT lenorg,lenins,roomorg;

     lenorg=strlen(dststg);
     lenins=strlen(insstg);
     roomorg=sizdst-lenins-1;
     if (roomorg <= 0) {
          stzcpy(dststg,insstg,sizdst);
     }
     else {
          if (lenorg > roomorg) {
               movmem(dststg,dststg+lenins,roomorg);
               dststg[sizdst-1]='\0';
          }
          else {
               movmem(dststg,dststg+lenins,lenorg+1);
          }
          movmem(insstg,dststg,lenins);
     }
     return(dststg);
}
