/***************************************************************************
 *                                                                         *
 *   STPANS.C                                                              *
 *                                                                         *
 *   Copyright (c) 1987-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the GCOMM.LIB routine for stripping ANSI from a string.       *
 *                                                                         *
 *                                                - S. Brinker 4/23/92     *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"

#define FILREV "$Revision: 4 $"

CHAR *                             /*   returns ptr to string              */
stpans(                            /* strip ANSI sequences from a string   */
CHAR *str)                         /*   string to strip ANSI from          */
{
     INT inansi=0,inifansi=0,zapdansi=0;
     CHAR *ansptr=NULL,*ifansptr=NULL;
     CHAR *orgstr;

     orgstr=str;
     while (1) {
          if (inifansi) {
               if (*str == '|' && !zapdansi) {
                    movmem(str+1,ifansptr,strlen(str+1)+1);
                    str=ifansptr;
                    zapdansi=1;
                    continue;
               }
               else if (*str == ']') {
                    if (zapdansi) {
                         movmem(str+1,str,strlen(str+1)+1);
                    }
                    else {
                         movmem(str+1,ifansptr,strlen(str+1)+1);
                         str=ifansptr;
                    }
                    inifansi=0;
                    continue;
               }
               else if (*str == '\n' || *str == '\r' || *str == '\0') {
                    inifansi=0;
                    if (!zapdansi) {
                         movmem(str,ifansptr,strlen(str)+1);
                         str=ifansptr;
                         continue;
                    }
               }
          }
          if (*str == '\0') {
               break;
          }
          if (inansi) {
               if (isalpha(*str)) {
                    inansi=0;
                    movmem(str+1,ansptr,strlen(str+1)+1);
                    str=ansptr;
                    continue;
               }
               else if (*str == '[') {
                    inansi=0;
               }
          }
          else if (*str == ESC && *(str+1) == '[') {
               if (*(str+2) == '[') {
                    inifansi=1;
                    zapdansi=0;
                    ifansptr=str;
               }
               else {
                    inansi=1;
                    ansptr=str;
               }
               str++;
          }
          str++;
     }
     return(orgstr);
}
