/***************************************************************************
 *                                                                         *
 *   STLCPY.C                                                              *
 *                                                                         *
 *   Copyright (c) 1987-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the GCOMM.LIB routine for copying a string with a maximum     *
 *   destination size limit.                                               *
 *                                                                         *
 *                                            - R. Stein   2/3/92          *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"

#define FILREV "$Revision: 5 $"

CHAR *                             /*   returns ptr to destination buffer  */
stlcpy(                            /* copy a string with limit             */
CHAR *dst,                         /*   destination buffer                 */
const CHAR *src,                   /*   source buffer                      */
UINT num)                          /*   # of bytes in dest, includes '\0'  */
{
     UINT i;
     CHAR *cp;

     for (i=0,cp=dst ; i < num-1 && *src != '\0' ; i++) {
          *cp++=*src++;
     }
     *cp='\0';
     return(dst);
}

CHAR *                             /*   returns ptr to destination buffer  */
stlcat(                            /* concatenate on a string, with limits */
CHAR *dst,                         /*   destination buffer                 */
const CHAR *src,                   /*   source buffer                      */
UINT num)                          /*   # of bytes in dest, includes '\0'  */
{
     UINT dstlen;

     dstlen=strlen(dst);
     stlcpy(&dst[dstlen],src,num-dstlen);
     return(dst);
}
