/***************************************************************************
 *                                                                         *
 *   SETCRIT.C                                                             *
 *                                                                         *
 *   Copyright (c) 1992-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the GCOMM.LIB routine for setting the critical error vector   *
 *   to a friendly pop-up-window based handler.                            *
 *                                                                         *
 *   (Not designed to work under Phar Lap.)                                *
 *                                                                         *
 *                                        - T. Stryker 6/24/86             *
 *                    v6.0 enhancements   - C. Robert & S. Brinker 10/1/91 *
 *                    NT version          - I. Minkin 3/08/96              *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"

#define FILREV "$Revision: 5 $"

#ifdef GCDOS
#pragma inline
#pragma warn -par

#define WINDOX ((80-66)/2)    /* screen coordinates of pop-up window       */
#define WINDOY 8
#define SAVEXT 164            /* extra bytes to save to cover shadow       */

static VOID interrupt
critic(UINT bp,UINT di,UINT si,
       UINT ds,UINT es,UINT dx,
       UINT cx,UINT bx,UINT ax);

VOID
setcrit(VOID)                 /* set DOS critical error handler vector     */
{
asm  push ds
asm  mov  dx,offset critic
asm  mov  ax,cs
asm  mov  ds,ax
asm  mov  ah,25H
asm  mov  al,24H
asm  INT  21H
asm  pop  ds
}

static VOID interrupt
critic(bp,di,si,ds,es,dx,cx,bx,ax) /* user-friendly critical error handler */
UINT bp,di,si,ds,es,dx,cx,bx,ax;
{
     extern INT pxoff,pyoff;
     INT savex,savey,savepxo,savepyo;
     CHAR cresp[2];
     INT i;
     static INT yikes[]={
          0x4EDB,0x4EDF,0x4EDF,0x4EDF,0x4EDF,0x4EDF,0x4EDF,0x4EDF,
          0x4EDF,0x4EDF,0x4EDF,0x4EDF,0x4EDF,0x4EDF,0x4EDF,0x4EDF,
          0x4EDF,0x4EDF,0x4EDF,0x4EDF,0x4EDF,0x4EDF,0x4EDF,0x4EDF,
          0x4EDF,0x4EDF,0x4EDF,0x4EDF,0x4EDF,0x4EDF,0x4EDF,0x4EDF,
          0x4EDF,0x4EDF,0x4EDF,0x4EDF,0x4EDF,0x4EDF,0x4EDF,0x4EDF,
          0x4EDF,0x4EDF,0x4EDF,0x4EDF,0x4EDF,0x4EDF,0x4EDF,0x4EDF,
          0x4EDF,0x4EDF,0x4EDF,0x4EDF,0x4EDF,0x4EDF,0x4EDF,0x4EDF,
          0x4EDF,0x4EDF,0x4EDF,0x4EDF,0x4EDF,0x4EDF,0x4EDF,0x4EDF,
          0x4EDF,0x4EDF,0x4EDB,0x0720,0x0720,0x0720,0x0720,0x0720,
          0x0720,0x0720,0x0720,0x0720,0x0720,0x0720,0x0720,0x0720,
          0x4EDB,0x4F20,0x4F20,0x4F49,0x4F20,0x4F61,0x4F6D,0x4F20,
          0x4F75,0x4F6E,0x4F61,0x4F62,0x4F6C,0x4F65,0x4F20,0x4F74,
          0x4F6F,0x4F20,0x4F72,0x4F65,0x4F61,0x4F64,0x4F20,0x4F66,
          0x4F72,0x4F6F,0x4F6D,0x4F20,0x4F74,0x4F68,0x4F65,0x4F20,
          0x4F22,0x4F58,0x4F59,0x4F5A,0x4F22,0x4F20,0x4F64,0x4F65,
          0x4F76,0x4F69,0x4F63,0x4F65,0x4F20,0x4F70,0x4F72,0x4F6F,
          0x4F70,0x4F65,0x4F72,0x4F6C,0x4F79,0x4F2E,0x4F20,0x4F20,
          0x4F54,0x4F68,0x4F69,0x4F73,0x4F20,0x4F20,0x4F20,0x4F20,
          0x4F20,0x4F20,0x4EDB,0x0720,0x0720,0x0720,0x0720,0x0720,
          0x0720,0x0720,0x0720,0x0720,0x0720,0x0720,0x0720,0x0720,
          0x4EDB,0x4F20,0x4F20,0x4F6D,0x4F61,0x4F79,0x4F20,0x4F62,
          0x4F65,0x4F20,0x4F64,0x4F75,0x4F65,0x4F20,0x4F74,0x4F6F,
          0x4F20,0x4F73,0x4F65,0x4F76,0x4F65,0x4F72,0x4F61,0x4F6C,
          0x4F20,0x4F66,0x4F61,0x4F63,0x4F74,0x4F6F,0x4F72,0x4F73,
          0x4F2E,0x4F20,0x4F20,0x4F49,0x4F66,0x4F20,0x4F69,0x4F74,
          0x4F20,0x4F69,0x4F73,0x4F20,0x4F6E,0x4F6F,0x4F74,0x4F20,
          0x4F63,0x4F6C,0x4F65,0x4F61,0x4F72,0x4F20,0x4F74,0x4F6F,
          0x4F20,0x4F79,0x4F6F,0x4F75,0x4F20,0x4F77,0x4F68,0x4F79,
          0x4F20,0x4F20,0x4EDB,0x0720,0x0720,0x0720,0x0720,0x0720,
          0x0720,0x0720,0x0720,0x0720,0x0720,0x0720,0x0720,0x0720,
          0x4EDB,0x4F20,0x4F20,0x4F74,0x4F68,0x4F69,0x4F73,0x4F20,
          0x4F65,0x4F72,0x4F72,0x4F6F,0x4F72,0x4F20,0x4F68,0x4F61,
          0x4F73,0x4F20,0x4F6F,0x4F63,0x4F63,0x4F75,0x4F72,0x4F72,
          0x4F65,0x4F64,0x4F2C,0x4F20,0x4F63,0x4F6F,0x4F6E,0x4F74,
          0x4F61,0x4F63,0x4F74,0x4F20,0x4F79,0x4F6F,0x4F75,0x4F72,
          0x4F20,0x4F73,0x4F79,0x4F73,0x4F74,0x4F65,0x4F6D,0x4F20,
          0x4F61,0x4F64,0x4F6D,0x4F69,0x4F6E,0x4F69,0x4F73,0x4F74,
          0x4F72,0x4F61,0x4F74,0x4F6F,0x4F72,0x4F2E,0x4F20,0x4F20,
          0x4F20,0x4F20,0x4EDB,0x0720,0x0720,0x0720,0x0720,0x0720,
          0x0720,0x0720,0x0720,0x0720,0x0720,0x0720,0x0720,0x0720,
          0x4EDB,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,
          0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,
          0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,
          0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,
          0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,
          0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,
          0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,
          0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,
          0x4F20,0x4F20,0x4EDB,0x0720,0x0720,0x0720,0x0720,0x0720,
          0x0720,0x0720,0x0720,0x0720,0x0720,0x0720,0x0720,0x0720,
          0x4EDB,0x4F20,0x4F20,0x4F59,0x4F6F,0x4F75,0x4F72,0x4F20,
          0x4F63,0x4F68,0x4F6F,0x4F69,0x4F63,0x4F65,0x4F73,0x4F20,
          0x4F61,0x4F72,0x4F65,0x4F3A,0x4F20,0x4F20,0x4F20,0x4F20,
          0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,
          0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,
          0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,
          0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,
          0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,
          0x4F20,0x4F20,0x4EDB,0x0720,0x0720,0x0720,0x0720,0x0720,
          0x0720,0x0720,0x0720,0x0720,0x0720,0x0720,0x0720,0x0720,
          0x4EDB,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,
          0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,
          0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,
          0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,
          0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,
          0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,
          0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,
          0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,
          0x4F20,0x4F20,0x4EDB,0x0720,0x0720,0x0720,0x0720,0x0720,
          0x0720,0x0720,0x0720,0x0720,0x0720,0x0720,0x0720,0x0720,
          0x4EDB,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4E41,0x4F20,
          0x4F2E,0x4F2E,0x4F2E,0x4F20,0x4F74,0x4F6F,0x4F20,0x4F61,
          0x4F62,0x4F6F,0x4F72,0x4F74,0x4F20,0x4F74,0x4F68,0x4F69,
          0x4F73,0x4F20,0x4F70,0x4F72,0x4F6F,0x4F67,0x4F72,0x4F61,
          0x4F6D,0x4F20,0x4F61,0x4F6E,0x4F64,0x4F20,0x4F72,0x4F65,
          0x4F74,0x4F75,0x4F72,0x4F6E,0x4F20,0x4F74,0x4F6F,0x4F20,
          0x4F44,0x4F4F,0x4F53,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,
          0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,
          0x4F20,0x4F20,0x4EDB,0x0720,0x0720,0x0720,0x0720,0x0720,
          0x0720,0x0720,0x0720,0x0720,0x0720,0x0720,0x0720,0x0720,
          0x4EDB,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4E52,0x4F20,
          0x4F2E,0x4F2E,0x4F2E,0x4F20,0x4F74,0x4F6F,0x4F20,0x4F72,
          0x4F65,0x4F2D,0x4F74,0x4F72,0x4F79,0x4F20,0x4F74,0x4F68,
          0x4F65,0x4F20,0x4F64,0x4F69,0x4F73,0x4F6B,0x4F20,0x4F6F,
          0x4F70,0x4F65,0x4F72,0x4F61,0x4F74,0x4F69,0x4F6F,0x4F6E,
          0x4F20,0x4F61,0x4F67,0x4F61,0x4F69,0x4F6E,0x4F20,0x4F20,
          0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,
          0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,
          0x4F20,0x4F20,0x4EDB,0x0720,0x0720,0x0720,0x0720,0x0720,
          0x0720,0x0720,0x0720,0x0720,0x0720,0x0720,0x0720,0x0720,
          0x4EDB,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4E49,0x4F20,
          0x4F2E,0x4F2E,0x4F2E,0x4F20,0x4F74,0x4F6F,0x4F20,0x4F69,
          0x4F67,0x4F6E,0x4F6F,0x4F72,0x4F65,0x4F20,0x4F74,0x4F68,
          0x4F65,0x4F20,0x4F65,0x4F72,0x4F72,0x4F6F,0x4F72,0x4F20,
          0x4F61,0x4F6E,0x4F64,0x4F20,0x4F70,0x4F72,0x4F6F,0x4F63,
          0x4F65,0x4F65,0x4F64,0x4F20,0x4F28,0x4F6E,0x4F6F,0x4F74,
          0x4F20,0x4F72,0x4F65,0x4F63,0x4F6F,0x4F6D,0x4F6D,0x4F65,
          0x4F6E,0x4F64,0x4F65,0x4F64,0x4F29,0x4F20,0x4F20,0x4F20,
          0x4F20,0x4F20,0x4EDB,0x0720,0x0720,0x0720,0x0720,0x0720,
          0x0720,0x0720,0x0720,0x0720,0x0720,0x0720,0x0720,0x0720,
          0x4EDB,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,
          0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,
          0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,
          0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,
          0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,
          0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,
          0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,
          0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,0x4F20,
          0x4F20,0x4F20,0x4EDB,0x0720,0x0720,0x0720,0x0720,0x0720,
          0x0720,0x0720,0x0720,0x0720,0x0720,0x0720,0x0720,0x0720,
          0x4EDB,0x4F20,0x4F20,0x4F54,0x4F79,0x4F70,0x4F65,0x4F20,
          0x4F79,0x4F6F,0x4F75,0x4F72,0x4F20,0x4F63,0x4F68,0x4F6F,
          0x4F69,0x4F63,0x4F65,0x4F20,0x4F28,0x4E41,0x4F62,0x4F6F,
          0x4F72,0x4F74,0x4F2C,0x4F20,0x4E52,0x4F65,0x4F74,0x4F72,
          0x4F79,0x4F2C,0x4F20,0x4F6F,0x4F72,0x4F20,0x4E49,0x4F67,
          0x4F6E,0x4F6F,0x4F72,0x4F65,0x4F29,0x4F20,0x4F61,0x4F6E,
          0x4F64,0x4F20,0x4F70,0x4F72,0x4F65,0x4F73,0x4F73,0x4F20,
          0x4F11,0x4FC4,0x4FD9,0x4F3A,0x4F20,0x4F20,0x4F20,0x4F20,
          0x4F20,0x4F20,0x4EDB,0x0720,0x0720,0x0720,0x0720,0x0720,
          0x0720,0x0720,0x0720,0x0720,0x0720,0x0720,0x0720,0x0720,
          0x4EDB,0x4EDC,0x4EDC,0x4EDC,0x4EDC,0x4EDC,0x4EDC,0x4EDC,
          0x4EDC,0x4EDC,0x4EDC,0x4EDC,0x4EDC,0x4EDC,0x4EDC,0x4EDC,
          0x4EDC,0x4EDC,0x4EDC,0x4EDC,0x4EDC,0x4EDC,0x4EDC,0x4EDC,
          0x4EDC,0x4EDC,0x4EDC,0x4EDC,0x4EDC,0x4EDC,0x4EDC,0x4EDC,
          0x4EDC,0x4EDC,0x4EDC,0x4EDC,0x4EDC,0x4EDC,0x4EDC,0x4EDC,
          0x4EDC,0x4EDC,0x4EDC,0x4EDC,0x4EDC,0x4EDC,0x4EDC,0x4EDC,
          0x4EDC,0x4EDC,0x4EDC,0x4EDC,0x4EDC,0x4EDC,0x4EDC,0x4EDC,
          0x4EDC,0x4EDC,0x4EDC,0x4EDC,0x4EDC,0x4EDC,0x4EDC,0x4EDC,
          0x4EDC,0x4EDC,0x4EDB
     };
     static CHAR scnsav[sizeof(yikes)+SAVEXT];
     static struct curatr savatr;
     static CHAR *crechc[]={"A","R","I",NULL};

     enairp();
     for (i=0 ; i < nelems(yikes) ; i++) {
          if (!color) {
               yikes[i]&=0x8FFF;
               yikes[i]|=0x0F00;
          }
     }
     movmem(&curatr,&savatr,sizeof(struct curatr));
     savex=curcurx();
     savey=curcury();
     savepxo=pxoff;
     savepyo=pyoff;
     scn2mem(scnsav,gvscnoff(WINDOX,WINDOY),sizeof(scnsav));
     explodeto((CHAR *)yikes,0,0,66,12,WINDOX,WINDOY);
     setwin(0L,3+WINDOX,1+WINDOY,65+WINDOX,11+WINDOY,0);
     setatr(0x4F);
     locate(3+WINDOX,1+WINDOY);
     if ((ax&0x8000) == 0) {
          printf((ax&0x1F) < 2 ?
          "I am unable to %s the %c: drive properly.  If the drive\n"
          "door is open, please close it.  If the disk has been inserted\n"
          "backwards or upside down, please re-insert it correctly.     "
            :
          "I am unable to %s the %c: drive properly.  If this is a\n"
          "network drive, check with your system administrator.  If not,\n"
          "the problem may be with your disk hardware or device drivers."
            ,(ax&0x0100) ? "write to" : "read from",(ax&0x1F)+'A');
     }
     else {
          printf("I am unable to access the \"%.8s\" device properly.  This",
            MK_FP(bp,si+10));
     }
     strcpy(cresp,"R");
     edtchc(61,11,cresp,crechc,USEPOFF);
     mem2scn(scnsav,gvscnoff(WINDOX,WINDOY),sizeof(scnsav));
     proff(savepxo,savepyo);
     locate(savex,savey);
     movmem(&savatr,&curatr,sizeof(struct curatr));
     ax=(ax&0xFF00)+findstg(cresp,"RA");
     if ((ax&0xFF) == 2) {
          locate(0,24);
     }
}
#else
VOID
setcrit(VOID)                      /* crit error handler (active flavor)   */
{
// Does not need to do anything for NT since it is already user friendly
}
#endif
