/***************************************************************************
 *                                                                         *
 *   SAMEAS.C                                                              *
 *                                                                         *
 *   Copyright (c) 1987-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the GCOMM.LIB routine returning 1 if the passed strings       *
 *   are the same as one another (upper/lower case differences are         *
 *   ignored), 0 otherwise.                                                *
 *                                                                         *
 *                                            - T. Stryker 2/3/92          *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"

#define FILREV "$Revision: 7 $"

GBOOL                              /*   returns TRUE=same FALSE=different  */
sameas(                            /* are strings identical? (ignores case)*/
const CHAR *stg1,                  /*   first string to compare            */
const CHAR *stg2)                  /*   second string to compare           */
{
     while (*stg1 != '\0') {
          if (tolower(*stg1) != tolower(*stg2)) {
               return(FALSE);
          }
          stg1++;
          stg2++;
     }
     return(*stg2 == '\0' ? TRUE : FALSE);
}
