/***************************************************************************
 *                                                                         *
 *   NOALEN.C                                                              *
 *                                                                         *
 *   Copyright (c) 1987-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the GCOMM.LIB routine for getting the non-ANSI length of      *
 *   a string possibly containing ANSI (the actual displayed length).      *
 *                                                                         *
 *                                                 - C. Robert 5/26/92     *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"

#define FILREV "$Revision: 4 $"

INT                                /*   ret the actual non-ANSI len of stg */
noalen(                            /* calculate non-ANSI length            */
CHAR *stg)                         /*   ANSI string to get length of       */
{
     INT inans=0,retval=0;

     while (*stg != '\0') {
          if (inans && isalpha(*stg)) {
               inans=0;
          }
          else if (*stg == ESC && *(stg+1) == '[') {
               inans=1;
          }
          else if (!inans) {
               retval++;
          }
          stg++;
     }
     return(retval);
}


