/***************************************************************************
 *                                                                         *
 *   MSGSCAN.C                                                             *
 *                                                                         *
 *   Copyright (c) 1987-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the GCOMM.LIB routine for finding the value of an option      *
 *   in an .MSG file by direct text scanning.                              *
 *                                                                         *
 *   Don't use on 'S' or 'T' type options.                                 *
 *                                                                         *
 *                                            - T. Stryker 4/1/92          *
 *                                            - R. Stein 1/28/93           *
 *                                                                         *
 *   Added mstscan() function; an 'S' and 'T' type option compatible       *
 *   msgscan() function.                                                   *
 *                                                                         *
 *                                            - C. Dunn 12/5/94            *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"

#define FILREV "$Revision: 5 $"

CHAR *                             /*   return NULL if vblnam not found    */
msgscan(                           /* scan for vblnam in msgfil, no 'T'/'S'*/
CHAR *msgfil,                      /*   .MSG file to scan (w/ .MSG ext.)   */
CHAR *vblnam)                      /*   variable name to scan for          */
{
     inimsgrdr(200);
     if ((rdfp=fopen(msgfil,FOPRB)) != NULL) {
          while (rdmsg()) {
               if (sameas(msgnam,vblnam)) {
                    fclose(rdfp);
                    return(lastwd(txtbuf));
               }
          }
          fclose(rdfp);
     }
     return(NULL);
}

CHAR *                             /*   return NULL if vblnam not found    */
mstscan(                           /* 'S' and 'T' type compatible msgscan  */
CHAR *msgfil,                      /*   .MSG file to scan (w/ .MSG ext.)   */
CHAR *vblnam,                      /*   variable name to scan for          */
INT maxsiz)                        /*   maximum buffer size for option     */
{
     inimsgrdr(maxsiz);
     if ((rdfp=fopen(msgfil,FOPRB)) != NULL) {
          while (rdmsg()) {
               if (sameas(msgnam,vblnam)) {
                    fclose(rdfp);
                    return(txtbuf);
               }
          }
          fclose(rdfp);
     }
     return(NULL);
}
