/***************************************************************************
 *                                                                         *
 *   MLTSTUFF.C                                                            *
 *                                                                         *
 *   Copyright (c) 1993-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   Multilingual user output                                              *
 *                                                                         *
 *                                            - R. Stein 1/31/93           *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"

/* don't know why, but VC++ gives redefinition warning on FILREV */
#undef FILREV
#define FILREV "$Revision: 5 $"

VOID *prfbuffers;                  /* tiled array of prf() output buffers  */
CHAR **prfpointers;                /* array of ptrs into the prfbuffers[]  */
CHAR *linuse;                      /* return array of cklonl()             */

VOID
inimlt(                            /* initialize multilingual prf-stuff    */
UINT pbsize)                       /*   size of each buffer                */
{
     linuse=alcmem(nlingo);
     prfbuffers=alcblok((USHORT)nlingo,(USHORT)pbsize);
     iniprf((CHAR *)ptrblok(prfbuffers,0),pbsize);
     prfpointers=(CHAR **)alczer(nlingo*(sizeof(CHAR *)));
     clrmlt();
}

VOID
clrmlt(VOID)                       /* clear all buffers and pointers       */
{
     INT ilingo;

     for (ilingo=0 ; ilingo < nlingo ; ilingo++) {
          *(prfpointers[ilingo]=ptrblok(prfbuffers,(USHORT)ilingo))='\0';
     }
     prfptr=prfbuf;
}

VOID
cklonl(VOID)                       /* check languages represented online   */
{
     INT unum;

     setmem(linuse,nlingo,0);
     for (unum=0 ; unum < nterms ; unum++) {
          linuse[usroff(unum)->lingo]=1;
     }
     linuse[0]=1;
}

VOID
outmlt(                            /* output multilingual message to a user*/
INT chan)                          /*   channel number to output to        */
{
     INT ilingo;

     btuxmt(chan,ptrblok(prfbuffers,(USHORT)usroff(chan)->lingo));
     for (ilingo=0 ; ilingo < nlingo ; ilingo++) {
          prfpointers[ilingo]=ptrblok(prfbuffers,(USHORT)ilingo);
     }
     prfptr=prfbuf;
}
