/***************************************************************************
 *                                                                         *
 *   MDFUTL.C                                                              *
 *                                                                         *
 *   Copyright (c) 1995-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This file contains utility routines for dealing with .MDF files.      *
 *                                                                         *
 *                                                 - C. Robert 12/5/94     *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"

#define FILREV "$Revision: 5 $"

#define MNMPFX "Module name:"      /* module name prefix in .MDF file      */
#define DFLPFX "Dynamic Btrieve files:" /* dynamic btrieve files prefix    */

static CHAR tmpbuf[BUFSIZ];        /* temporary buffer for reading/writing */

CHAR *                             /*   returns ptr to name of module      */
gmdnam(                            /* get a module's name from .MDF file   */
CHAR *mdfnam)                      /*   name of module's .MDF file         */
{
     CHAR *retval;

     retval=scnmdf(mdfnam,MNMPFX);
     if (*retval == '\0') {
          catastro("GMDNAM: NO MODULE NAME IN \"%s\"",mdfnam);
     }
     return(retval);
}

INT                                /*   returns number of dynamic Btrieve f*/
gnumdb(                            /* get # of dynamic Btrieve files       */
CHAR *mdfnam)                      /*   .MDF file to get number from       */
{
     return(atoi(scnmdf(mdfnam,DFLPFX)));
}

VOID
snumdb(                            /* set # of dynamic Btrieve files       */
CHAR *mdfnam,                      /*   .MDF file to set number in         */
INT ndbfils)                       /*   # of dynamic Btrieve files to set  */
{
     FILE *infp,*outfp;
     CHAR *actfil,newfil[GCMAXPTH],*tmpp;

     actfil=mdfodmd(mdfnam);
     stlcpy(newfil,actfil,GCMAXPTH);
     if ((tmpp=strchr(newfil,'.')) != NULL) {
          *tmpp='\0';
     }
     stlcat(newfil,".new",GCMAXPTH);
     if ((infp=fopen(actfil,FOPRA)) == NULL) {
          catastro("CAN'T READ FROM \"%s\"!",actfil);
     }
     if ((outfp=fopen(newfil,FOPWA)) == NULL) {
          catastro("CAN'T WRITE TO \"%s\"!",newfil);
     }
     while (fgets(tmpbuf,BUFSIZ,infp) != NULL) {
          if (sameto(DFLPFX,tmpbuf)) {
               sprintf(tmpbuf,"%s %d\n",DFLPFX,ndbfils);
          }
          fputs(tmpbuf,outfp);
     }
     fclose(infp);
     fclose(outfp);
     unlink(actfil);
     if (rename(newfil,actfil) != 0) {
          catastro("CAN'T REPLACE \"%s\"!",actfil);
     }
}

CHAR *                             /*   returns ptr to value of option     */
scnmdf(                            /* low-level .MDF scanner utility       */
CHAR *mdfnam,                      /*   .MDF file to scan                  */
CHAR *linpfx)                      /*   for this line prefix               */
{
     FILE *fp;
     CHAR *retval;

     if ((fp=fopen(mdfodmd(mdfnam),FOPRA)) == NULL) {
          catastro("SCNMDF: CAN'T OPEN \"%s\"!",mdfodmd(mdfnam));
     }
     retval="";
     while (fgets(tmpbuf,BUFSIZ,fp) != NULL) {
          if (sameto(linpfx,tmpbuf)) {
               unpad(tmpbuf);
               retval=skpwht(tmpbuf+strlen(linpfx));
               break;
          }
     }
     fclose(fp);
     return(retval);
}

CHAR *                             /*  rets module name from MDF/DMD file  */
mdfodmd(                           /* get .MDF or .DMD name from .MDF name */
CHAR *mdfnam)                      /*   .MDF file name to get name for     */
{
     CHAR *tmpp;
     static CHAR retfnm[GCMAXPTH];

     stlcpy(retfnm,mdfnam,GCMAXPTH);
     if (!isfile(retfnm)) {
          if ((tmpp=strchr(retfnm,'.')) != NULL) {
               *tmpp='\0';
          }
          stlcat(retfnm,".dmd",GCMAXPTH);
          if (!isfile(retfnm)) {
               catastro("MDFODMD: CAN'T FIND \"%s\"!",mdfnam);
          }
     }
     return(retfnm);
}
