/***************************************************************************
 *                                                                         *
 *   LASTWD.C                                                              *
 *                                                                         *
 *   Copyright (c) 1987-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the GCOMM.LIB routine for finding the last word in a given    *
 *   string.                                                               *
 *                                                                         *
 *                                            - R. Stein 3/24/92           *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"

#define FILREV "$Revision: 4 $"

CHAR *                             /*   returns ptr to last word           */
lastwd(                            /* find last word of a string           */
CHAR *string)                      /*   string to be searched              */
{
     CHAR *cp;

     if (*string == '\0') {
          return(string);
     }
     for (cp=string+strlen(string)-1 ; cp >= string && isspace(*cp) ; cp--) {
          if (cp == string) {
               return(cp);
          }
     }
     for ( ; cp >= string && !isspace(*cp) ; cp--) {
          if (cp == string) {
               return(cp);
          }
     }
     return(cp+1);
}
