/***************************************************************************
 *                                                                         *
 *   KBDAPI.C                                                              *
 *                                                                         *
 *   Copyright (C) 1996-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   Keyboard API                                                          *
 *                                                                         *
 *                                        - Ilya Minkin 01/26/96           *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"

#define FILREV "$Revision: 4 $"

#ifdef GCDOS
#pragma inline

static UCHAR lastKeyScan=0;
#endif // GCDOS

USHORT
getchc(VOID)                       /* get composite key id                 */
{
#ifdef GCDOS
#ifdef __HUGE__
     asm  push ds
     asm  mov  ax,KBDAPI_DATA      /* Manually load DS!                    */
     asm  mov  ds,ax               /* ...Borland 4 won't without a C ref   */
#endif // __HUGE__
     asm  mov  ah,0                /* call bios keyboard interrupt         */
     asm  int  0x16
     asm  mov  lastKeyScan,ah      /* save scan code part                  */
     asm  or   al,al               /* ASCII part zero?                     */
     asm  jz   getchc_ret          /* yes, return as it stands             */
     asm  xor  ah,ah               /* no, clear high-order byte            */
getchc_ret:
#ifdef __HUGE__
     asm  pop  ds
#endif // __HUGE__
     return(_AX);
#else // GCDOS
     INT ch;

     ch=getch();
     if (ch == 0) {
          return((USHORT)(getch()*0x100));
     }
     return((USHORT)ch);
#endif // GCDOS
}

#ifdef GCDOS

USHORT                             /*   scan code                          */
lascan(VOID)                       /* get scan code assoc w/last getchc()  */
{
     return((USHORT)lastKeyScan);
}

#endif
