/***************************************************************************
 *                                                                         *
 *   ITEMIDX.C                                                             *
 *                                                                         *
 *   Copyright (c) 1987-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   These are the GCOMM.LIB routines which manipulate TAB- and otherwise  *
 *   delimited strings, allowing an indexed field to be extracted from     *
 *   them.                                                                 *
 *                                                                         *
 *                                            - D. Pitchford 9/19/94       *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"

#define FILREV "$Revision: 6 $"

#define IDXDEFSZ 80                /* default & incremental return buf size*/

static CHAR *idxret=NULL;          /* return buffer pointer, dynamic       */

static INT idxbufsz;               /* current size of return buffer        */

CHAR *                             /*   return any-delim'd string's substg */
itemidxd(                          /* search for any delim'd stg's substg  */
const CHAR *ctlstg,                /*   string to search                   */
INT index,                         /*   index of substring to return       */
const CHAR *delim)                 /*   string to search for               */
{
     INT lendelim,num2copy;
     const CHAR *s;

     if (idxret == NULL) {
          idxbufsz=IDXDEFSZ;
          idxret=alcmem(idxbufsz);
     }
     lendelim=strlen(delim);
     while (index-- > 0) {
          if ((s=strstr(ctlstg,delim)) == NULL) {
               setmem(idxret,idxbufsz,0);
               return(idxret);
          }
          ctlstg=s+lendelim;
     }
     s=strstr(ctlstg,delim);
     num2copy=(s == NULL) ? strlen(ctlstg) : (INT)(s-ctlstg);
     if (num2copy >= idxbufsz) {
          free(idxret);
          idxbufsz=IDXDEFSZ*(num2copy/IDXDEFSZ+1);
          idxret=alcmem(idxbufsz);
     }
     setmem(idxret,idxbufsz,0);
     memcpy(idxret,ctlstg,num2copy);
     return(idxret);
}

CHAR *                             /*   return tab-delim'd string's substg */
itemidx(                           /* search for tab-delim'd stg's substg  */
const CHAR *ctlstg,                /*   string to search                   */
INT index)                         /*   index of substring to return       */
{
     return(itemidxd(ctlstg,index,"\t"));
}

INT                                /*   # of occurences of delim'd substg  */
itemcntd(                          /* instances of delimited substrings    */
const CHAR *ctlstg,                /*   string to search                   */
const CHAR *delim)                 /*   string to search for               */
{
     INT retval=1,lendelim;

     lendelim=strlen(delim);
     while ((ctlstg=strstr(ctlstg,delim)) != NULL) {
          ctlstg+=lendelim;
          retval++;
     }
     return(retval);
}

INT                                /*   # of occurences tab-delim'd substg */
itemcnt(                           /* instances of TAB delim'd substrings  */
const CHAR *ctlstg)                /*   string to search                   */
{
     return(itemcntd(ctlstg,"\t"));
}
