/***************************************************************************
 *                                                                         *
 *   GETASC.C                                                              *
 *                                                                         *
 *   Copyright (c) 1987-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the GCOMM.LIB routine for getting an MCV message in a form    *
 *   that can be output via btuxct() in transparent binary output mode.    *
 *                                                                         *
 *   prfasc() is like prfmsg(), except it uses getasc().  (No text         *
 *   variable translation is done by prfasc())                             *
 *                                                                         *
 *                                            - T. Stryker 3/24/92         *
 *                                            - R. Stein 6/23/94           *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"

#define FILREV "$Revision: 4 $"

CHAR *                             /*   returns ptr to message buffer      */
getasc(                            /* like getmsg() but cvts EOLs to \r\n  */
INT msgnum)                        /*   message number to read             */
{
     CHAR *cp;
     USHORT n2read,nroom;
     INT c;

     n2read=msgseek(msgnum);
     nroom=mxmssz-n2read;
     for (cp=msgbuf ; n2read > 0 ; n2read--) {
          switch (c=getc(lclmbk->msgfp)) {
          case EOF:
               catastro("getasc: READ ERROR INDEX %d IN %s",msgnum,
                        lclmbk->filnam);
               break;
          case '\r':
          case '\n':
               if (nroom > 0) {
                    *cp++='\r';
                    *cp++='\n';
                    nroom--;
                    break;
               }
               starit=1;
          default:
               *cp++=(CHAR)c;
               break;
          }
     }
     if (starit) {
          movmem("*",msgbuf+mxmssz-2,2);
     }
     lclmbk->lstmsg=msgnum;
     return(msgbuf);
}

VOID
prfasc(
INT msgnum,
...)
{
     va_list ap;
     CHAR *p1,*p2,*p3,*p4;

     va_start(ap,msgnum);
     p1=va_arg(ap,CHAR *);
     p2=va_arg(ap,CHAR *);
     p3=va_arg(ap,CHAR *);
     p4=va_arg(ap,CHAR *);
     va_end(ap);

     prf(getasc(msgnum),p1,p2,p3,p4);
}
